/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShutdownStrategy
extends ServiceSupport
implements ShutdownStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShutdownStrategy.class);
    private CamelContext camelContext;
    private ExecutorService executor;
    private long timeout = 300L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;
    private boolean suppressLoggingOnTimeout;
    private boolean logInflightExchangesOnTimeout = true;
    private volatile boolean forceShutdown;
    private final AtomicBoolean timeoutOccurred = new AtomicBoolean();
    private volatile Future<?> currentShutdownTaskFuture;

    public DefaultShutdownStrategy() {
    }

    public DefaultShutdownStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void shutdown(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.shutdown(context, routes, this.getTimeout(), this.getTimeUnit());
    }

    @Override
    public void shutdownForced(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), false, false, true);
    }

    @Override
    public void suspend(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), true, false, false);
    }

    @Override
    public void shutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, false, false, false);
    }

    @Override
    public boolean shutdown(CamelContext context, RouteStartupOrder route, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
        routes.add(route);
        return this.doShutdown(context, routes, timeout, timeUnit, false, abortAfterTimeout, false);
    }

    @Override
    public void suspend(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doShutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly, boolean abortAfterTimeout, boolean forceShutdown) throws Exception {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        if (routes.isEmpty()) {
            return true;
        }
        StopWatch watch = new StopWatch();
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(routes);
        routesOrdered.sort(new Comparator<RouteStartupOrder>(){

            @Override
            public int compare(RouteStartupOrder o1, RouteStartupOrder o2) {
                return o1.getStartupOrder() - o2.getStartupOrder();
            }
        });
        if (this.shutdownRoutesInReverseOrder) {
            Collections.reverse(routesOrdered);
        }
        if (suspendOnly) {
            LOG.info("Starting to graceful suspend {} routes (timeout {} {})", new Object[]{routesOrdered.size(), timeout, timeUnit.toString().toLowerCase(Locale.ENGLISH)});
        } else {
            LOG.info("Starting to graceful shutdown {} routes (timeout {} {})", new Object[]{routesOrdered.size(), timeout, timeUnit.toString().toLowerCase(Locale.ENGLISH)});
        }
        this.timeoutOccurred.set(false);
        this.currentShutdownTaskFuture = this.getExecutorService().submit(new ShutdownTask(context, routesOrdered, timeout, timeUnit, suspendOnly, abortAfterTimeout, this.timeoutOccurred, this.isLogInflightExchangesOnTimeout()));
        try {
            this.currentShutdownTaskFuture.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e.getCause());
        }
        catch (Exception e) {
            this.timeoutOccurred.set(true);
            this.currentShutdownTaskFuture.cancel(true);
            this.forceShutdown = forceShutdown;
            if (!forceShutdown && abortAfterTimeout) {
                LOG.warn("Timeout occurred during graceful shutdown. Aborting the shutdown now. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                DefaultShutdownStrategy.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
                boolean bl = false;
                return bl;
            }
            if (forceShutdown || this.shutdownNowOnTimeout) {
                LOG.warn("Timeout occurred during graceful shutdown. Forcing the routes to be shutdown now. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                DefaultShutdownStrategy.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
                this.shutdownRoutesNow(routesOrdered);
                for (RouteStartupOrder order : routes) {
                    for (Service service : order.getServices()) {
                        DefaultShutdownStrategy.prepareShutdown(service, false, true, true, this.isSuppressLoggingOnTimeout());
                    }
                }
            } else {
                LOG.warn("Timeout occurred during graceful shutdown. Will ignore shutting down the remainder routes. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                DefaultShutdownStrategy.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
            }
        }
        finally {
            this.currentShutdownTaskFuture = null;
        }
        long seconds = TimeUnit.SECONDS.convert(watch.taken(), TimeUnit.MILLISECONDS);
        LOG.info("Graceful shutdown of {} routes completed in {} seconds", (Object)routesOrdered.size(), (Object)seconds);
        return true;
    }

    @Override
    public boolean forceShutdown(Service service) {
        return this.forceShutdown;
    }

    @Override
    public boolean hasTimeoutOccurred() {
        return this.timeoutOccurred.get();
    }

    @Override
    public void setTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.shutdownNowOnTimeout = shutdownNowOnTimeout;
    }

    @Override
    public boolean isShutdownNowOnTimeout() {
        return this.shutdownNowOnTimeout;
    }

    @Override
    public boolean isShutdownRoutesInReverseOrder() {
        return this.shutdownRoutesInReverseOrder;
    }

    @Override
    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.shutdownRoutesInReverseOrder = shutdownRoutesInReverseOrder;
    }

    @Override
    public boolean isSuppressLoggingOnTimeout() {
        return this.suppressLoggingOnTimeout;
    }

    @Override
    public void setSuppressLoggingOnTimeout(boolean suppressLoggingOnTimeout) {
        this.suppressLoggingOnTimeout = suppressLoggingOnTimeout;
    }

    @Override
    public boolean isLogInflightExchangesOnTimeout() {
        return this.logInflightExchangesOnTimeout;
    }

    @Override
    public void setLogInflightExchangesOnTimeout(boolean logInflightExchangesOnTimeout) {
        this.logInflightExchangesOnTimeout = logInflightExchangesOnTimeout;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Future<?> getCurrentShutdownTaskFuture() {
        return this.currentShutdownTaskFuture;
    }

    protected void shutdownRoutesNow(List<RouteStartupOrder> routes) {
        for (RouteStartupOrder order : routes) {
            ShutdownRunningTask current = order.getRoute().getRouteContext().getShutdownRunningTask();
            if (current != ShutdownRunningTask.CompleteCurrentTaskOnly) {
                LOG.debug("Changing shutdownRunningTask from {} to " + (Object)((Object)ShutdownRunningTask.CompleteCurrentTaskOnly) + " on route {} to shutdown faster", (Object)current, (Object)order.getRoute().getId());
                order.getRoute().getRouteContext().setShutdownRunningTask(ShutdownRunningTask.CompleteCurrentTaskOnly);
            }
            for (Consumer consumer : order.getInputs()) {
                DefaultShutdownStrategy.shutdownNow(consumer);
            }
        }
    }

    protected void shutdownNow(List<Consumer> consumers) {
        for (Consumer consumer : consumers) {
            DefaultShutdownStrategy.shutdownNow(consumer);
        }
    }

    protected static void shutdownNow(Consumer consumer) {
        LOG.trace("Shutting down: {}", (Object)consumer);
        try {
            ServiceHelper.stopService(consumer);
        }
        catch (Throwable e) {
            LOG.warn("Error occurred while shutting down route: " + consumer + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure(consumer.getEndpoint().getCamelContext(), consumer, e);
        }
        LOG.trace("Shutdown complete for: {}", (Object)consumer);
    }

    protected static void suspendNow(Consumer consumer) {
        LOG.trace("Suspending: {}", (Object)consumer);
        try {
            ServiceHelper.suspendService(consumer);
        }
        catch (Throwable e) {
            LOG.warn("Error occurred while suspending route: " + consumer + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure(consumer.getEndpoint().getCamelContext(), consumer, e);
        }
        LOG.trace("Suspend complete for: {}", (Object)consumer);
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = this.camelContext.getExecutorServiceManager().newThreadPool(this, "ShutdownTask", 0, 1);
        }
        return this.executor;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        this.forceShutdown = false;
        this.timeoutOccurred.set(false);
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    private static void prepareShutdown(Service service, boolean suspendOnly, boolean forced, boolean includeChildren, boolean suppressLogging) {
        Set<Service> list;
        if (includeChildren) {
            list = ServiceHelper.getChildServices(service, true);
        } else {
            list = new LinkedHashSet<Service>(1);
            list.add(service);
        }
        for (Service child : list) {
            if (!(child instanceof ShutdownPrepared)) continue;
            try {
                LOG.trace("Preparing {} shutdown on {}", (Object)(forced ? "forced" : ""), (Object)child);
                ((ShutdownPrepared)((Object)child)).prepareShutdown(suspendOnly, forced);
            }
            catch (Exception e) {
                if (suppressLogging) {
                    LOG.trace("Error during prepare shutdown on " + child + ". This exception will be ignored.", (Throwable)e);
                    continue;
                }
                LOG.warn("Error during prepare shutdown on " + child + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    protected static int getPendingInflightExchanges(RouteStartupOrder order) {
        int inflight = 0;
        for (Service service : order.getServices()) {
            Set<Service> children = ServiceHelper.getChildServices(service);
            for (Service child : children) {
                if (!(child instanceof ShutdownAware)) continue;
                inflight += ((ShutdownAware)((Object)child)).getPendingExchangesSize();
            }
        }
        return inflight;
    }

    protected static void logInflightExchanges(CamelContext camelContext, List<RouteStartupOrder> routes, boolean infoLevel) {
        if (!infoLevel && !LOG.isDebugEnabled()) {
            return;
        }
        Collection<InflightRepository.InflightExchange> inflights = camelContext.getInflightRepository().browse();
        int size = inflights.size();
        if (size == 0) {
            return;
        }
        HashSet<String> routeIds = new HashSet<String>();
        for (RouteStartupOrder routeStartupOrder : routes) {
            routeIds.add(routeStartupOrder.getRoute().getId());
        }
        ArrayList<InflightRepository.InflightExchange> filtered = new ArrayList<InflightRepository.InflightExchange>();
        for (InflightRepository.InflightExchange inflight : inflights) {
            String routeId = inflight.getExchange().getFromRouteId();
            if (!routeIds.contains(routeId)) continue;
            filtered.add(inflight);
        }
        size = filtered.size();
        if (size == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("There are " + size + " inflight exchanges:");
        for (InflightRepository.InflightExchange inflight : filtered) {
            stringBuilder.append("\n\tInflightExchange: [exchangeId=").append(inflight.getExchange().getExchangeId()).append(", fromRouteId=").append(inflight.getExchange().getFromRouteId()).append(", routeId=").append(inflight.getRouteId()).append(", nodeId=").append(inflight.getNodeId()).append(", elapsed=").append(inflight.getElapsed()).append(", duration=").append(inflight.getDuration()).append("]");
        }
        if (infoLevel) {
            LOG.info(stringBuilder.toString());
        } else {
            LOG.debug(stringBuilder.toString());
        }
    }

    static class ShutdownTask
    implements Runnable {
        private final CamelContext context;
        private final List<RouteStartupOrder> routes;
        private final boolean suspendOnly;
        private final boolean abortAfterTimeout;
        private final long timeout;
        private final TimeUnit timeUnit;
        private final AtomicBoolean timeoutOccurred;
        private final boolean logInflightExchangesOnTimeout;

        ShutdownTask(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly, boolean abortAfterTimeout, AtomicBoolean timeoutOccurred, boolean logInflightExchangesOnTimeout) {
            this.context = context;
            this.routes = routes;
            this.suspendOnly = suspendOnly;
            this.abortAfterTimeout = abortAfterTimeout;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.timeoutOccurred = timeoutOccurred;
            this.logInflightExchangesOnTimeout = logInflightExchangesOnTimeout;
        }

        @Override
        public void run() {
            LOG.debug("There are {} routes to {}", (Object)this.routes.size(), (Object)(this.suspendOnly ? "suspend" : "shutdown"));
            ArrayList<ShutdownDeferredConsumer> deferredConsumers = new ArrayList<ShutdownDeferredConsumer>();
            for (RouteStartupOrder order : this.routes) {
                ShutdownRoute shutdownRoute = order.getRoute().getRouteContext().getShutdownRoute();
                ShutdownRunningTask shutdownRunningTask = order.getRoute().getRouteContext().getShutdownRunningTask();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}{} with options [{},{}]", new Object[]{this.suspendOnly ? "Suspending route: " : "Shutting down route: ", order.getRoute().getId(), shutdownRoute, shutdownRunningTask});
                }
                for (Consumer consumer : order.getInputs()) {
                    boolean shutdown;
                    boolean suspend = false;
                    boolean bl = shutdown = shutdownRoute != ShutdownRoute.Defer;
                    if (shutdown) {
                        if (consumer instanceof ShutdownAware) {
                            boolean bl2 = shutdown = !((ShutdownAware)((Object)consumer)).deferShutdown(shutdownRunningTask);
                        }
                        if (shutdown && consumer instanceof Suspendable) {
                            suspend = true;
                        }
                    }
                    if (suspend) {
                        DefaultShutdownStrategy.suspendNow(consumer);
                        deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer));
                        LOG.debug("Route: {} suspended and shutdown deferred, was consuming from: {}", (Object)order.getRoute().getId(), (Object)order.getRoute().getEndpoint());
                        continue;
                    }
                    if (shutdown) {
                        DefaultShutdownStrategy.shutdownNow(consumer);
                        LOG.info("Route: {} shutdown complete, was consuming from: {}", (Object)order.getRoute().getId(), (Object)order.getRoute().getEndpoint());
                        continue;
                    }
                    deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer));
                    LOG.debug("Route: " + order.getRoute().getId() + (this.suspendOnly ? " shutdown deferred." : " suspension deferred."));
                }
            }
            for (RouteStartupOrder order : this.routes) {
                for (Service service : order.getServices()) {
                    if (service instanceof Consumer) continue;
                    DefaultShutdownStrategy.prepareShutdown(service, this.suspendOnly, false, true, false);
                }
            }
            boolean done = false;
            long loopDelaySeconds = 1L;
            long loopCount = 0L;
            while (!done && !this.timeoutOccurred.get()) {
                int size = 0;
                LinkedHashMap<String, Integer> routeInflight = new LinkedHashMap<String, Integer>();
                for (RouteStartupOrder routeStartupOrder : this.routes) {
                    int inflight = this.context.getInflightRepository().size(routeStartupOrder.getRoute().getId());
                    if ((inflight += DefaultShutdownStrategy.getPendingInflightExchanges(routeStartupOrder)) <= 0) continue;
                    String routeId = routeStartupOrder.getRoute().getId();
                    routeInflight.put(routeId, inflight);
                    size += inflight;
                    LOG.trace("{} inflight and pending exchanges for route: {}", (Object)inflight, (Object)routeId);
                }
                if (size > 0) {
                    try {
                        CollectionStringBuffer csb = new CollectionStringBuffer();
                        for (Map.Entry entry : routeInflight.entrySet()) {
                            String row = String.format("%s = %s", entry.getKey(), entry.getValue());
                            csb.append(row);
                        }
                        String string2 = "Waiting as there are still " + size + " inflight and pending exchanges to complete, timeout in " + (TimeUnit.SECONDS.convert(this.timeout, this.timeUnit) - loopCount++ * loopDelaySeconds) + " seconds.";
                        string2 = string2 + " Inflights per route: [" + csb.toString() + "]";
                        LOG.info(string2);
                        DefaultShutdownStrategy.logInflightExchanges(this.context, this.routes, this.logInflightExchangesOnTimeout);
                        Thread.sleep(loopDelaySeconds * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (this.abortAfterTimeout) {
                            LOG.warn("Interrupted while waiting during graceful shutdown, will abort.");
                            return;
                        }
                        LOG.warn("Interrupted while waiting during graceful shutdown, will force shutdown now.");
                        break;
                    }
                }
                done = true;
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                Consumer consumer = deferred.getConsumer();
                if (!(consumer instanceof ShutdownAware)) continue;
                LOG.trace("Route: {} preparing to shutdown.", (Object)deferred.getRoute().getId());
                boolean bl = this.context.getShutdownStrategy().forceShutdown(consumer);
                boolean suppress = this.context.getShutdownStrategy().isSuppressLoggingOnTimeout();
                DefaultShutdownStrategy.prepareShutdown(consumer, this.suspendOnly, bl, false, suppress);
                LOG.debug("Route: {} preparing to shutdown complete.", (Object)deferred.getRoute().getId());
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                Consumer consumer = deferred.getConsumer();
                if (this.suspendOnly) {
                    DefaultShutdownStrategy.suspendNow(consumer);
                    LOG.info("Route: {} suspend complete, was consuming from: {}", (Object)deferred.getRoute().getId(), (Object)deferred.getConsumer().getEndpoint());
                    continue;
                }
                DefaultShutdownStrategy.shutdownNow(consumer);
                LOG.info("Route: {} shutdown complete, was consuming from: {}", (Object)deferred.getRoute().getId(), (Object)deferred.getConsumer().getEndpoint());
            }
            for (RouteStartupOrder order : this.routes) {
                for (Service service : order.getServices()) {
                    boolean forced = this.context.getShutdownStrategy().forceShutdown(service);
                    boolean suppress = this.context.getShutdownStrategy().isSuppressLoggingOnTimeout();
                    DefaultShutdownStrategy.prepareShutdown(service, this.suspendOnly, forced, true, suppress);
                }
            }
        }
    }

    static class ShutdownDeferredConsumer {
        private final Route route;
        private final Consumer consumer;

        ShutdownDeferredConsumer(Route route, Consumer consumer) {
            this.route = route;
            this.consumer = consumer;
        }

        Route getRoute() {
            return this.route;
        }

        Consumer getConsumer() {
            return this.consumer;
        }
    }
}

