/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.metatype.MetaData;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.XmlSnapshotIdResult;
import org.eclipse.kura.core.configuration.metatype.Tmetadata;
import org.eclipse.kura.core.inventory.resources.SystemBundles;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackages;
import org.eclipse.kura.core.inventory.resources.SystemPackages;
import org.eclipse.kura.core.inventory.resources.SystemResourcesInfo;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaBundlesMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaComponentConfigurationsMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaMetadataMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaPackagesMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaSnapshotIdResultMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaSystemPackagesMapper;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaSystemResourcesMapper;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlMarshallUnmarshallImpl
implements Marshaller,
Unmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(XmlMarshallUnmarshallImpl.class);
    private static final String VALUE_CONSTANT = "value";

    public String marshal(Object object) throws KuraException {
        StringWriter sw = new StringWriter();
        try {
            this.marshal(object, sw);
        }
        catch (Exception exception) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, new Object[]{VALUE_CONSTANT});
        }
        return sw.toString();
    }

    private void marshal(Object object, Writer w) throws Exception {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            docFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            docFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.setXmlStandalone(true);
            if (object instanceof XmlSnapshotIdResult) {
                new XmlJavaSnapshotIdResultMapper().marshal(doc, object);
            } else if (object instanceof XmlComponentConfigurations) {
                new XmlJavaComponentConfigurationsMapper().marshal(doc, object);
            } else if (object instanceof SystemDeploymentPackages) {
                new XmlJavaPackagesMapper().marshal(doc, object);
            } else if (object instanceof SystemBundles) {
                new XmlJavaBundlesMapper().marshal(doc, object);
            } else if (object instanceof SystemPackages) {
                new XmlJavaSystemPackagesMapper().marshal(doc, object);
            } else if (object instanceof SystemResourcesInfo) {
                new XmlJavaSystemResourcesMapper().marshal(doc, object);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(w);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            logger.warn("Parser Exception", (Throwable)pce);
        }
        catch (TransformerException tfe) {
            logger.warn("Transformer Exception", (Throwable)tfe);
        }
    }

    public <T> T unmarshal(String s, Class<T> clazz) throws KuraException {
        StringReader sr = new StringReader(s);
        return this.unmarshal(sr, clazz);
    }

    private <T> T unmarshal(Reader r, Class<T> clazz) throws KuraException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder parser = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            parser = factory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError fce) {
            logger.error("Parser Factory configuration Error");
            throw fce;
        }
        catch (ParserConfigurationException pce) {
            logger.error("Parser configuration exception");
            throw new FactoryConfigurationError(pce);
        }
        Document doc = null;
        try {
            InputSource is = new InputSource(r);
            doc = parser.parse(is);
            doc.getDocumentElement().normalize();
        }
        catch (IOException | IllegalArgumentException | SAXException se) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{VALUE_CONSTANT, se});
        }
        if (clazz.equals(XmlComponentConfigurations.class)) {
            try {
                return new XmlJavaComponentConfigurationsMapper().unmarshal(doc);
            }
            catch (Exception e) {
                throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{VALUE_CONSTANT, e});
            }
        }
        if (clazz.equals(MetaData.class) || clazz.equals(Tmetadata.class)) {
            return new XmlJavaMetadataMapper().unmarshal(doc);
        }
        throw new IllegalArgumentException("Class not supported!");
    }
}

