/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.usb;

import org.eclipse.kura.usb.UsbDevice;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class AbstractUsbDevice
implements UsbDevice {
    private final String vendorId;
    private final String productId;
    private final String manufacturerName;
    private final String productName;
    private final String usbBusNumber;
    private final String usbDevicePath;

    public AbstractUsbDevice(String vendorId, String productId, String manufacturerName, String productName, String usbBusNumber, String usbDevicePath) {
        this.vendorId = vendorId;
        this.productId = productId;
        this.manufacturerName = manufacturerName;
        this.productName = productName;
        this.usbBusNumber = usbBusNumber;
        this.usbDevicePath = usbDevicePath;
    }

    public AbstractUsbDevice(AbstractUsbDevice usbDevice) {
        this.vendorId = usbDevice.getVendorId();
        this.productId = usbDevice.getProductId();
        this.manufacturerName = usbDevice.getManufacturerName();
        this.productName = usbDevice.getProductName();
        this.usbBusNumber = usbDevice.getUsbBusNumber();
        this.usbDevicePath = usbDevice.getUsbDevicePath();
    }

    @Override
    public String getVendorId() {
        return this.vendorId;
    }

    @Override
    public String getProductId() {
        return this.productId;
    }

    @Override
    public String getManufacturerName() {
        return this.manufacturerName;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getUsbBusNumber() {
        return this.usbBusNumber;
    }

    @Override
    public String getUsbDevicePath() {
        return this.usbDevicePath;
    }

    @Override
    public String getUsbPort() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.usbBusNumber).append("-").append(this.usbDevicePath);
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.manufacturerName == null ? 0 : this.manufacturerName.hashCode());
        result = 31 * result + (this.productId == null ? 0 : this.productId.hashCode());
        result = 31 * result + (this.productName == null ? 0 : this.productName.hashCode());
        result = 31 * result + (this.usbBusNumber == null ? 0 : this.usbBusNumber.hashCode());
        result = 31 * result + (this.usbDevicePath == null ? 0 : this.usbDevicePath.hashCode());
        result = 31 * result + (this.vendorId == null ? 0 : this.vendorId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractUsbDevice other = (AbstractUsbDevice)obj;
        if (this.manufacturerName == null ? other.manufacturerName != null : !this.manufacturerName.equals(other.manufacturerName)) {
            return false;
        }
        if (this.productId == null ? other.productId != null : !this.productId.equals(other.productId)) {
            return false;
        }
        if (this.productName == null ? other.productName != null : !this.productName.equals(other.productName)) {
            return false;
        }
        if (this.usbBusNumber == null ? other.usbBusNumber != null : !this.usbBusNumber.equals(other.usbBusNumber)) {
            return false;
        }
        if (this.usbDevicePath == null ? other.usbDevicePath != null : !this.usbDevicePath.equals(other.usbDevicePath)) {
            return false;
        }
        return !(this.vendorId == null ? other.vendorId != null : !this.vendorId.equals(other.vendorId));
    }
}

