/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiCamelContextNameStrategy;
import org.apache.camel.core.osgi.OsgiClassResolver;
import org.apache.camel.core.osgi.OsgiComponentResolver;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiLanguageResolver;
import org.apache.camel.core.osgi.OsgiManagementNameStrategy;
import org.apache.camel.core.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.core.osgi.OsgiServiceRegistry;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiCamelContextHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiCamelContextHelper.class);

    private OsgiCamelContextHelper() {
    }

    public static void osgiUpdate(DefaultCamelContext camelContext, BundleContext bundleContext) {
        ObjectHelper.notNull((Object)bundleContext, (String)"BundleContext");
        LOG.debug("Using OsgiCamelContextNameStrategy");
        camelContext.setNameStrategy((CamelContextNameStrategy)new OsgiCamelContextNameStrategy(bundleContext));
        LOG.debug("Using OsgiManagementNameStrategy");
        camelContext.setManagementNameStrategy((ManagementNameStrategy)new OsgiManagementNameStrategy((CamelContext)camelContext, bundleContext));
        LOG.debug("Using OsgiClassResolver");
        camelContext.setClassResolver((ClassResolver)new OsgiClassResolver((CamelContext)camelContext, bundleContext));
        LOG.debug("Using OsgiFactoryFinderResolver");
        camelContext.setFactoryFinderResolver((FactoryFinderResolver)new OsgiFactoryFinderResolver(bundleContext));
        LOG.debug("Using OsgiPackageScanClassResolver");
        camelContext.setPackageScanClassResolver((PackageScanClassResolver)new OsgiPackageScanClassResolver(bundleContext));
        LOG.debug("Using OsgiComponentResolver");
        camelContext.setComponentResolver((ComponentResolver)new OsgiComponentResolver(bundleContext));
        LOG.debug("Using OsgiLanguageResolver");
        camelContext.setLanguageResolver((LanguageResolver)new OsgiLanguageResolver(bundleContext));
        LOG.debug("Using OsgiDataFormatResolver");
        camelContext.setDataFormatResolver((DataFormatResolver)new OsgiDataFormatResolver(bundleContext));
    }

    public static Registry wrapRegistry(CamelContext camelContext, Registry registry, BundleContext bundleContext) {
        ObjectHelper.notNull((Object)bundleContext, (String)"BundleContext");
        OsgiServiceRegistry osgiServiceRegistry = null;
        Registry resultingRegistry = registry;
        if (registry instanceof OsgiServiceRegistry) {
            osgiServiceRegistry = (OsgiServiceRegistry)registry;
        } else {
            LOG.debug("Wrapping Registry in OsgiServiceRegistry");
            osgiServiceRegistry = new OsgiServiceRegistry(bundleContext);
            CompositeRegistry compositeRegistry = new CompositeRegistry();
            compositeRegistry.addRegistry((Registry)osgiServiceRegistry);
            compositeRegistry.addRegistry(registry);
            resultingRegistry = compositeRegistry;
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)osgiServiceRegistry);
        return resultingRegistry;
    }
}

