/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.position;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NmeaPosition {
    private static final double MS_TO_KMH = 3.6;
    private static final double MS_TO_MPH = 2.24;
    private double latitudeDegrees;
    private double longitudeDegrees;
    private double altitudeMeters;
    private double speedMetersPerSecond;
    private double trackDegrees;
    private int fixQuality;
    private int nrSatellites;
    private double mDOP;
    private double mPDOP;
    private double mHDOP;
    private double mVDOP;
    private int m3Dfix;
    private char validFix;
    private char latitudeHemisphere;
    private char longitudeHemisphere;

    public NmeaPosition(double latDegrees, double lonDegrees, double altDegrees, double speedMps, double trackDegrees) {
        this(latDegrees, lonDegrees, altDegrees, speedMps, trackDegrees, 0, 0, 0.0, 0.0, 0.0, 0.0, 0, '0', '0', '0');
    }

    public NmeaPosition(double latDegrees, double lonDegrees, double altDegrees, double speedMps, double trackDegrees, int fixQuality, int nrSatellites, double dop, double pdop, double hdop, double vdop, int fix3D) {
        this(latDegrees, lonDegrees, altDegrees, speedMps, trackDegrees, fixQuality, nrSatellites, dop, pdop, hdop, vdop, fix3D, '0', '0', '0');
    }

    public NmeaPosition(double latDegrees, double lonDegrees, double altDegrees, double speedMps, double trackDegrees, int fixQuality, int nrSatellites, double dop, double pdop, double hdop, double vdop, int fix3D, char validF, char hemiLat, char hemiLon) {
        this.latitudeDegrees = latDegrees;
        this.longitudeDegrees = lonDegrees;
        this.altitudeMeters = altDegrees;
        this.speedMetersPerSecond = speedMps;
        this.trackDegrees = trackDegrees;
        this.fixQuality = fixQuality;
        this.nrSatellites = nrSatellites;
        this.mDOP = dop;
        this.mPDOP = pdop;
        this.mHDOP = hdop;
        this.mVDOP = vdop;
        this.m3Dfix = fix3D;
        this.validFix = validF;
        this.latitudeHemisphere = hemiLat;
        this.longitudeHemisphere = hemiLon;
    }

    public double getLatitude() {
        return this.latitudeDegrees;
    }

    public void setLatitude(double latitude) {
        this.latitudeDegrees = latitude;
    }

    public double getLongitude() {
        return this.longitudeDegrees;
    }

    public void setLongitude(double longitude) {
        this.longitudeDegrees = longitude;
    }

    public double getAltitude() {
        return this.altitudeMeters;
    }

    public void setAltitude(double altitude) {
        this.altitudeMeters = altitude;
    }

    public double getSpeedKmh() {
        return this.speedMetersPerSecond * 3.6;
    }

    public double getSpeedMph() {
        return this.speedMetersPerSecond * 2.24;
    }

    public double getSpeed() {
        return this.speedMetersPerSecond;
    }

    public void setSpeed(double speed) {
        this.speedMetersPerSecond = speed;
    }

    public double getTrack() {
        return this.trackDegrees;
    }

    public void setTrack(double track) {
        this.trackDegrees = track;
    }

    public int getFixQuality() {
        return this.fixQuality;
    }

    public void setFixQuality(int fixQuality) {
        this.fixQuality = fixQuality;
    }

    public int getNrSatellites() {
        return this.nrSatellites;
    }

    public void setNrSatellites(int nrSatellites) {
        this.nrSatellites = nrSatellites;
    }

    public double getDOP() {
        return this.mDOP;
    }

    public void setDOP(double dop) {
        this.mDOP = dop;
    }

    public double getPDOP() {
        return this.mPDOP;
    }

    public void setPDOP(double pdop) {
        this.mPDOP = pdop;
    }

    public double getHDOP() {
        return this.mHDOP;
    }

    public void setHDOP(double hdop) {
        this.mHDOP = hdop;
    }

    public double getVDOP() {
        return this.mVDOP;
    }

    public void setVDOP(double vdop) {
        this.mVDOP = vdop;
    }

    public int get3Dfix() {
        return this.m3Dfix;
    }

    public void set3Dfix(int fix3D) {
        this.m3Dfix = fix3D;
    }

    public char getValidFix() {
        return this.validFix;
    }

    public void setValidFix(char validFix) {
        this.validFix = validFix;
    }

    public char getLatitudeHemisphere() {
        return this.latitudeHemisphere;
    }

    public void setLatitudeHemisphere(char latitudeHemisphere) {
        this.latitudeHemisphere = latitudeHemisphere;
    }

    public char getLongitudeHemisphere() {
        return this.longitudeHemisphere;
    }

    public void setLongitudeHemisphere(char longitudeHemisphere) {
        this.longitudeHemisphere = longitudeHemisphere;
    }
}

