/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.internal.wire.asset.RecordFiller;
import org.eclipse.kura.internal.wire.asset.RecordFillers;
import org.eclipse.kura.internal.wire.asset.TimestampFiller;
import org.eclipse.kura.internal.wire.asset.WireAssetOptions;
import org.eclipse.kura.type.TypedValue;

final class Utils {
    private Utils() {
    }

    static Map<String, TypedValue<?>> toWireRecordProperties(List<ChannelRecord> channelRecords, WireAssetOptions options, List<RecordFiller> recordFillers) {
        Iterator<ChannelRecord> recordIter = channelRecords.iterator();
        Iterator<RecordFiller> fillerIter = recordFillers.iterator();
        HashMap wireRecordProperties = new HashMap(channelRecords.size() * 2);
        TimestampFiller timestampFiller = options.getTimestampMode().createFiller(wireRecordProperties);
        while (recordIter.hasNext()) {
            ChannelRecord record = recordIter.next();
            RecordFiller filler = fillerIter.next();
            filler.fill(wireRecordProperties, record);
            timestampFiller.processRecord(record);
        }
        timestampFiller.fillSingleTimestamp();
        return wireRecordProperties;
    }

    static Map<String, TypedValue<?>> toWireRecordProperties(List<ChannelRecord> channelRecords, WireAssetOptions options) {
        HashMap wireRecordProperties = new HashMap(channelRecords.size() * 2);
        TimestampFiller timestampFiller = options.getTimestampMode().createFiller(wireRecordProperties);
        for (ChannelRecord record : channelRecords) {
            RecordFillers.create(record, options).fill(wireRecordProperties, record);
            timestampFiller.processRecord(record);
        }
        timestampFiller.fillSingleTimestamp();
        return wireRecordProperties;
    }
}

