/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.network.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationList;
import org.eclipse.kura.rest.configuration.api.CreateFactoryComponentConfigurationsRequest;
import org.eclipse.kura.rest.configuration.api.DTOUtil;
import org.eclipse.kura.rest.configuration.api.DeleteFactoryComponentRequest;
import org.eclipse.kura.rest.configuration.api.FactoryComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.FailureHandler;
import org.eclipse.kura.rest.configuration.api.PidSet;
import org.eclipse.kura.rest.configuration.api.UpdateComponentConfigurationRequest;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="networkConfiguration/v1")
public class NetworkConfigurationRestService {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfigurationRestService.class);
    private static final String KURA_PERMISSION_REST_CONFIGURATION_ROLE = "kura.permission.rest.network.configuration";
    private static final String NETWORK_CONFIGURATION_SERVICE_PID = "org.eclipse.kura.net.admin.NetworkConfigurationService";
    private static final List<String> NETWORK_CONFIGURATION_PIDS = Arrays.asList("org.eclipse.kura.net.admin.NetworkConfigurationService", "org.eclipse.kura.net.admin.FirewallConfigurationService", "org.eclipse.kura.net.admin.ipv6.FirewallConfigurationServiceIPv6");
    private static final String SUBTASK_SNAPSHOT_TAG = "snapshot";
    private ConfigurationService configurationService;
    private CryptoService cryptoService;

    public void setUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_CONFIGURATION_ROLE, 2);
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    @GET
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/configurableComponents")
    @Produces(value={"application/json"})
    public PidSet listNetworkConfigurableComponentsPids() {
        Set pids = this.configurationService.getConfigurableComponentPids().stream().filter(this::isNetworkConfigurationPid).collect(Collectors.toSet());
        return new PidSet(pids);
    }

    @GET
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/configurableComponents/configurations")
    @Produces(value={"application/json"})
    public ComponentConfigurationList listNetworkConfiguration() {
        ArrayList<ComponentConfiguration> ccs = new ArrayList<ComponentConfiguration>();
        try {
            for (String config : NETWORK_CONFIGURATION_PIDS) {
                ComponentConfiguration configuration = this.configurationService.getComponentConfiguration(config);
                if (configuration == null) continue;
                ccs.add(configuration);
            }
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return DTOUtil.toComponentConfigurationList(ccs, (CryptoService)this.cryptoService, (boolean)false).replacePasswordsWithPlaceholder();
    }

    @POST
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/configurableComponents/configurations/byPid")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ComponentConfigurationList listNetworkComponentConfigurations(PidSet pids) {
        pids.validate();
        ArrayList networkConfigurations = new ArrayList();
        pids.getPids().forEach(pid -> {
            try {
                ComponentConfiguration config = this.configurationService.getComponentConfiguration(pid);
                if (!Objects.isNull(config) && this.isNetworkConfigurationPid((String)pid)) {
                    networkConfigurations.add(config);
                }
            }
            catch (Exception ex) {
                throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
            }
        });
        return DTOUtil.toComponentConfigurationList(networkConfigurations, (CryptoService)this.cryptoService, (boolean)false).replacePasswordsWithPlaceholder();
    }

    @POST
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/configurableComponents/configurations/byPid/_default")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ComponentConfigurationList listDefaultNetworkComponentConfiguration(PidSet pids) {
        pids.validate();
        ArrayList<ComponentConfigurationDTO> requestResult = new ArrayList<ComponentConfigurationDTO>();
        for (String pid : pids.getPids()) {
            try {
                ComponentConfiguration componentConfiguration = this.configurationService.getDefaultComponentConfiguration(pid);
                if (!this.isNetworkConfigurationPid(pid) || componentConfiguration == null || componentConfiguration.getDefinition() == null) {
                    logger.warn("cannot find default network configuration for {}", (Object)pid);
                    continue;
                }
                requestResult.add(DTOUtil.toComponentConfigurationDTO((ComponentConfiguration)componentConfiguration, (CryptoService)this.cryptoService, (boolean)false));
            }
            catch (Exception ex) {
                logger.warn("failed to get default configuration for {}", (Object)pid, (Object)ex);
            }
        }
        return new ComponentConfigurationList(requestResult);
    }

    @PUT
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/configurableComponents/configurations/_update")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateNetworkComponentConfigurations(UpdateComponentConfigurationRequest request) {
        request.validate();
        FailureHandler failureHandler = new FailureHandler();
        for (ComponentConfigurationDTO componentConfig : request.getComponentConfigurations()) {
            if (!this.isNetworkConfigurationPid(componentConfig.getPid())) continue;
            failureHandler.runFallibleSubtask("update:" + componentConfig.getPid(), () -> {
                Map configurationProperties = DTOUtil.dtosToConfigurationProperties((Map)componentConfig.getProperties());
                this.updateNetInterfaces(configurationProperties, componentConfig.getPid());
                this.configurationService.updateConfiguration(componentConfig.getPid(), configurationProperties, false);
            });
        }
        if (request.isTakeSnapshot()) {
            failureHandler.runFallibleSubtask(SUBTASK_SNAPSHOT_TAG, () -> {
                long l = this.configurationService.snapshot();
            });
        }
        failureHandler.checkStatus();
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/factoryComponents")
    @Produces(value={"application/json"})
    public PidSet listFactoryComponentsPids() {
        return new PidSet(Collections.emptySet());
    }

    @POST
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/factoryComponents")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createNetworkFactoryComponents(CreateFactoryComponentConfigurationsRequest configs) {
        configs.validate();
        FailureHandler handler = new FailureHandler();
        for (FactoryComponentConfigurationDTO config : configs.getConfigs()) {
            handler.runFallibleSubtask("create:" + config.getPid(), () -> {
                throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Factory pid doesn't correspond to a network component factory"});
            });
        }
        if (configs.isTakeSnapshot()) {
            handler.runFallibleSubtask(SUBTASK_SNAPSHOT_TAG, () -> {
                long l = this.configurationService.snapshot();
            });
        }
        handler.checkStatus();
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/factoryComponents/byPid")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteFactoryConfigurations(DeleteFactoryComponentRequest request) {
        request.validate();
        FailureHandler handler = new FailureHandler();
        for (String pid : request.getPids()) {
            handler.runFallibleSubtask("delete:" + pid, () -> {
                throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Pid doesn't correspond to a network factory component"});
            });
        }
        if (request.isTakeSnapshot()) {
            handler.runFallibleSubtask(SUBTASK_SNAPSHOT_TAG, () -> {
                long l = this.configurationService.snapshot();
            });
        }
        handler.checkStatus();
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/factoryComponents/ocd")
    @Produces(value={"application/json"})
    public ComponentConfigurationList getFactoryComponentOcds() {
        return DTOUtil.toComponentConfigurationList(Collections.emptyList(), (CryptoService)this.cryptoService, (boolean)false);
    }

    @POST
    @RolesAllowed(value={"network.configuration"})
    @Path(value="/factoryComponents/ocd/byFactoryPid")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ComponentConfigurationList getFactoryComponentOcdsByPid(PidSet factoryPids) {
        factoryPids.validate();
        return DTOUtil.toComponentConfigurationList(Collections.emptyList(), (CryptoService)this.cryptoService, (boolean)false);
    }

    private boolean isNetworkConfigurationPid(String pid) {
        boolean result = false;
        for (String filter : NETWORK_CONFIGURATION_PIDS) {
            if (!pid.equals(filter)) continue;
            result = true;
        }
        return result;
    }

    private void updateNetInterfaces(Map<String, Object> configurationProperties, String pid) throws KuraException {
        if (pid.equals(NETWORK_CONFIGURATION_SERVICE_PID)) {
            HashSet interfaceNames = new HashSet();
            configurationProperties.keySet().forEach(key -> {
                Optional<String> interfaceName = this.parseInterfaceName((String)key);
                interfaceName.ifPresent(interfaceNames::add);
            });
            Map properties = this.configurationService.getComponentConfiguration(pid).getConfigurationProperties();
            String netInterfaces = (String)properties.get("net.interfaces");
            List<String> netInterfacesList = Arrays.asList(netInterfaces.split(","));
            for (String name : interfaceNames) {
                if (netInterfacesList.contains(name)) continue;
                netInterfaces = String.valueOf(netInterfaces) + "," + name;
            }
            configurationProperties.put("net.interfaces", netInterfaces);
        }
    }

    private Optional<String> parseInterfaceName(String key) {
        return Optional.ofNullable(StringUtils.substringBetween((String)key, (String)"net.interface.", (String)".config."));
    }
}

