/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.cloudlet.serialization.request;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;

public class WriteRequest {
    private String assetName;
    private List<ChannelRecord> channelRecords = new ArrayList<ChannelRecord>();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    public WriteRequest(JsonObject object) {
        this.assetName = object.get("name").asString();
        JsonArray channels = object.get("channels").asArray();
        channels.asArray().forEach(val -> {
            JsonObject obj = val.asObject();
            String name = obj.get("name").asString();
            String type = obj.get("type").asString();
            String value = obj.get("value").asString();
            this.channelRecords.add(ChannelRecord.createWriteRecord((String)name, WriteRequest.parseTypedValue(value, type)));
        });
    }

    public String getAssetName() {
        return this.assetName;
    }

    public List<ChannelRecord> getChannelRecords() {
        return this.channelRecords;
    }

    public static List<WriteRequest> parseAll(JsonArray array) {
        ArrayList<WriteRequest> result = new ArrayList<WriteRequest>();
        array.forEach(value -> result.add(new WriteRequest(value.asObject())));
        return result;
    }

    private static TypedValue<?> parseTypedValue(String userValue, String userType) {
        DataType dataType = DataType.getDataType((String)userType);
        if (DataType.INTEGER == dataType) {
            return TypedValues.newIntegerValue((int)Integer.parseInt(userValue));
        }
        if (DataType.BOOLEAN == dataType) {
            return TypedValues.newBooleanValue((boolean)Boolean.parseBoolean(userValue));
        }
        if (DataType.FLOAT == dataType) {
            return TypedValues.newFloatValue((float)Float.parseFloat(userValue));
        }
        if (DataType.DOUBLE == dataType) {
            return TypedValues.newDoubleValue((double)Double.parseDouble(userValue));
        }
        if (DataType.LONG == dataType) {
            return TypedValues.newLongValue((long)Long.parseLong(userValue));
        }
        if (DataType.STRING == dataType) {
            return TypedValues.newStringValue((String)userValue);
        }
        if (DataType.BYTE_ARRAY == dataType) {
            return TypedValues.newByteArrayValue((byte[])BASE64_DECODER.decode(userValue));
        }
        throw new IllegalArgumentException();
    }
}

