/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.util.jdbc.SQLBiFunction;
import org.eclipse.kura.util.jdbc.SQLFunction;

public interface ConnectionProvider {
    public <T> T withConnection(SQLFunction<Connection, T> var1) throws SQLException;

    default public <T> T withConnection(SQLFunction<Connection, T> task, String message) throws KuraStoreException {
        try {
            return this.withConnection(task);
        }
        catch (Exception e) {
            throw new KuraStoreException((Throwable)e, (Object)message);
        }
    }

    default public <T> T withPreparedStatement(String sql, SQLBiFunction<Connection, PreparedStatement, T> task, String message) throws KuraStoreException {
        return (T)this.withConnection(c -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (PreparedStatement s = c.prepareStatement(sql);){
                return task.call((Connection)c, s);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, message);
    }
}

