/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.linux.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.naming.OperationNotSupportedException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.linux.util.ProcessStats;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.core.util.SafeProcess;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LinuxProcessUtil {
    private static final Logger logger = LoggerFactory.getLogger(LinuxProcessUtil.class);
    public static final String RETURNED_WITH_EXIT_VALUE = "{} returned with exit value: {}";
    public static final String EXECUTING = "executing: {}";
    public static final String PRIVILEGED_OPERATIONS_NOT_ALLOWED = "Privileged operations not allowed";
    private static final String PS_COMMAND = "ps -ax";
    private static final String PLATFORM_INTEL_EDISON = "intel-edison";
    private static Boolean usingBusybox;

    protected LinuxProcessUtil() {
    }

    public static int start(String command, boolean wait, boolean background) throws OperationNotSupportedException, IOException {
        if (command.contains("sudo")) {
            throw new OperationNotSupportedException(PRIVILEGED_OPERATIONS_NOT_ALLOWED);
        }
        SafeProcess proc = null;
        try {
            logger.info(EXECUTING, (Object)command);
            proc = ProcessUtil.exec(command);
            if (wait) {
                LinuxProcessUtil.waitFor(proc);
                logger.info(RETURNED_WITH_EXIT_VALUE, (Object)command, (Object)proc.exitValue());
                if (proc.exitValue() > 0) {
                    String stdout = LinuxProcessUtil.getInputStreamAsString(proc.getInputStream());
                    String stderr = LinuxProcessUtil.getInputStreamAsString(proc.getErrorStream());
                    logger.debug("stdout: {}", (Object)stdout);
                    logger.debug("stderr: {}", (Object)stderr);
                }
                int n = proc.exitValue();
                return n;
            }
            return 0;
        }
        finally {
            if (!background && proc != null) {
                ProcessUtil.destroy(proc);
            }
        }
    }

    public static int start(String command) throws OperationNotSupportedException, IOException {
        return LinuxProcessUtil.start(command, true, false);
    }

    public static int start(String command, boolean wait) throws OperationNotSupportedException, IOException {
        return LinuxProcessUtil.start(command, wait, false);
    }

    public static int start(String[] command, boolean wait) throws OperationNotSupportedException, IOException {
        StringBuilder cmdBuilder = new StringBuilder();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            cmdBuilder.append(cmd).append(' ');
            ++n2;
        }
        return LinuxProcessUtil.start(cmdBuilder.toString(), wait);
    }

    public static int startBackground(String command, boolean wait) throws OperationNotSupportedException, IOException {
        return LinuxProcessUtil.start(command, wait, true);
    }

    public static ProcessStats startWithStats(String command) throws OperationNotSupportedException, IOException {
        if (command.contains("sudo")) {
            throw new OperationNotSupportedException(PRIVILEGED_OPERATIONS_NOT_ALLOWED);
        }
        SafeProcess proc = null;
        logger.info(EXECUTING, (Object)command);
        proc = ProcessUtil.exec(command);
        try {
            int exitVal = proc.waitFor();
            logger.debug(RETURNED_WITH_EXIT_VALUE, (Object)command, (Object)exitVal);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("error executing {} command", (Object)command, (Object)e);
        }
        return new ProcessStats(proc);
    }

    public static ProcessStats startWithStats(String[] command) throws OperationNotSupportedException, IOException {
        if (Arrays.asList(command).stream().anyMatch(s -> s.contains("sudo"))) {
            throw new OperationNotSupportedException(PRIVILEGED_OPERATIONS_NOT_ALLOWED);
        }
        SafeProcess proc = null;
        StringBuilder cmdBuilder = new StringBuilder();
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            cmdBuilder.append(cmd).append(' ');
            ++n2;
        }
        logger.debug(EXECUTING, (Object)cmdBuilder);
        proc = ProcessUtil.exec(command);
        LinuxProcessUtil.wairFor(proc, cmdBuilder);
        return new ProcessStats(proc);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPid(String command) throws IOException, InterruptedException {
        BufferedReader br;
        SafeProcess proc;
        block10: {
            int n;
            StringTokenizer st = null;
            String line = null;
            String pid = null;
            proc = null;
            br = null;
            try {
                if (command == null || command.isEmpty()) break block10;
                logger.trace("searching process list for {}", (Object)command);
                proc = LinuxProcessUtil.isUsingBusyBox() ? ProcessUtil.exec("ps") : ProcessUtil.exec(PS_COMMAND);
                proc.waitFor();
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                boolean bl = true;
                while (true) {
                    if (bl && !(bl = false)) {
                        if (true) break block11;
                    }
                    st = new StringTokenizer(line);
                    pid = st.nextToken();
                    st.nextElement();
                    st.nextElement();
                    st.nextElement();
                    line = line.substring(line.indexOf(st.nextToken()));
                    if (line.indexOf(command) < 0) break block11;
                    logger.trace("found pid {} for command: {}", (Object)pid, (Object)command);
                    n = Integer.parseInt(pid);
                    if (br == null) break block12;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    br.close();
                }
                if (proc != null) {
                    ProcessUtil.destroy(proc);
                }
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        br.close();
                    }
                    if (proc != null) {
                        ProcessUtil.destroy(proc);
                    }
                    return n;
                }
                if ((line = br.readLine()) != null) continue;
            }
        }
        if (br != null) {
            br.close();
        }
        if (proc != null) {
            ProcessUtil.destroy(proc);
        }
        return -1;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPid(String command, String[] tokens) throws IOException, InterruptedException {
        BufferedReader br;
        SafeProcess proc;
        block10: {
            int n;
            StringTokenizer st = null;
            String line = null;
            String pid = null;
            proc = null;
            br = null;
            try {
                if (command == null || command.isEmpty()) break block10;
                logger.trace("searching process list for {}", (Object)command);
                proc = LinuxProcessUtil.isUsingBusyBox() ? ProcessUtil.exec("ps") : ProcessUtil.exec(PS_COMMAND);
                proc.waitFor();
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                boolean bl = true;
                while (true) {
                    if (bl && !(bl = false)) {
                        if (true) break block11;
                    }
                    st = new StringTokenizer(line);
                    pid = st.nextToken();
                    st.nextElement();
                    st.nextElement();
                    st.nextElement();
                    line = line.substring(line.indexOf(st.nextToken()));
                    if (line.indexOf(command) < 0 || !LinuxProcessUtil.checkLine(line, tokens)) break block11;
                    logger.trace("found pid {} for command: {}", (Object)pid, (Object)command);
                    n = Integer.parseInt(pid);
                    if (br == null) break block12;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    br.close();
                }
                if (proc != null) {
                    ProcessUtil.destroy(proc);
                }
                throw throwable;
            }
            {
                block11: {
                    block12: {
                        br.close();
                    }
                    if (proc != null) {
                        ProcessUtil.destroy(proc);
                    }
                    return n;
                }
                if ((line = br.readLine()) != null) continue;
            }
        }
        if (br != null) {
            br.close();
        }
        if (proc != null) {
            ProcessUtil.destroy(proc);
        }
        return -1;
    }

    public static int getKuraPid() throws IOException {
        int pid = -1;
        File kuraPidFile = new File("/var/run/kura.pid");
        if (kuraPidFile.exists()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(kuraPidFile));){
                pid = Integer.parseInt(br.readLine());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return pid;
    }

    public static boolean stop(int pid) {
        return LinuxProcessUtil.stop(pid, false);
    }

    public static boolean kill(int pid) {
        return LinuxProcessUtil.stop(pid, true);
    }

    public static boolean killAll(String command) {
        boolean result = false;
        try {
            logger.info("attempting to kill process {}", (Object)command);
            boolean bl = result = LinuxProcessUtil.start("killall " + command) == 0;
            if (result) {
                logger.info("successfully killed process {}", (Object)command);
            } else {
                logger.warn("failed to kill process {}", (Object)command);
            }
        }
        catch (Exception exception) {
            logger.warn("failed to kill process {}", (Object)command);
        }
        return result;
    }

    public static String getInputStreamAsString(InputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            int len;
            char[] cbuf = new char[1024];
            while ((len = br.read(cbuf)) > 0) {
                sb.append(cbuf, 0, len);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }

    public static boolean isProcessRunning(int pid) throws IOException {
        boolean bl;
        SafeProcess proc;
        block8: {
            boolean isRunning = false;
            proc = null;
            BufferedReader br = null;
            try {
                logger.trace("searching process list for pid{}", (Object)pid);
                proc = LinuxProcessUtil.isUsingBusyBox() ? ProcessUtil.exec("ps") : ProcessUtil.exec(PS_COMMAND);
                proc.waitFor();
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if (LinuxProcessUtil.parsePid(line) != pid) continue;
                    isRunning = true;
                    break;
                }
                bl = isRunning;
                if (br == null) break block8;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        br.close();
                    }
                    if (proc != null) {
                        ProcessUtil.destroy(proc);
                    }
                    throw throwable;
                }
            }
            br.close();
        }
        if (proc != null) {
            ProcessUtil.destroy(proc);
        }
        return bl;
    }

    public static boolean stopAndKill(int pid) throws KuraException {
        try {
            if (pid >= 0) {
                logger.info("stopping pid={}", (Object)pid);
                boolean exists = LinuxProcessUtil.stop(pid);
                if (!exists) {
                    logger.warn("stopping pid={} has failed", (Object)pid);
                } else {
                    exists = LinuxProcessUtil.waitProcess(pid, 500L, 5000L);
                }
                if (exists) {
                    logger.info("killing pid={}", (Object)pid);
                    exists = LinuxProcessUtil.kill(pid);
                    if (!exists) {
                        logger.warn("killing pid={} has failed", (Object)pid);
                    } else {
                        exists = LinuxProcessUtil.waitProcess(pid, 500L, 5000L);
                    }
                }
                if (exists) {
                    logger.warn("Failed to stop process with pid {}", (Object)pid);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw KuraException.internalError((Throwable)e);
        }
    }

    private static boolean isUsingBusyBox() {
        if (usingBusybox != null) {
            return usingBusybox;
        }
        BundleContext ctx = FrameworkUtil.getBundle(LinuxProcessUtil.class).getBundleContext();
        ServiceReference systemServiceRef = ctx.getServiceReference(SystemService.class);
        if (systemServiceRef == null) {
            throw new IllegalStateException("Unable to find instance of: " + SystemService.class.getName());
        }
        SystemService service = (SystemService)ctx.getService(systemServiceRef);
        if (service == null) {
            throw new IllegalStateException("Unable to get instance of: " + SystemService.class.getName());
        }
        try {
            usingBusybox = PLATFORM_INTEL_EDISON.equals(service.getPlatform());
        }
        finally {
            ctx.ungetService(systemServiceRef);
        }
        return usingBusybox;
    }

    private static boolean stop(int pid, boolean kill) {
        boolean result = false;
        try {
            if (LinuxProcessUtil.isProcessRunning(pid)) {
                StringBuilder cmd = new StringBuilder();
                cmd.append("kill ");
                if (kill) {
                    cmd.append("-9 ");
                }
                cmd.append(pid);
                if (kill) {
                    logger.info("attempting to kill -9 pid {}", (Object)pid);
                } else {
                    logger.info("attempting to kill pid {}", (Object)pid);
                }
                if (LinuxProcessUtil.start(cmd.toString()) == 0) {
                    logger.info("successfully killed pid {}", (Object)pid);
                    result = true;
                } else {
                    logger.warn("failed to kill pid {}", (Object)pid);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("failed to kill pid {}", (Object)pid);
        }
        return result;
    }

    private static boolean waitProcess(int pid, long poll, long timeout) {
        boolean exists = false;
        try {
            long now;
            long startTime = System.currentTimeMillis();
            do {
                Thread.sleep(poll);
                exists = LinuxProcessUtil.isProcessRunning(pid);
                now = System.currentTimeMillis();
            } while (exists && now - startTime < timeout);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            logger.warn("Failed waiting for pid {} to exit - {}", (Object)pid, (Object)e);
        }
        return exists;
    }

    private static int parsePid(String line) {
        StringTokenizer st = new StringTokenizer(line);
        int processID = -1;
        try {
            processID = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            logger.warn("getPid() :: NumberFormatException reading PID - {}", (Throwable)e);
        }
        return processID;
    }

    private static void waitFor(SafeProcess proc) {
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted exception - ", (Throwable)e);
        }
    }

    private static void wairFor(SafeProcess proc, StringBuilder cmdBuilder) {
        try {
            int exitVal = proc.waitFor();
            logger.debug(RETURNED_WITH_EXIT_VALUE, (Object)cmdBuilder, (Object)exitVal);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("error executing {} command", (Object)cmdBuilder, (Object)e);
        }
    }

    private static boolean checkLine(String line, String[] tokens) {
        boolean allTokensPresent = true;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!line.contains(token)) {
                allTokensPresent = false;
                break;
            }
            ++n2;
        }
        return allTokensPresent;
    }
}

