/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.factory.CloudServiceFactory;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory;
import org.eclipse.kura.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.ComponentContext;

public class DefaultCloudServiceFactory
implements CloudServiceFactory,
CloudConnectionFactory {
    private static final String FACTORY_PID = "org.eclipse.kura.core.cloud.factory.DefaultCloudServiceFactory";
    private static final String CLOUD_SERVICE_FACTORY_PID = "org.eclipse.kura.cloud.CloudService";
    private static final String DATA_SERVICE_FACTORY_PID = "org.eclipse.kura.data.DataService";
    private static final String DATA_TRANSPORT_SERVICE_FACTORY_PID = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
    private static final String CLOUD_SERVICE_PID = "org.eclipse.kura.cloud.CloudService";
    private static final String DATA_SERVICE_PID = "org.eclipse.kura.data.DataService";
    private static final String DATA_TRANSPORT_SERVICE_PID = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
    private static final String DATA_SERVICE_REFERENCE_NAME = "DataService";
    private static final String DATA_TRANSPORT_SERVICE_REFERENCE_NAME = "DataTransportService";
    private static final String REFERENCE_TARGET_VALUE_FORMAT = "(kura.service.pid=%s)";
    private static final Pattern MANAGED_CLOUD_SERVICE_PID_PATTERN = Pattern.compile("^org\\.eclipse\\.kura\\.cloud\\.CloudService(-[a-zA-Z0-9]+)?$");
    private ConfigurationService configurationService;
    private BundleContext bundleContext;

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        if (configurationService == this.configurationService) {
            this.configurationService = null;
        }
    }

    public void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
    }

    public String getFactoryPid() {
        return "org.eclipse.kura.cloud.CloudService";
    }

    public void createConfiguration(String pid) throws KuraException {
        String dataTransportServicePid;
        String dataServicePid;
        String[] parts = pid.split("-");
        if (parts.length != 0 && "org.eclipse.kura.cloud.CloudService".equals(parts[0])) {
            String suffix = null;
            if (parts.length > 1) {
                suffix = parts[1];
            }
            dataServicePid = "org.eclipse.kura.data.DataService";
            dataTransportServicePid = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
            if (suffix != null) {
                dataServicePid = String.valueOf(dataServicePid) + "-" + suffix;
                dataTransportServicePid = String.valueOf(dataTransportServicePid) + "-" + suffix;
            }
        } else {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Invalid PID '{}'", pid});
        }
        HashMap<String, String> cloudServiceProperties = new HashMap<String, String>();
        String name = "DataService.target";
        cloudServiceProperties.put(name, String.format(REFERENCE_TARGET_VALUE_FORMAT, dataServicePid));
        cloudServiceProperties.put("kura.cloud.service.factory.pid", FACTORY_PID);
        cloudServiceProperties.put("kura.cloud.connection.factory.pid", FACTORY_PID);
        this.configurationService.createFactoryConfiguration("org.eclipse.kura.cloud.CloudService", pid, cloudServiceProperties, false);
        HashMap<String, String> dataServiceProperties = new HashMap<String, String>();
        name = "DataTransportService.target";
        dataServiceProperties.put(name, String.format(REFERENCE_TARGET_VALUE_FORMAT, dataTransportServicePid));
        this.configurationService.createFactoryConfiguration("org.eclipse.kura.data.DataService", dataServicePid, dataServiceProperties, false);
        this.configurationService.createFactoryConfiguration("org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport", dataTransportServicePid, null, true);
    }

    public void deleteConfiguration(String pid) throws KuraException {
        String[] parts = pid.split("-");
        if (parts.length != 0 && "org.eclipse.kura.cloud.CloudService".equals(parts[0])) {
            String suffix = null;
            if (parts.length > 1) {
                suffix = parts[1];
            }
            String dataServicePid = "org.eclipse.kura.data.DataService";
            String dataTransportServicePid = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
            if (suffix != null) {
                dataServicePid = String.valueOf(dataServicePid) + "-" + suffix;
                dataTransportServicePid = String.valueOf(dataTransportServicePid) + "-" + suffix;
            }
            this.configurationService.deleteFactoryConfiguration(pid, false);
            this.configurationService.deleteFactoryConfiguration(dataServicePid, false);
            this.configurationService.deleteFactoryConfiguration(dataTransportServicePid, true);
        }
    }

    public List<String> getStackComponentsPids(String pid) throws KuraException {
        ArrayList<String> componentPids = new ArrayList<String>();
        String[] parts = pid.split("-");
        if (parts.length != 0 && "org.eclipse.kura.cloud.CloudService".equals(parts[0])) {
            String suffix = null;
            if (parts.length > 1) {
                suffix = parts[1];
            }
            String dataServicePid = "org.eclipse.kura.data.DataService";
            String dataTransportServicePid = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
            if (suffix != null) {
                dataServicePid = String.valueOf(dataServicePid) + "-" + suffix;
                dataTransportServicePid = String.valueOf(dataTransportServicePid) + "-" + suffix;
            }
            componentPids.add(pid);
            componentPids.add(dataServicePid);
            componentPids.add(dataTransportServicePid);
            return componentPids;
        }
        throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Invalid PID '{}'", pid});
    }

    public Set<String> getManagedCloudConnectionPids() throws KuraException {
        try {
            return this.bundleContext.getServiceReferences(CloudConnectionManager.class, null).stream().filter(ref -> {
                Object kuraServicePid = ref.getProperty("kura.service.pid");
                if (!(kuraServicePid instanceof String)) {
                    return false;
                }
                return MANAGED_CLOUD_SERVICE_PID_PATTERN.matcher((String)kuraServicePid).matches() && (FACTORY_PID.equals(ref.getProperty("kura.cloud.service.factory.pid")) || FACTORY_PID.equals(ref.getProperty("kura.cloud.connection.factory.pid")));
            }).map(ref -> (String)ref.getProperty("kura.service.pid")).collect(Collectors.toSet());
        }
        catch (InvalidSyntaxException e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, (Throwable)e, new Object[0]);
        }
    }

    public Set<String> getManagedCloudServicePids() throws KuraException {
        return this.getManagedCloudConnectionPids();
    }
}

