/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.utils;

public class CircularBuffer {
    private byte[] buffer = new byte[4096];
    private int cbOffset = 0;
    private volatile int cbLength = 0;

    protected int getCapacity() {
        return this.buffer.length;
    }

    public int available() {
        return this.cbLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int aOffset, int aLength) {
        CircularBuffer circularBuffer = this;
        synchronized (circularBuffer) {
            int availableSpaceToEnd;
            int writeOffset;
            if (this.buffer.length - this.cbLength < aLength) {
                byte[] newBuffer = new byte[(int)((double)(this.cbLength + aLength) * 1.5)];
                if (this.cbOffset + this.cbLength < this.buffer.length) {
                    System.arraycopy(this.buffer, this.cbOffset, newBuffer, 0, this.cbLength);
                } else {
                    System.arraycopy(this.buffer, this.cbOffset, newBuffer, 0, this.buffer.length - this.cbOffset);
                    System.arraycopy(this.buffer, 0, newBuffer, this.buffer.length - this.cbOffset, this.cbLength - this.buffer.length + this.cbOffset);
                }
                this.buffer = newBuffer;
                this.cbOffset = 0;
            }
            if ((writeOffset = this.cbOffset + this.cbLength) >= this.buffer.length) {
                writeOffset -= this.buffer.length;
            }
            if (aLength < (availableSpaceToEnd = this.buffer.length - writeOffset)) {
                System.arraycopy(buf, aOffset, this.buffer, writeOffset, aLength);
            } else {
                System.arraycopy(buf, aOffset, this.buffer, writeOffset, availableSpaceToEnd);
                System.arraycopy(buf, aOffset + availableSpaceToEnd, this.buffer, 0, aLength - availableSpaceToEnd);
            }
            this.cbLength += aLength;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] var0, int var1, int var2) {
        CircularBuffer circularBuffer = this;
        synchronized (circularBuffer) {
            int symbolsToRead;
            block8: {
                int availableSymbolsToEnd;
                while (true) {
                    if (this.cbLength != 0) {
                        symbolsToRead = Math.min(this.cbLength, var2);
                        if (symbolsToRead >= (availableSymbolsToEnd = this.buffer.length - this.cbOffset)) break;
                        System.arraycopy(this.buffer, this.cbOffset, var0, var1, symbolsToRead);
                        break block8;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return -1;
                    }
                }
                System.arraycopy(this.buffer, this.cbOffset, var0, var1, availableSymbolsToEnd);
                System.arraycopy(this.buffer, 0, var0, var1 + availableSymbolsToEnd, symbolsToRead - availableSymbolsToEnd);
            }
            this.cbLength -= symbolsToRead;
            this.cbOffset += symbolsToRead;
            if (this.cbOffset > this.buffer.length) {
                this.cbOffset -= this.buffer.length;
            }
            this.notifyAll();
            return symbolsToRead;
        }
    }

    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }
}

