/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.utils.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class DOMElement
extends DOMNode
implements Element {
    String tag;
    boolean selfClosed;
    int startTagOpenOffset = -1;
    int startTagCloseOffset = -1;
    int endTagOpenOffset = -1;
    int endTagCloseOffset = -1;

    public DOMElement(int start, int end) {
        super(start, end);
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String getTagName() {
        return this.tag;
    }

    @Override
    public String getLocalName() {
        String name = this.getTagName();
        if (name == null) {
            return null;
        }
        int index = name.indexOf(":");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    @Override
    public String getPrefix() {
        String name = this.getTagName();
        if (name == null) {
            return null;
        }
        String prefix = null;
        int index = name.indexOf(":");
        if (index != -1) {
            prefix = name.substring(0, index);
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI() {
        String prefix = this.getPrefix();
        String namespaceURI = DOMElement.getNamespaceURI(prefix, this);
        if (namespaceURI != null) {
            return namespaceURI;
        }
        for (DOMNode parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            DOMElement parentElement;
            if (parent.getNodeType() != 1 || (namespaceURI = DOMElement.getNamespaceURI(prefix, parentElement = (DOMElement)parent)) == null) continue;
            return namespaceURI;
        }
        return null;
    }

    public static String getNamespaceURI(String prefix, DOMElement element) {
        boolean hasPrefix = !StringUtils.isEmpty(prefix);
        return hasPrefix ? element.getAttribute("xmlns:" + prefix) : element.getAttribute("xmlns");
    }

    public Collection<String> getAllPrefixes() {
        if (this.hasAttributes()) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (DOMAttr attr : this.getAttributeNodes()) {
                if (!attr.isNoDefaultXmlns()) continue;
                prefixes.add(attr.extractPrefixFromXmlns());
            }
            return prefixes;
        }
        return Collections.emptyList();
    }

    public String getPrefix(String namespaceURI) {
        String prefix;
        if (namespaceURI == null) {
            return null;
        }
        if (this.hasAttributes()) {
            for (DOMAttr attr : this.getAttributeNodes()) {
                prefix = attr.getPrefixIfMatchesURI(namespaceURI);
                if (prefix == null) continue;
                return prefix;
            }
        }
        for (DOMNode parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            DOMElement parentElement;
            if (parent.getNodeType() != 1 || (prefix = (parentElement = (DOMElement)parent).getPrefix(namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    public boolean isDocumentElement() {
        return this.equals(this.getOwnerDocument().getDocumentElement());
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    public Integer endsWith(char c, int startOffset) {
        String text = this.getOwnerDocument().getText();
        if (startOffset > text.length() || startOffset < 0) {
            return null;
        }
        --startOffset;
        while (startOffset >= 0) {
            char current = text.charAt(startOffset);
            if (Character.isWhitespace(current)) {
                --startOffset;
                continue;
            }
            if (current != c) {
                return null;
            }
            return startOffset;
        }
        return null;
    }

    public Integer isNextChar(char c, int startOffset) {
        String text = this.getOwnerDocument().getText();
        if (startOffset > text.length() || startOffset < 0) {
            return null;
        }
        while (startOffset < text.length()) {
            char current = text.charAt(startOffset);
            if (Character.isWhitespace(current)) {
                ++startOffset;
                continue;
            }
            if (current != c) {
                return null;
            }
            return startOffset;
        }
        return null;
    }

    public boolean isSameTag(String tag) {
        return Objects.equals(this.tag, tag);
    }

    public boolean isInStartTag(int offset) {
        if (this.startTagOpenOffset == -1 || this.startTagCloseOffset == -1) {
            return true;
        }
        return offset > this.startTagOpenOffset && offset <= this.startTagCloseOffset;
    }

    public boolean isInEndTag(int offset) {
        if (this.endTagOpenOffset == -1) {
            return false;
        }
        return offset > this.endTagOpenOffset && offset < this.getEnd();
    }

    public int getStartTagOpenOffset() {
        return this.startTagOpenOffset;
    }

    public int getStartTagCloseOffset() {
        return this.startTagCloseOffset;
    }

    public int getEndTagOpenOffset() {
        return this.endTagOpenOffset;
    }

    public int getEndTagCloseOffset() {
        return this.endTagCloseOffset;
    }

    public boolean hasStartTag() {
        return this.getStartTagOpenOffset() != -1;
    }

    public boolean hasEndTag() {
        return this.getEndTagOpenOffset() != -1;
    }

    public boolean isStartTagClosed() {
        return this.getStartTagCloseOffset() != -1;
    }

    public boolean isEndTagClosed() {
        return this.getEndTagCloseOffset() != -1;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    @Override
    public String getAttributeNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    @Override
    public DOMAttr getAttributeNode(String name) {
        return super.getAttributeNode(name);
    }

    @Override
    public DOMAttr getAttributeNodeNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String arg0) {
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean hasAttributeNS(String arg0, String arg1) throws DOMException {
        return false;
    }

    @Override
    public void removeAttribute(String arg0) throws DOMException {
    }

    @Override
    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
    }

    @Override
    public DOMAttr removeAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    @Override
    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
    }

    @Override
    public DOMAttr setAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    @Override
    public DOMAttr setAttributeNodeNS(Attr arg0) throws DOMException {
        return null;
    }

    @Override
    public void setIdAttribute(String arg0, boolean arg1) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String arg0, String arg1, boolean arg2) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr arg0, boolean arg1) throws DOMException {
    }
}

