/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSValue;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDDocument;
import org.eclipse.lemminx.extensions.xsd.contentmodel.XSDAnnotationModel;

public class CMXSDAttributeDeclaration
implements CMAttributeDeclaration {
    private final XSAttributeUse attributeUse;
    private String documentation;
    private Map<String, String> valuesDocumentation;

    public CMXSDAttributeDeclaration(XSAttributeUse attributeUse) {
        this.attributeUse = attributeUse;
    }

    @Override
    public String getName() {
        return this.getAttrDeclaration().getName();
    }

    @Override
    public String getDefaultValue() {
        XSValue xsValue = this.attributeUse.getValueConstraintValue();
        if (xsValue == null && CMXSDDocument.isBooleanType(this.getAttrDeclaration().getTypeDefinition())) {
            return "false";
        }
        return xsValue != null ? xsValue.getNormalizedValue().toString() : null;
    }

    @Override
    public String getDocumentation() {
        if (this.documentation != null) {
            return this.documentation;
        }
        XSObjectList annotations = this.getAnnotations();
        this.documentation = XSDAnnotationModel.getDocumentation(annotations);
        return this.documentation;
    }

    @Override
    public String getValueDocumentation(String value) {
        String documentation;
        if (this.valuesDocumentation == null) {
            this.valuesDocumentation = new HashMap<String, String>();
        }
        if ((documentation = this.valuesDocumentation.get(value)) != null) {
            return documentation;
        }
        XSObjectList annotations = this.getValueAnnotations();
        documentation = XSDAnnotationModel.getDocumentation(annotations, value);
        this.valuesDocumentation.put(value, documentation);
        return documentation;
    }

    private XSObjectList getAnnotations() {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        XSObjectList annotation = attributeDeclaration.getAnnotations();
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
        if (typeDefinition == null) {
            return null;
        }
        if (typeDefinition.getTypeCategory() == 15) {
            return ((XSComplexTypeDecl)typeDefinition).getAnnotations();
        }
        if (typeDefinition.getTypeCategory() == 16) {
            return ((XSSimpleTypeDecl)typeDefinition).getAnnotations();
        }
        return null;
    }

    private XSObjectList getValueAnnotations() {
        XSMultiValueFacet facet;
        Object[] annotationArray;
        XSSimpleTypeDecl simpleTypeDecl;
        XSObjectList multiFacets;
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        XSSimpleTypeDefinition simpleTypeDefinition = attributeDeclaration.getTypeDefinition();
        XSObjectList annotation = null;
        if (simpleTypeDefinition instanceof XSSimpleTypeDecl && !(multiFacets = (simpleTypeDecl = (XSSimpleTypeDecl)simpleTypeDefinition).getMultiValueFacets()).isEmpty() && !this.onlyContainsNull(annotationArray = (multiFacets = (facet = (XSMultiValueFacet)multiFacets.get(0)).getAnnotations()).toArray())) {
            annotation = simpleTypeDecl.getMultiValueFacets();
        }
        if (annotation == null) {
            annotation = attributeDeclaration.getAnnotations();
        }
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
        if (typeDefinition == null) {
            return null;
        }
        if (typeDefinition.getTypeCategory() == 15) {
            return ((XSComplexTypeDecl)typeDefinition).getAnnotations();
        }
        if (typeDefinition.getTypeCategory() == 16) {
            return ((XSSimpleTypeDecl)typeDefinition).getAnnotations();
        }
        return null;
    }

    private boolean onlyContainsNull(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (Object o : arr) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.attributeUse.getRequired();
    }

    XSAttributeDeclaration getAttrDeclaration() {
        return this.attributeUse.getAttrDeclaration();
    }

    @Override
    public Collection<String> getEnumerationValues() {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        if (attributeDeclaration != null) {
            XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
            return CMXSDDocument.getEnumerationValues(typeDefinition);
        }
        return Collections.emptyList();
    }
}

