/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons.snippets;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.snippets.ISnippetContext;
import org.eclipse.lemminx.commons.snippets.ISnippetRegistryLoader;
import org.eclipse.lemminx.commons.snippets.ISuffixPositionProvider;
import org.eclipse.lemminx.commons.snippets.Snippet;
import org.eclipse.lemminx.commons.snippets.SnippetDeserializer;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SnippetRegistry {
    private static final Logger LOGGER = Logger.getLogger(SnippetRegistry.class.getName());
    private final List<Snippet> snippets = new ArrayList<Snippet>();

    public SnippetRegistry() {
        this(null, true);
    }

    public SnippetRegistry(String languageId, boolean loadDefault) {
        if (loadDefault) {
            ServiceLoader<ISnippetRegistryLoader> loaders = ServiceLoader.load(ISnippetRegistryLoader.class);
            loaders.forEach(loader -> {
                if (Objects.equals(languageId, loader.getLanguageId())) {
                    try {
                        loader.load(this);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while consumming snippet loader " + loader.getClass().getName(), e);
                    }
                }
            });
        }
    }

    public void registerSnippet(Snippet snippet) {
        this.snippets.add(snippet);
    }

    public void registerSnippets(InputStream in) throws IOException {
        this.registerSnippets(in, null, null);
    }

    public void registerSnippets(InputStream in, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(in, null, contextDeserializer);
    }

    public void registerSnippets(InputStream in, ISnippetContext<?> defaultContext) throws IOException {
        this.registerSnippets(in, defaultContext, null);
    }

    public void registerSnippets(InputStream in, ISnippetContext<?> defaultContext, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(new InputStreamReader(in, StandardCharsets.UTF_8.name()), defaultContext, contextDeserializer);
    }

    public void registerSnippets(Reader in) throws IOException {
        this.registerSnippets(in, null, null);
    }

    public void registerSnippets(Reader in, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(in, null, contextDeserializer);
    }

    public void registerSnippets(Reader in, ISnippetContext<?> defaultContext) throws IOException {
        this.registerSnippets(in, defaultContext, null);
    }

    public void registerSnippets(Reader in, ISnippetContext<?> defaultContext, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        JsonReader reader = new JsonReader(in);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            Snippet snippet = SnippetRegistry.createSnippet(reader, contextDeserializer);
            if (snippet.getDescription() == null) {
                snippet.setDescription(name);
            }
            if (snippet.getContext() == null) {
                snippet.setContext(defaultContext);
            }
            this.registerSnippet(snippet);
        }
        reader.endObject();
    }

    private static Snippet createSnippet(JsonReader reader, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws JsonIOException, JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Snippet.class, (Object)new SnippetDeserializer(contextDeserializer));
        return (Snippet)builder.create().fromJson(reader, Snippet.class);
    }

    public List<Snippet> getSnippets() {
        return this.snippets;
    }

    public List<CompletionItem> getCompletionItems(Range replaceRange, String lineDelimiter, boolean canSupportMarkdown, boolean snippetsSupported, BiPredicate<ISnippetContext<?>, Map<String, String>> contextFilter, ISuffixPositionProvider suffixProvider) {
        if (replaceRange == null) {
            return Collections.emptyList();
        }
        HashMap model = new HashMap();
        return this.getSnippets().stream().filter(snippet -> snippet.match(contextFilter, model)).map(snippet -> {
            Position end;
            CompletionItem item = new CompletionItem();
            item.setLabel(snippet.getLabel());
            String insertText = SnippetRegistry.getInsertText(snippet, model, !snippetsSupported, lineDelimiter);
            item.setKind(CompletionItemKind.Snippet);
            item.setDocumentation(Either.forRight((Object)SnippetRegistry.createDocumentation(snippet, model, canSupportMarkdown, lineDelimiter)));
            String prefix = snippet.getPrefixes().get(0);
            item.setFilterText(prefix);
            item.setDetail(snippet.getDescription());
            Range range = replaceRange;
            if (!StringUtils.isEmpty(snippet.getSuffix()) && suffixProvider != null && (end = suffixProvider.findSuffixPosition(snippet.getSuffix())) != null) {
                range = new Range(replaceRange.getStart(), end);
            }
            item.setTextEdit(new TextEdit(range, insertText));
            item.setInsertTextFormat(InsertTextFormat.Snippet);
            return item;
        }).collect(Collectors.toList());
    }

    private static MarkupContent createDocumentation(Snippet snippet, Map<String, String> model, boolean canSupportMarkdown, String lineDelimiter) {
        StringBuilder doc = new StringBuilder();
        if (canSupportMarkdown) {
            doc.append(System.lineSeparator());
            doc.append("```");
            String scope = snippet.getScope();
            if (scope != null) {
                doc.append(scope);
            }
            doc.append(System.lineSeparator());
        }
        String insertText = SnippetRegistry.getInsertText(snippet, model, true, lineDelimiter);
        doc.append(insertText);
        if (canSupportMarkdown) {
            doc.append(System.lineSeparator());
            doc.append("```");
            doc.append(System.lineSeparator());
        }
        return new MarkupContent(canSupportMarkdown ? "markdown" : "plaintext", doc.toString());
    }

    private static String getInsertText(Snippet snippet, Map<String, String> model, boolean replace, String lineDelimiter) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        List<String> body = snippet.getBody();
        if (body != null) {
            for (String bodyLine : body) {
                if (i > 0) {
                    text.append(lineDelimiter);
                }
                bodyLine = SnippetRegistry.merge(bodyLine, model, replace);
                text.append(bodyLine);
                ++i;
            }
        }
        return text.toString();
    }

    private static String merge(String line, Map<String, String> model, boolean replace) {
        return SnippetRegistry.replace(line, 0, model, replace, null);
    }

    private static String replace(String line, int offset, Map<String, String> model, boolean replace, StringBuilder newLine) {
        char next;
        int dollarIndex = line.indexOf("$", offset);
        if (dollarIndex == -1 || dollarIndex == line.length() - 1) {
            if (newLine == null) {
                return line;
            }
            newLine.append(line.substring(offset, line.length()));
            return newLine.toString();
        }
        if (newLine == null) {
            newLine = new StringBuilder();
        }
        if (Character.isDigit(next = line.charAt(dollarIndex + 1))) {
            if (replace) {
                newLine.append(line.substring(offset, dollarIndex));
            }
            int lastDigitOffset = dollarIndex + 1;
            while (Character.isDigit(line.charAt(lastDigitOffset))) {
                ++lastDigitOffset;
            }
            if (!replace) {
                newLine.append(line.substring(offset, lastDigitOffset));
            }
            return SnippetRegistry.replace(line, lastDigitOffset, model, replace, newLine);
        }
        if (next == '{') {
            String paramName;
            int startExpr = dollarIndex;
            int endExpr = line.indexOf("}", startExpr);
            if (endExpr == -1) {
                return line;
            }
            newLine.append(line.substring(offset, startExpr));
            int startParam = startExpr + 2;
            int endParam = endExpr;
            boolean startsWithNumber = true;
            boolean onlyNumber = true;
            for (int i = startParam; i < endParam; ++i) {
                char ch = line.charAt(i);
                if (!Character.isDigit(ch)) {
                    onlyNumber = false;
                    if (ch == ':') {
                        if (!startsWithNumber) break;
                        startParam = i + 1;
                        break;
                    }
                    if (ch != '|' || !startsWithNumber) break;
                    startParam = i + 1;
                    int index = line.indexOf(44, startExpr);
                    if (index == -1) break;
                    endParam = index;
                    break;
                }
                startsWithNumber = true;
            }
            if (model.containsKey(paramName = line.substring(startParam, endParam))) {
                paramName = model.get(paramName);
            } else if (!replace) {
                paramName = line.substring(startExpr, endExpr + 1);
            }
            if (!replace || !onlyNumber) {
                newLine.append(paramName);
            }
            return SnippetRegistry.replace(line, endExpr + 1, model, replace, newLine);
        }
        return line;
    }
}

