/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;

public class XMLBuilder {
    private final SharedSettings sharedSettings;
    private final String lineDelimiter;
    private final StringBuilder xml;
    private final String whitespacesIndent;
    private final int splitAttributesIndent = 2;

    public XMLBuilder(SharedSettings sharedSettings, String whitespacesIndent, String lineDelimiter) {
        this.whitespacesIndent = whitespacesIndent;
        this.sharedSettings = sharedSettings;
        this.lineDelimiter = lineDelimiter;
        this.xml = new StringBuilder();
    }

    public XMLBuilder appendSpace() {
        this.xml.append(" ");
        return this;
    }

    public XMLBuilder startElement(String prefix, String name, boolean close) {
        this.xml.append("<");
        if (prefix != null && !prefix.isEmpty()) {
            this.xml.append(prefix);
            this.xml.append(":");
        }
        this.xml.append(name);
        if (close) {
            this.closeStartElement();
        }
        return this;
    }

    public XMLBuilder startElement(String name, boolean close) {
        return this.startElement(null, name, close);
    }

    public XMLBuilder endElement(String name, boolean isEndTagClosed) {
        return this.endElement(null, name, isEndTagClosed);
    }

    public XMLBuilder endElement(String name) {
        return this.endElement(null, name, true);
    }

    public XMLBuilder endElement(String prefix, String name) {
        return this.endElement(prefix, name, true);
    }

    public XMLBuilder endElement(String prefix, String name, boolean isEndTagClosed) {
        this.xml.append("</");
        if (prefix != null && !prefix.isEmpty()) {
            this.xml.append(prefix);
            this.xml.append(":");
        }
        this.xml.append(name);
        if (isEndTagClosed) {
            this.xml.append(">");
        }
        return this;
    }

    public XMLBuilder closeStartElement() {
        this.xml.append(">");
        return this;
    }

    public XMLBuilder selfCloseElement() {
        if (this.isSpaceBeforeEmptyCloseTag() && !this.isLastLineEmptyOrWhitespace()) {
            this.appendSpace();
        }
        this.xml.append("/>");
        return this;
    }

    public XMLBuilder addSingleAttribute(DOMAttr attr) {
        return this.addSingleAttribute(attr, false, true);
    }

    public XMLBuilder addSingleAttribute(DOMAttr attr, boolean surroundWithQuotes, boolean prependSpace) {
        return this.addSingleAttribute(attr.getName(), attr.getOriginalValue(), surroundWithQuotes, prependSpace);
    }

    public XMLBuilder addSingleAttribute(String name, String value, boolean surroundWithQuotes) {
        return this.addSingleAttribute(name, value, surroundWithQuotes, true);
    }

    public XMLBuilder addSingleAttribute(String name, String value, boolean surroundWithQuotes, boolean prependSpace) {
        if (prependSpace) {
            this.appendSpace();
        }
        this.addAttributeContents(name, true, value, surroundWithQuotes);
        return this;
    }

    public XMLBuilder addPrologAttribute(DOMAttr attr) {
        this.appendSpace();
        this.addAttributeContents(attr.getName(), attr.hasDelimiter(), attr.getOriginalValue(), false);
        return this;
    }

    public XMLBuilder addAttribute(String name, String value, int level, boolean surroundWithQuotes) {
        if (this.isSplitAttributes()) {
            this.linefeed();
            this.indent(level + 2);
        } else {
            this.appendSpace();
        }
        this.addAttributeContents(name, true, value, surroundWithQuotes);
        return this;
    }

    public XMLBuilder addAttribute(DOMAttr attr, int level) {
        return this.addAttribute(attr, level, false);
    }

    private XMLBuilder addAttribute(DOMAttr attr, int level, boolean surroundWithQuotes) {
        if (this.isSplitAttributes()) {
            this.linefeed();
            this.indent(level + 2);
        } else {
            this.appendSpace();
        }
        this.addAttributeContents(attr.getName(), attr.hasDelimiter(), attr.getOriginalValue(), surroundWithQuotes);
        return this;
    }

    private void addAttributeContents(String name, boolean equalsSign, String originalValue, boolean surroundWithQuotes) {
        if (name != null) {
            this.xml.append(name);
        }
        if (equalsSign) {
            this.xml.append("=");
        }
        if (originalValue != null) {
            char quote = this.getQuotationAsChar();
            if (StringUtils.isQuoted(originalValue)) {
                if (this.getEnforceQuoteStyle() == EnforceQuoteStyle.preferred && originalValue.charAt(0) != quote) {
                    originalValue = StringUtils.convertToQuotelessValue(originalValue);
                    this.xml.append(quote);
                    if (originalValue != null) {
                        this.xml.append(originalValue);
                    }
                    this.xml.append(quote);
                    return;
                }
                this.xml.append(originalValue);
                return;
            }
            if (surroundWithQuotes) {
                this.xml.append(quote);
                if (originalValue != null) {
                    this.xml.append(originalValue);
                }
                this.xml.append(quote);
                return;
            }
            this.xml.append(originalValue);
        }
    }

    public XMLBuilder linefeed() {
        this.xml.append(this.lineDelimiter);
        if (this.whitespacesIndent != null) {
            this.xml.append(this.whitespacesIndent);
        }
        return this;
    }

    public XMLBuilder addContent(String text) {
        return this.addContent(text, false, false, null);
    }

    public XMLBuilder addContent(String text, boolean isWhitespaceContent, boolean hasSiblings, String delimiter) {
        int preservedNewLines;
        if (!isWhitespaceContent) {
            if (this.isJoinContentLines()) {
                text = StringUtils.normalizeSpace(text);
            } else if (hasSiblings) {
                text = text.trim();
            }
            if (this.isTrimTrailingWhitespace()) {
                text = XMLBuilder.trimTrailingSpacesEachLine(text);
            }
            this.xml.append(text);
        } else if (!hasSiblings && this.isPreserveEmptyContent()) {
            this.xml.append(text);
        } else if (hasSiblings && (preservedNewLines = this.getPreservedNewlines()) > 0) {
            int newLineCount = StringUtils.getNumberOfNewLines(text, isWhitespaceContent, delimiter, preservedNewLines);
            for (int i = 0; i < newLineCount - 1; ++i) {
                this.xml.append(delimiter);
            }
        }
        return this;
    }

    public XMLBuilder indent(int level) {
        for (int i = 0; i < level; ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    this.appendSpace();
                }
                continue;
            }
            this.xml.append("\t");
        }
        return this;
    }

    public XMLBuilder startPrologOrPI(String tagName) {
        this.xml.append("<?");
        this.xml.append(tagName);
        return this;
    }

    public XMLBuilder addContentPI(String content) {
        this.appendSpace();
        this.xml.append(content);
        this.appendSpace();
        return this;
    }

    public XMLBuilder endPrologOrPI() {
        this.xml.append("?>");
        return this;
    }

    public String toString() {
        return this.xml.toString();
    }

    public void trimFinalNewlines() {
        int i = this.xml.length() - 1;
        while (i >= 0 && Character.isWhitespace(this.xml.charAt(i))) {
            this.xml.deleteCharAt(i--);
        }
    }

    private static String trimTrailingSpacesEachLine(String str) {
        StringBuilder sb = new StringBuilder(str);
        boolean removeSpaces = true;
        for (int i = str.length() - 1; i >= 0; --i) {
            char curr = sb.charAt(i);
            if (curr == '\n' || curr == '\r') {
                removeSpaces = true;
                continue;
            }
            if (removeSpaces && Character.isWhitespace(curr)) {
                sb.deleteCharAt(i);
                continue;
            }
            removeSpaces = false;
        }
        return sb.toString();
    }

    public XMLBuilder startCDATA() {
        this.xml.append("<![CDATA[");
        return this;
    }

    public XMLBuilder addContentCDATA(String content) {
        if (this.isJoinCDATALines()) {
            content = StringUtils.normalizeSpace(content);
        }
        this.xml.append(content);
        return this;
    }

    public XMLBuilder endCDATA() {
        this.xml.append("]]>");
        return this;
    }

    public XMLBuilder startComment(DOMComment comment) {
        if (comment.isCommentSameLineEndTag()) {
            this.appendSpace();
        }
        this.xml.append("<!--");
        return this;
    }

    public XMLBuilder addContentComment(String content) {
        if (this.isJoinCommentLines()) {
            this.appendSpace();
            this.xml.append(StringUtils.normalizeSpace(content));
            this.appendSpace();
        } else {
            this.xml.append(content);
        }
        return this;
    }

    public XMLBuilder addDeclTagStart(DTDDeclNode tag) {
        this.xml.append("<!" + tag.getDeclType());
        return this;
    }

    public XMLBuilder addDeclTagStart(String declTagName) {
        this.xml.append("<!" + declTagName);
        return this;
    }

    public XMLBuilder startDoctype() {
        this.xml.append("<!DOCTYPE");
        return this;
    }

    public XMLBuilder startDTDElementDecl() {
        this.xml.append("<!ELEMENT");
        return this;
    }

    public XMLBuilder startDTDAttlistDecl() {
        this.xml.append("<!ATTLIST");
        return this;
    }

    public XMLBuilder addParameter(String parameter) {
        return this.addUnindentedParameter(" " + this.replaceQuotesIfNeeded(parameter));
    }

    public XMLBuilder addUnindentedParameter(String parameter) {
        this.xml.append(this.replaceQuotesIfNeeded(parameter));
        return this;
    }

    public XMLBuilder startDoctypeInternalSubset() {
        this.xml.append(" [");
        return this;
    }

    public XMLBuilder startUnindentedDoctypeInternalSubset() {
        this.xml.append("[");
        return this;
    }

    public XMLBuilder endDoctypeInternalSubset() {
        this.xml.append("]");
        return this;
    }

    public XMLBuilder endComment() {
        this.xml.append("-->");
        return this;
    }

    public XMLBuilder endDoctype() {
        this.xml.append(">");
        return this;
    }

    public boolean isLastLineEmptyOrWhitespace() {
        int i;
        if (this.xml.length() == 0) {
            return true;
        }
        for (i = this.xml.length() - 1; i > 0 && Character.isSpaceChar(this.xml.charAt(i)); --i) {
        }
        return i > 0 && (this.xml.charAt(i) == '\r' || this.xml.charAt(i) == '\n');
    }

    private String replaceQuotesIfNeeded(String str) {
        if (this.getEnforceQuoteStyle() != EnforceQuoteStyle.preferred) {
            return str;
        }
        if (StringUtils.isQuoted(str)) {
            String quote = this.getQuotationAsString();
            return quote + StringUtils.convertToQuotelessValue(str) + quote;
        }
        return str;
    }

    private EnforceQuoteStyle getEnforceQuoteStyle() {
        return this.sharedSettings.getFormattingSettings().getEnforceQuoteStyle();
    }

    private String getQuotationAsString() {
        return this.sharedSettings.getPreferences().getQuotationAsString();
    }

    private boolean isJoinCommentLines() {
        return this.sharedSettings.getFormattingSettings().isJoinCommentLines();
    }

    private boolean isJoinCDATALines() {
        return this.sharedSettings.getFormattingSettings().isJoinCDATALines();
    }

    private boolean isSplitAttributes() {
        return this.sharedSettings.getFormattingSettings().isSplitAttributes();
    }

    private boolean isInsertSpaces() {
        return this.sharedSettings.getFormattingSettings().isInsertSpaces();
    }

    private int getTabSize() {
        return this.sharedSettings.getFormattingSettings().getTabSize();
    }

    private boolean isJoinContentLines() {
        return this.sharedSettings.getFormattingSettings().isJoinContentLines();
    }

    private boolean isPreserveEmptyContent() {
        return this.sharedSettings.getFormattingSettings().isPreserveEmptyContent();
    }

    private boolean isTrimTrailingWhitespace() {
        return this.sharedSettings.getFormattingSettings().isTrimTrailingWhitespace();
    }

    private int getPreservedNewlines() {
        return this.sharedSettings.getFormattingSettings().getPreservedNewlines();
    }

    private boolean isSpaceBeforeEmptyCloseTag() {
        return this.sharedSettings.getFormattingSettings().isSpaceBeforeEmptyCloseTag();
    }

    private char getQuotationAsChar() {
        return this.sharedSettings.getPreferences().getQuotationAsChar();
    }
}

