/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.settings.AllXMLSettings;
import org.eclipse.lemminx.settings.InitializationOptionsSettings;
import org.eclipse.lemminx.settings.XMLExcludedSymbolFile;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.settings.XMLGeneralClientSettings;
import org.eclipse.lemminx.settings.capabilities.InitializationOptionsExtendedClientCapabilities;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SettingsTest {
    private static String testFolder = "TestXMLCacheFolder";
    private static String targetTestFolder = "target" + File.separator + "generated-test-sources";
    private final String json = "{\r\n\t\"settings\": {\r\n\t\t\"xml\": {\r\n\t\t\t\"fileAssociations\": [\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\spring-beans-3.0.xsd\",\r\n\t\t\t\t\t\"pattern\": \"**/test*.xml\"\r\n\t\t\t\t},\r\n\t\t\t\t{\r\n\t\t\t\t\t\"systemId\": \"src\\\\test\\\\resources\\\\xsd\\\\projectDescription.xsd\",\r\n\t\t\t\t\t\"pattern\": \"projectDescription.xml\"\r\n\t\t\t\t}\r\n\t\t\t],\r\n\t\t\t\"catalogs\": [\r\n\t\t\t\t\"src\\\\test\\\\resources\\\\catalogs\\\\catalog.xml\"\r\n\t\t\t],\r\n\t\t\t\"validation\": {\r\n\t\t\t\t\"enabled\": true,\r\n\t\t\t\t\"schema\": false\r\n\t\t\t},\r\n\t\t\t\"format\": {\r\n\t\t\t\t\"tabSize\": 10,\r\n\t\t\t\t\"insertSpaces\": false,\r\n\t\t\t\t\"splitAttributes\": true,\r\n\t\t\t\t\"joinCDATALines\": true,\r\n\t\t\t\t\"formatComments\": true,\r\n\t\t\t\t\"joinCommentLines\": true,\r\n\t\t\t\t\"preserveAttributeLineBreaks\": true\r\n\t\t\t},\r\n\t\t\t\"server\": {\r\n\t\t\t\t\"workDir\": \"~/" + testFolder + "/Nested\"\r\n\t\t\t},\r\n\t\t\t\"symbols\": {\r\n\t\t\t\t\"enabled\": true,\r\n\t\t\t\t\"excluded\": [\"**\\\\*.xsd\", \"**\\\\*.xml\"]\r\n\t\t\t}\r\n\t\t}\r\n\t},\r\n\t\"extendedClientCapabilities\": {\r\n\t\t\"codeLens\": {\r\n\t\t\t\"codeLensKind\": {\r\n\t\t\t\t\"valueSet\": [\r\n\t\t\t\t\t\"references\"\r\n\t\t\t\t]\r\n\t\t\t}\r\n\t\t},\r\n\t\tactionableNotificationSupport: true,\r\n\t\topenSettingsCommandSupport: true\r\n\t}}";

    @AfterEach
    public void cleanup() {
        String path = System.getProperty("user.dir") + File.separator + targetTestFolder + File.separator + testFolder;
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
    }

    @Test
    public void initializationOptionsSettings() {
        InitializeParams params = SettingsTest.createInitializeParams(this.json);
        Object initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        initializationOptionsSettings = AllXMLSettings.getAllXMLSettings((Object)initializationOptionsSettings);
        XMLGeneralClientSettings settings = XMLGeneralClientSettings.getGeneralXMLSettings((Object)initializationOptionsSettings);
        Assertions.assertNotNull((Object)settings);
        Assertions.assertEquals((Object)("~/" + testFolder + "/Nested"), (Object)settings.getServer().getWorkDir());
        ContentModelSettings cmSettings = ContentModelSettings.getContentModelXMLSettings((Object)initializationOptionsSettings);
        Assertions.assertNotNull((Object)cmSettings);
        Assertions.assertNotNull((Object)cmSettings.getCatalogs());
        Assertions.assertEquals((int)1, (int)cmSettings.getCatalogs().length);
        Assertions.assertEquals((Object)"src\\test\\resources\\catalogs\\catalog.xml", (Object)cmSettings.getCatalogs()[0]);
        Assertions.assertNotNull((Object)cmSettings.getFileAssociations());
        Assertions.assertEquals((int)2, (int)cmSettings.getFileAssociations().length);
        Assertions.assertEquals((Object)"src\\test\\resources\\xsd\\spring-beans-3.0.xsd", (Object)cmSettings.getFileAssociations()[0].getSystemId());
        Assertions.assertEquals((Object)"**/test*.xml", (Object)cmSettings.getFileAssociations()[0].getPattern());
        Assertions.assertNotNull((Object)cmSettings.getValidation());
        Assertions.assertEquals((Object)true, (Object)cmSettings.getValidation().isEnabled());
        Assertions.assertEquals((Object)false, (Object)cmSettings.getValidation().isSchema());
        Assertions.assertNotNull((Object)settings.getSymbols());
        Assertions.assertEquals((Object)true, (Object)settings.getSymbols().isEnabled());
        Assertions.assertArrayEquals((Object[])new String[]{"**\\*.xsd", "**\\*.xml"}, (Object[])settings.getSymbols().getExcluded());
    }

    private static InitializeParams createInitializeParams(String json) {
        InitializeParams initializeParams = new InitializeParams();
        Object initializationOptions = new Gson().fromJson(json, JsonObject.class);
        initializeParams.setInitializationOptions(initializationOptions);
        return initializeParams;
    }

    @Test
    public void formatSettings() {
        FormattingOptions formattingOptions = new FormattingOptions();
        formattingOptions.setTabSize(5);
        formattingOptions.setInsertSpaces(false);
        XMLFormattingOptions xmlFormattingOptions = new XMLFormattingOptions(formattingOptions, false);
        Assertions.assertEquals((int)5, (int)xmlFormattingOptions.getTabSize());
        Assertions.assertFalse((boolean)xmlFormattingOptions.isInsertSpaces());
        Assertions.assertFalse((boolean)xmlFormattingOptions.isJoinCommentLines());
        XMLFormattingOptions sharedXMLFormattingOptions = new XMLFormattingOptions(true);
        sharedXMLFormattingOptions.setTabSize(10);
        sharedXMLFormattingOptions.setInsertSpaces(true);
        sharedXMLFormattingOptions.setJoinCommentLines(true);
        xmlFormattingOptions.merge((FormattingOptions)sharedXMLFormattingOptions);
        Assertions.assertEquals((int)10, (int)xmlFormattingOptions.getTabSize());
        Assertions.assertTrue((boolean)xmlFormattingOptions.isInsertSpaces());
        Assertions.assertTrue((boolean)xmlFormattingOptions.isJoinCommentLines());
    }

    @Test
    public void formatSettingsOverride() {
        XMLFormattingOptions options = new XMLFormattingOptions();
        options.setPreserveAttrLineBreaks(true);
        options.setSplitAttributes(false);
        Assertions.assertTrue((boolean)options.isPreserveAttrLineBreaks());
        options.setSplitAttributes(true);
        Assertions.assertFalse((boolean)options.isPreserveAttrLineBreaks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cachePathSettings() {
        InitializeParams params = SettingsTest.createInitializeParams(this.json);
        Object initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        XMLLanguageServer languageServer = new XMLLanguageServer();
        String originalUserHome = System.getProperty("user.home");
        String userDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.home", userDir + File.separator + targetTestFolder);
            languageServer.updateSettings(initializationOptionsSettings);
            Assertions.assertEquals((Object)(System.getProperty("user.home") + File.separator + testFolder + File.separator + "Nested"), (Object)FilesUtils.getCachePathSetting());
        }
        catch (Exception e) {
            Assertions.fail();
        }
        finally {
            FilesUtils.setCachePathSetting(null);
            System.setProperty("user.home", originalUserHome);
        }
    }

    @Test
    public void symbolSettingsTest() {
        InitializeParams params = SettingsTest.createInitializeParams(this.json);
        Object initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        XMLLanguageServer languageServer = new XMLLanguageServer();
        languageServer.updateSettings(initializationOptionsSettings);
        XMLExcludedSymbolFile xsdFile = new XMLExcludedSymbolFile("**\\*.xsd");
        XMLExcludedSymbolFile xmlFile = new XMLExcludedSymbolFile("**\\*.xml");
        Object[] expectedExcludedFiles = new XMLExcludedSymbolFile[]{xsdFile, xmlFile};
        Object[] actualExpectedFiles = languageServer.getSettings().getSymbolSettings().getExcludedFiles();
        Assertions.assertArrayEquals((Object[])expectedExcludedFiles, (Object[])actualExpectedFiles);
    }

    @Test
    public void extendedClientCapabilitiesTest() {
        InitializeParams params = SettingsTest.createInitializeParams(this.json);
        ExtendedClientCapabilities clientCapabilities = InitializationOptionsExtendedClientCapabilities.getExtendedClientCapabilities((InitializeParams)params);
        Assertions.assertNotNull((Object)clientCapabilities);
        Assertions.assertNotNull((Object)clientCapabilities.getCodeLens());
        Assertions.assertNotNull((Object)clientCapabilities.getCodeLens().getCodeLensKind());
        Assertions.assertNotNull((Object)clientCapabilities.getCodeLens().getCodeLensKind().getValueSet());
        Assertions.assertEquals((int)1, (int)clientCapabilities.getCodeLens().getCodeLensKind().getValueSet().size());
        Assertions.assertEquals((Object)"references", clientCapabilities.getCodeLens().getCodeLensKind().getValueSet().get(0));
        Assertions.assertTrue((boolean)clientCapabilities.isActionableNotificationSupport());
        Assertions.assertTrue((boolean)clientCapabilities.isOpenSettingsCommandSupport());
    }
}

