/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.io.FileOutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.junit.jupiter.api.Test;

public class DTDCompletionWithCacheExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void dtdCache() throws Exception {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
        };
        Path expectedLocation = TEST_WORK_DIRECTORY.resolve("cache/http/www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        Files.createDirectories(expectedLocation.getParent(), new FileAttribute[0]);
        Path path = Files.createFile(expectedLocation, new FileAttribute[0]);
        try (ReadableByteChannel rbc = Channels.newChannel(DTDCompletionWithCacheExtensionsTest.class.getResourceAsStream("/dtd/svg.dtd"));
             FileOutputStream fos = new FileOutputStream(path.toFile());){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        String fileURI = "test.xml";
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\r\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\r\n<svg xmlns=\"http://www.w3.org/2000/svg\">\r\n    <animate attributeName=\"foo\">\r\n        |\r\n";
        XMLLanguageService ls2 = new XMLLanguageService();
        XMLAssert.testCompletionFor(ls2, xml, null, configuration, fileURI, null, true, XMLAssert.c("desc", XMLAssert.te(4, 8, 4, 8, "<desc></desc>"), "desc"));
    }
}

