/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;

public class CacheResourceDownloadingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_LOADING_MSG = "The resource ''{0}'' is downloading.";
    private static final String RESOURCE_NOT_IN_DEPLOYED_PATH_MSG = "The resource ''{0}'' cannot be downloaded in the cache path.";
    private final String resourceURI;
    private final CompletableFuture<Path> future;

    public CacheResourceDownloadingException(String resourceURI) {
        super(MessageFormat.format(RESOURCE_NOT_IN_DEPLOYED_PATH_MSG, resourceURI));
        this.resourceURI = resourceURI;
        this.future = null;
    }

    public CacheResourceDownloadingException(String resourceURI, CompletableFuture<Path> future) {
        super(MessageFormat.format(RESOURCE_LOADING_MSG, resourceURI));
        this.resourceURI = resourceURI;
        this.future = future;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public boolean isDTD() {
        return this.resourceURI != null && this.resourceURI.endsWith(".dtd");
    }

    public CompletableFuture<Path> getFuture() {
        return this.future;
    }
}

