/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.concurrent.CancellationException;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.commons.TextDocumentVersionChecker;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DOMDocumentVersionCheckerTest {
    @Test
    public void stopDOMParsing() {
        TextDocument textDocument = DOMDocumentVersionCheckerTest.createTextDocument();
        int version = 1;
        textDocument.setVersion(version);
        CancellationException ex = null;
        TextDocumentVersionChecker checker = new TextDocumentVersionChecker(textDocument, version);
        try {
            DOMParser.getInstance().parse(textDocument, null, true, (CancelChecker)checker);
        }
        catch (CancellationException e) {
            ex = e;
        }
        Assertions.assertNull((Object)ex);
        ex = null;
        version = 2;
        textDocument.setVersion(version);
        try {
            DOMParser.getInstance().parse(textDocument, null, true, (CancelChecker)checker);
        }
        catch (CancellationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)ex);
        ex = null;
        checker = new TextDocumentVersionChecker(textDocument, version);
        try {
            DOMParser.getInstance().parse(textDocument, null, true, (CancelChecker)checker);
        }
        catch (CancellationException e) {
            ex = e;
        }
        Assertions.assertNull((Object)ex);
    }

    @Test
    public void positionAt() throws BadLocationException {
        TextDocument textDocument = DOMDocumentVersionCheckerTest.createTextDocument();
        int version = 1;
        textDocument.setVersion(version);
        TextDocumentVersionChecker checker = new TextDocumentVersionChecker(textDocument, version);
        DOMDocument document = DOMParser.getInstance().parse(textDocument, null, true, (CancelChecker)checker);
        CancellationException ex = null;
        try {
            document.positionAt(0);
        }
        catch (CancellationException e) {
            ex = e;
        }
        Assertions.assertNull((Object)ex);
        ex = null;
        textDocument.setVersion(++version);
        try {
            document.positionAt(0);
        }
        catch (CancellationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)ex);
    }

    private static TextDocument createTextDocument() {
        return new TextDocument("<root />", "nasa.xml");
    }
}

