/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.ETagRequiredCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.ETagUnterminatedCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.ElementUnterminatedCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.EqRequiredInAttributeCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.MarkupEntityMismatchCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.NoGrammarConstraintsCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.OpenQuoteExpectedCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.RootElementTypeMustMatchDoctypedeclCodeAction;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public enum XMLSyntaxErrorCode implements IXMLErrorCode
{
    AttributeNotUnique,
    AttributeNSNotUnique,
    AttributePrefixUnbound,
    ContentIllegalInProlog,
    DashDashInComment,
    ElementUnterminated,
    ElementPrefixUnbound,
    EmptyPrefixedAttName,
    EncodingDeclRequired,
    ETagRequired,
    ETagUnterminated,
    EqRequiredInAttribute,
    EqRequiredInXMLDecl,
    IllegalQName,
    InvalidCommentStart,
    LessthanInAttValue,
    MarkupEntityMismatch,
    MarkupNotRecognizedInContent,
    NameRequiredInReference,
    OpenQuoteExpected,
    PITargetRequired,
    PseudoAttrNameExpected,
    QuoteRequiredInXMLDecl,
    RootElementTypeMustMatchDoctypedecl,
    SDDeclInvalid,
    SemicolonRequiredInReference,
    SpaceRequiredBeforeEncodingInXMLDecl,
    SpaceRequiredBeforeStandalone,
    SpaceRequiredInPI,
    VersionInfoRequired,
    VersionNotSupported,
    XMLDeclUnterminated,
    CustomETag,
    PrematureEOF,
    DoctypeNotAllowed,
    NoMorePseudoAttributes,
    NoGrammarConstraints;

    private final String code;
    private static final Map<String, XMLSyntaxErrorCode> codes;

    private XMLSyntaxErrorCode() {
        this(null);
    }

    private XMLSyntaxErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static XMLSyntaxErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, XMLSyntaxErrorCode code, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (code) {
            case SpaceRequiredBeforeStandalone: 
            case SpaceRequiredBeforeEncodingInXMLDecl: 
            case VersionInfoRequired: 
            case ElementPrefixUnbound: 
            case RootElementTypeMustMatchDoctypedecl: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case EqRequiredInAttribute: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case NoMorePseudoAttributes: 
            case EncodingDeclRequired: 
            case EqRequiredInXMLDecl: {
                return XMLPositionUtility.selectAttributeNameAt(offset, document);
            }
            case AttributeNSNotUnique: {
                String attrName = StringUtils.getString(arguments[1]);
                Range xmlns = XMLPositionUtility.selectAttributeNameFromGivenNameAt("xmlns:" + attrName, offset, document);
                if (xmlns != null) {
                    return xmlns;
                }
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case AttributeNotUnique: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case AttributePrefixUnbound: {
                return XMLPositionUtility.selectAttributePrefixFromGivenNameAt(StringUtils.getString(arguments[1]), offset, document);
            }
            case LessthanInAttValue: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case QuoteRequiredInXMLDecl: {
                String attrName = StringUtils.getString(arguments[0]);
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case EmptyPrefixedAttName: {
                QName qName = (QName)arguments[0];
                return XMLPositionUtility.selectAttributeValueAt(qName.rawname, offset, document);
            }
            case SDDeclInvalid: 
            case VersionNotSupported: {
                String attrValue = StringUtils.getString(arguments[0]);
                return XMLPositionUtility.selectAttributeValueByGivenValueAt(attrValue, offset, document);
            }
            case ETagUnterminated: {
                int endOffset = XMLSyntaxErrorCode.removeLeftSpaces(offset, document.getText());
                return XMLPositionUtility.selectEndTagName(endOffset, document);
            }
            case CustomETag: {
                return XMLPositionUtility.selectEndTagName(offset, document);
            }
            case ElementUnterminated: {
                DOMNode node = document.findNodeAt(offset);
                if (node != null && node.isElement()) {
                    DOMElement tagElement = (DOMElement)node;
                    int endOffset = offset;
                    if (tagElement.hasChildNodes()) {
                        for (DOMNode child : tagElement.getChildren()) {
                            if (!child.isElement()) continue;
                            endOffset = child.getStart() - 1;
                            break;
                        }
                    }
                    return XMLSyntaxErrorCode.getRangeFromStartNodeToOffset(tagElement, endOffset, document);
                }
                return null;
            }
            case MarkupEntityMismatch: {
                DOMNode root = document.getDocumentElement();
                if (root == null) {
                    root = document.getChild(0);
                }
                return XMLSyntaxErrorCode.getRangeFromStartNodeToOffset(root, offset, document);
            }
            case ETagRequired: {
                String tag = StringUtils.getString(arguments[0]);
                DOMNode node = document.findNodeAt(offset);
                DOMElement startTagElement = null;
                if (node != null && node.isElement()) {
                    DOMElement element = (DOMElement)node;
                    if (element.isOrphanEndTag()) {
                        startTagElement = element.getParentElement();
                    } else if (element.isInEndTag(offset)) {
                        startTagElement = XMLSyntaxErrorCode.findChildTag(tag, element);
                    }
                    return XMLSyntaxErrorCode.getRangeFromStartNodeToOffset(startTagElement, offset, document);
                }
                return null;
            }
            case SemicolonRequiredInReference: {
                XMLPositionUtility.EntityReferenceRange range = XMLPositionUtility.selectEntityReference(offset + 1, document, false);
                return range != null ? range.getRange() : null;
            }
            case ContentIllegalInProlog: {
                int startOffset = offset + 1;
                int endOffset = 0;
                int errorOffset = offset + 1;
                String text = document.getText();
                int startPrologOffset = text.indexOf("<");
                if (errorOffset < startPrologOffset) {
                    startOffset = errorOffset;
                    endOffset = startPrologOffset;
                } else {
                    int firstStartTagOffset = text.indexOf("<", errorOffset);
                    startOffset = errorOffset;
                    endOffset = firstStartTagOffset != -1 ? firstStartTagOffset : text.length();
                }
                return XMLPositionUtility.createRange(startOffset, endOffset, document);
            }
            case DashDashInComment: {
                int endOffset = offset + 1;
                int startOffset = offset - 1;
                return XMLPositionUtility.createRange(startOffset, endOffset, document);
            }
            case IllegalQName: 
            case InvalidCommentStart: 
            case MarkupNotRecognizedInContent: {
                return XMLPositionUtility.createRange(offset, offset + 1, document);
            }
            case NameRequiredInReference: {
                break;
            }
            case OpenQuoteExpected: {
                return XMLPositionUtility.selectAttributeNameAt(offset - 1, document);
            }
            case DoctypeNotAllowed: {
                DOMDocumentType docType = document.getDoctype();
                return XMLPositionUtility.createRange(docType);
            }
            case PITargetRequired: {
                break;
            }
            case PseudoAttrNameExpected: {
                break;
            }
            case SpaceRequiredInPI: {
                int start = XMLPositionUtility.selectCurrentTagOffset(offset, document) + 1;
                int end = offset + 1;
                return XMLPositionUtility.createRange(start, end, document);
            }
            case PrematureEOF: 
            case XMLDeclUnterminated: {
                break;
            }
        }
        return null;
    }

    private static int removeLeftSpaces(int initialOffset, String text) {
        int offset = initialOffset;
        if (offset >= text.length()) {
            return text.length();
        }
        char ch = text.charAt(offset);
        while (Character.isWhitespace(ch)) {
            ch = text.charAt(--offset);
        }
        boolean enclosed = false;
        if (ch == '/') {
            char previous = text.charAt(offset - 1);
            if (previous == '<') {
                enclosed = false;
                --offset;
            } else {
                enclosed = true;
            }
        } else if (ch != '<') {
            enclosed = true;
        }
        if (enclosed) {
            return offset + 1;
        }
        return offset;
    }

    private static Range getRangeFromStartNodeToOffset(DOMNode fromNode, int toOffset, DOMDocument document) {
        DOMElement fromElement;
        int endOffset = XMLSyntaxErrorCode.removeLeftSpaces(toOffset, document.getText());
        int startOffset = fromNode.getStart();
        if (fromNode.isElement() && (fromElement = (DOMElement)fromNode).hasTagName()) {
            startOffset = fromElement.getStartTagOpenOffset() + 1;
            endOffset = Math.max(endOffset, fromElement.getStartTagOpenOffset() + fromElement.getTagName().length());
        }
        return XMLPositionUtility.createRange(startOffset, endOffset, document);
    }

    private static DOMElement findChildTag(String tagName, DOMElement element) {
        List<DOMNode> children = element.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            DOMNode child = children.get(i);
            if (!child.isElement()) continue;
            DOMElement childElement = (DOMElement)child;
            if (childElement.isSameTag(tagName)) {
                return childElement;
            }
            DOMElement tagElement = XMLSyntaxErrorCode.findChildTag(tagName, childElement);
            if (tagElement == null) continue;
            return tagElement;
        }
        return null;
    }

    public static void registerCodeActionParticipants(Map<String, ICodeActionParticipant> codeActions, SharedSettings sharedSettings) {
        codeActions.put(ETagUnterminated.getCode(), new ETagUnterminatedCodeAction());
        codeActions.put(ElementUnterminated.getCode(), new ElementUnterminatedCodeAction());
        codeActions.put(EqRequiredInAttribute.getCode(), new EqRequiredInAttributeCodeAction());
        codeActions.put(OpenQuoteExpected.getCode(), new OpenQuoteExpectedCodeAction());
        codeActions.put(MarkupEntityMismatch.getCode(), new MarkupEntityMismatchCodeAction());
        codeActions.put(ETagRequired.getCode(), new ETagRequiredCodeAction());
        codeActions.put(RootElementTypeMustMatchDoctypedecl.getCode(), new RootElementTypeMustMatchDoctypedeclCodeAction());
        if (sharedSettings.getWorkspaceSettings().isResourceOperationSupported("create")) {
            codeActions.put(NoGrammarConstraints.getCode(), new NoGrammarConstraintsCodeAction());
        }
    }

    static {
        codes = new HashMap<String, XMLSyntaxErrorCode>();
        for (XMLSyntaxErrorCode errorCode : XMLSyntaxErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

