/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class RootElementTypeMustMatchDoctypedeclCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        DOMElement root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        Range rootStartRange = XMLPositionUtility.selectStartTagName(root);
        if (!range.equals((Object)rootStartRange)) {
            return;
        }
        String currentRootText = RootElementTypeMustMatchDoctypedeclCodeAction.getCurrentRoot(diagnostic.getMessage());
        if (currentRootText == null || !currentRootText.equals(root.getNodeName())) {
            return;
        }
        String doctypeRootText = RootElementTypeMustMatchDoctypedeclCodeAction.getDoctypeRoot(diagnostic.getMessage());
        if (doctypeRootText == null) {
            return;
        }
        ArrayList<TextEdit> replace = new ArrayList<TextEdit>();
        this.addTextEdits(root, doctypeRootText, replace);
        CodeAction action = CodeActionFactory.replace("Replace with '" + doctypeRootText + "'", replace, document.getTextDocument(), diagnostic);
        codeActions.add(action);
    }

    private void addTextEdits(DOMElement root, String newText, List<TextEdit> replace) {
        replace.add(new TextEdit(XMLPositionUtility.selectStartTagName(root), newText));
        if (root.isClosed() && !root.isSelfClosed()) {
            replace.add(new TextEdit(XMLPositionUtility.selectEndTagName(root), newText));
        }
    }

    private static String getCurrentRoot(String message) {
        String preText = "root element \"";
        String postText = "\", must match DOCTYPE";
        int preMatch = message.indexOf(preText);
        if (preMatch < 0) {
            return null;
        }
        int postMatch = message.indexOf(postText);
        if (postMatch < 0) {
            return null;
        }
        return message.substring(preMatch + preText.length(), postMatch);
    }

    private static String getDoctypeRoot(String message) {
        String preText = "DOCTYPE root \"";
        int preMatch = message.indexOf(preText);
        if (preMatch < 0) {
            return null;
        }
        return message.substring(preMatch + preText.length(), message.length() - 2);
    }
}

