/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.List;
import java.util.Set;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.contentmodel.model.GrammarCacheInfo;
import org.eclipse.lemminx.extensions.contentmodel.model.ReferencedGrammarInfo;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.extensions.ISymbolsProviderParticipant;
import org.eclipse.lemminx.settings.XMLSymbolFilter;
import org.eclipse.lemminx.uriresolver.ResolvedURIInfo;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelSymbolsProviderParticipant
implements ISymbolsProviderParticipant {
    private static final Range DUMMY_RANGE = new Range(new Position(0, 0), new Position(0, 1));
    private static final String GRAMMARS_CATEGORY = "Grammars";
    private final ContentModelManager contentModelManager;
    private boolean enabled;

    public ContentModelSymbolsProviderParticipant(ContentModelManager contentModelManager) {
        this.contentModelManager = contentModelManager;
        this.setEnabled(true);
    }

    @Override
    public ISymbolsProviderParticipant.SymbolStrategy applyFor(DOMDocument document) {
        return ISymbolsProviderParticipant.SymbolStrategy.INSERT;
    }

    @Override
    public void findSymbolInformations(DOMDocument document, SymbolInformationResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
    }

    @Override
    public void findDocumentSymbols(DOMDocument document, DocumentSymbolsResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
        if (!this.isEnabled()) {
            return;
        }
        Set<ReferencedGrammarInfo> referencedGrammarInfos = this.contentModelManager.getReferencedGrammarInfos(document);
        if (referencedGrammarInfos.isEmpty()) {
            return;
        }
        DocumentSymbol rootSymbol = new DocumentSymbol(GRAMMARS_CATEGORY, SymbolKind.Module, DUMMY_RANGE, DUMMY_RANGE);
        symbols.add(rootSymbol);
        DocumentSymbolsResult children = symbols.createList();
        rootSymbol.setChildren((List)children);
        for (ReferencedGrammarInfo info : referencedGrammarInfos) {
            String resolverName;
            ResolvedURIInfo resolvedInfo = info.getResolvedURIInfo();
            DocumentSymbol grammarInfoSymbol = new DocumentSymbol(resolvedInfo.getResolvedURI(), SymbolKind.File, DUMMY_RANGE, DUMMY_RANGE);
            children.add(grammarInfoSymbol);
            DocumentSymbolsResult grammarInfoSymbols = symbols.createList();
            grammarInfoSymbol.setChildren((List)grammarInfoSymbols);
            ContentModelProvider.Identifier identifier = info.getIdentifier();
            StringBuilder bindingName = new StringBuilder("Binding: ");
            if (identifier != null) {
                bindingName.append(identifier.getKind());
            }
            if (!"default".equals(resolverName = resolvedInfo.getResolverName())) {
                if (identifier != null) {
                    bindingName.append(" (");
                }
                bindingName.append("with ");
                bindingName.append(resolverName);
                if (identifier != null) {
                    bindingName.append(")");
                }
            }
            DOMRange domRange = identifier != null ? identifier.getRange() : null;
            Range range = domRange != null ? XMLPositionUtility.createRange(domRange) : DUMMY_RANGE;
            DocumentSymbol bindingInfoSymbol = new DocumentSymbol(bindingName.toString(), SymbolKind.Property, range, range);
            grammarInfoSymbols.add(bindingInfoSymbol);
            DocumentSymbol cacheInfoSymbol = null;
            if (!info.isInCache()) {
                cacheInfoSymbol = new DocumentSymbol("Cache: false", SymbolKind.Property, DUMMY_RANGE, DUMMY_RANGE);
            } else {
                cacheInfoSymbol = new DocumentSymbol("Cache", SymbolKind.Property, DUMMY_RANGE, DUMMY_RANGE);
                cacheInfoSymbol.setChildren((List)symbols.createList());
                GrammarCacheInfo grammarCacheInfo = info.getGrammarCacheInfo();
                DocumentSymbol cacheFileSymbol = new DocumentSymbol(grammarCacheInfo.getCachedResolvedUri(), SymbolKind.File, DUMMY_RANGE, DUMMY_RANGE);
                cacheInfoSymbol.getChildren().add(cacheFileSymbol);
            }
            grammarInfoSymbols.add(cacheInfoSymbol);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

