/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.lemminx.extensions.generators.ElementDeclaration;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.XMLChar;
import org.eclipse.lemminx.utils.StringUtils;

public class AttributeDeclaration {
    private final String name;
    private final ElementDeclaration ownerElementDecl;
    private final SortedSet<String> values;
    private int occurrences;
    private boolean unique;
    private boolean allNames;
    private boolean allNMTOKENs;
    private DataType dataType;

    public AttributeDeclaration(String name, ElementDeclaration ownerElementDecl) {
        this.name = name;
        this.ownerElementDecl = ownerElementDecl;
        this.values = new TreeSet<String>();
        this.occurrences = 0;
        this.allNames = true;
        this.allNMTOKENs = true;
        this.unique = true;
    }

    public String getName() {
        return this.name;
    }

    public void incrementOccurrences() {
        ++this.occurrences;
    }

    public void addValue(String value) {
        if (!this.values.contains(value)) {
            this.values.add(value);
            if (this.allNames && !XMLChar.isValidName(value)) {
                this.allNames = false;
            }
            if (this.allNMTOKENs && !XMLChar.isValidNmtoken(value)) {
                this.allNMTOKENs = false;
            }
            if (this.dataType == null) {
                this.dataType = AttributeDeclaration.getDataType(value);
            } else {
                DataType newDataType = AttributeDeclaration.getDataType(value);
                if (this.dataType != newDataType) {
                    this.dataType = DataType.UNKNOWN;
                }
            }
        } else {
            this.unique = false;
        }
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public boolean isID(FileContentGeneratorSettings settings) {
        boolean id;
        if (this.ownerElementDecl.hasAttributeId()) {
            return false;
        }
        boolean bl = id = this.isAllNames() && this.isUnique() && this.getOccurrences() >= settings.getMinIdValues();
        if (id) {
            this.ownerElementDecl.setAttributeID(true);
        }
        return id;
    }

    public boolean isRequired() {
        return this.getOccurrences() == this.ownerElementDecl.getOccurrences();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isAllNames() {
        return this.allNames;
    }

    public boolean isAllNMTOKENs() {
        return this.allNMTOKENs;
    }

    public SortedSet<String> getValues() {
        return this.values;
    }

    public boolean isFixedValue(FileContentGeneratorSettings settings) {
        return this.isRequired() && this.getValues().size() == 1 && this.getOccurrences() >= settings.getMinFixed();
    }

    public boolean isEnums(FileContentGeneratorSettings settings) {
        return this.isAllNMTOKENs() && this.getOccurrences() >= settings.getMinEnumerationInstances() && this.getValues().size() <= this.getOccurrences() / settings.getMinEnumerationRatio() && this.getValues().size() <= settings.getMaxEnumerationValues();
    }

    public DataType getDataType() {
        return this.dataType != null ? this.dataType : DataType.UNKNOWN;
    }

    private static DataType getDataType(String value) {
        String string = value = value != null ? value.trim() : null;
        if (StringUtils.isEmpty(value)) {
            return DataType.UNKNOWN;
        }
        try {
            Integer.parseInt(value);
            return DataType.INTEGER;
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(value);
                return DataType.DECIMAL;
            }
            catch (Exception exception2) {
                if ("true".equals(value) || "1".equals(value) || "false".equals(value) || "0".equals(value)) {
                    return DataType.BOOLEAN;
                }
                try {
                    LocalDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    return DataType.DATE_TIME;
                }
                catch (Exception e) {
                    try {
                        LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
                        return DataType.DATE_TIME;
                    }
                    catch (Exception exception3) {
                        try {
                            if (LocalDate.parse(value) != null) {
                                return DataType.DATE;
                            }
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                        return DataType.UNKNOWN;
                    }
                }
            }
        }
    }

    public static enum DataType {
        UNKNOWN,
        DATE,
        DATE_TIME,
        DECIMAL,
        BOOLEAN,
        INTEGER;

    }
}

