/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.ProjectUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractCacheBasedTest {
    protected static Path TEST_WORK_DIRECTORY = ProjectUtils.getProjectDirectory().resolve("target/test-cache");

    @BeforeEach
    public final void setupCache() throws Exception {
        this.clearCache();
        System.setProperty("lemminx.workdir", TEST_WORK_DIRECTORY.toAbsolutePath().toString());
    }

    @AfterEach
    public final void clearCache() throws IOException {
        if (Files.exists(TEST_WORK_DIRECTORY, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)TEST_WORK_DIRECTORY, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        System.clearProperty("lemminx.workdir");
        FilesUtils.resetDeployPath();
    }
}

