/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsCapabilities;
import org.junit.jupiter.api.Test;

public class DTDDiagnosticsTest {
    @Test
    public void MSG_ELEMENT_NOT_DECLARED() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<!DOCTYPE web-app\r\n   PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\r\n   \"http://java.sun.com/dtd/web-app_2_3.dtd\">\r\n\r\n<web-app>\r\n\t<XXX></XXX>\r\n</web-app>";
        DTDDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(6, 2, 5, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(5, 1, 8, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INVALID));
    }

    @Test
    public void MSG_ELEMENT_NOT_DECLARED_Public() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<!DOCTYPE web-app\r\n   PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\r\n   \"ABCD.dtd\">\r\n\r\n<web-app>\r\n\t<XXX></XXX>\r\n</web-app>";
        DTDDiagnosticsTest.testPublicDiagnosticsFor(xml, XMLAssert.d(6, 2, 5, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(5, 1, 8, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INVALID));
    }

    @Test
    public void MSG_CONTENT_INVALID() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE note [\r\n<!ELEMENT note (to,from,heading,body)>\r\n    <!ELEMENT to (#PCDATA)>\r\n        <!ELEMENT from (#PCDATA)>\r\n                <!ELEMENT heading (#PCDATA)>\r\n            <!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n\t<from>Jani</from>\r\n\t<heading>Reminder</heading>\r\n\t<body>Don't forget me this weekend</body>\r\n</note>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(8, 1, 5, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INVALID));
    }

    @Test
    public void MSG_ATTRIBUTE_NOT_DECLARED() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE note [\r\n<!ELEMENT note (to,from,heading,body)>\r\n<!ELEMENT to (#PCDATA)>\r\n<!ELEMENT from (#PCDATA)>\r\n<!ELEMENT heading (#PCDATA)>\r\n<!ELEMENT body (#PCDATA)>\r\n]>\r\n<note>\r\n    <to></to>\r\n    <from XXXX=\"\" >Jani</from>\r\n    <heading>Reminder</heading>\r\n    <body>Don't forget me this weekend</body>\r\n</note> ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(10, 10, 14, (IXMLErrorCode)DTDErrorCode.MSG_ATTRIBUTE_NOT_DECLARED));
    }

    @Test
    public void MSG_FIXED_ATTVALUE_INVALID() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE address [\r\n  <!ELEMENT address (company)*>\r\n  <!ELEMENT company (#PCDATA)>\r\n  <!ATTLIST company name NMTOKEN #FIXED \"tutorialspoint\">\r\n]>\r\n<address>\r\n  <company name=\"etutorialspoint\">we are a free online teaching faculty</company>\r\n</address>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(7, 16, 33, (IXMLErrorCode)DTDErrorCode.MSG_FIXED_ATTVALUE_INVALID));
    }

    @Test
    public void MSG_ATTRIBUTE_VALUE_NOT_IN_LIST() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE foo [\r\n  <!ELEMENT foo (bar)*>\r\n  <!ELEMENT bar (#PCDATA)>\r\n  <!ATTLIST bar fruit (one | two | three) #REQUIRED>\r\n]>\r\n<foo>\r\n    <bar fruit=\"four\">toto</bar>\r\n</foo>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(7, 15, 21, (IXMLErrorCode)DTDErrorCode.MSG_ATTRIBUTE_VALUE_NOT_IN_LIST));
    }

    @Test
    public void MSG_CONTENT_INCOMPLETE() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE foo [\r\n  <!ELEMENT foo (bar)>\r\n  <!ELEMENT bar (#PCDATA)>\r\n  <!ATTLIST bar fruit (one | two | three) #REQUIRED>\r\n]>\r\n<foo>\r\n    \r\n</foo>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(6, 1, 4, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INCOMPLETE));
    }

    @Test
    public void MSG_REQUIRED_ATTRIBUTE_NOT_SPECIFIED() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE foo [\r\n  <!ELEMENT foo (bar)>\r\n  <!ELEMENT bar (#PCDATA)>\r\n  <!ATTLIST bar fruit (one | two | three) #REQUIRED>\r\n]>\r\n<foo>\r\n    <bar />\r\n</foo>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(7, 5, 8, (IXMLErrorCode)DTDErrorCode.MSG_REQUIRED_ATTRIBUTE_NOT_SPECIFIED));
    }

    @Test
    public void MSG_ELEMENT_WITH_ID_REQUIRED() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEMENT Person (Name,Email?)>\r\n\t<!ATTLIST Person Pin ID #REQUIRED>\r\n\t<!ATTLIST Person Friend IDREF #IMPLIED>\r\n\t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n\t<!ELEMENT Name (#PCDATA)>\r\n\t<!ELEMENT Email (#PCDATA)>\r\n\t]>\r\n<Folks>\r\n    <Person Pin=\"id2\" Likes=\"vfg\"> \r\n        <Name>Bob</Name>\r\n    </Person>\r\n</Folks>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(10, 1, 6, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_WITH_ID_REQUIRED));
    }

    @Test
    public void IDInvalidWithNamespaces() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ELEMENT Person EMPTY>\r\n\t<!ATTLIST Person Pin ID #REQUIRED>\r\n\t]>\r\n<Person Pin=\"7\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(5, 12, 15, (IXMLErrorCode)DTDErrorCode.IDInvalidWithNamespaces));
    }

    @Test
    public void IDREFInvalidWithNamespaces() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ELEMENT Person EMPTY>\r\n\t<!ATTLIST Person Friend IDREF #IMPLIED>\r\n]>\r\n<Person Friend=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(5, 15, 17, (IXMLErrorCode)DTDErrorCode.IDREFInvalidWithNamespaces));
    }

    @Test
    public void IDREFSInvalid() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ELEMENT Person EMPTY>\r\n\t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(5, 14, 16, (IXMLErrorCode)DTDErrorCode.IDREFSInvalid));
    }

    @Test
    public void MSG_MARKUP_NOT_RECOGNIZED_IN_DTD() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ELEMENT Person EMPTY>\r\n   Bad Value   \t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 24, 3, 16, (IXMLErrorCode)DTDErrorCode.MSG_MARKUP_NOT_RECOGNIZED_IN_DTD));
    }

    @Test
    public void QuoteRequiredInPublicID() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION    name PUBLIC asd > \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 27, 30, (IXMLErrorCode)DTDErrorCode.QuoteRequiredInPublicID));
    }

    @Test
    public void QuoteRequiredInPublicID2() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION name PUBLIC    >  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 23, 24, (IXMLErrorCode)DTDErrorCode.QuoteRequiredInPublicID));
    }

    @Test
    public void QuoteRequiredInSystemID() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION name SYSTEM    >  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 23, 24, (IXMLErrorCode)DTDErrorCode.QuoteRequiredInSystemID));
    }

    @Test
    public void OpenQuoteMissingInDecl() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ENTITY asd >   \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 13, 14, (IXMLErrorCode)DTDErrorCode.OpenQuoteMissingInDecl));
    }

    @Test
    public void SpaceRequiredAfterSYSTEM() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION name SYSTEM>  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 23, 24, (IXMLErrorCode)DTDErrorCode.SpaceRequiredAfterSYSTEM));
    }

    @Test
    public void MSG_SPACE_REQUIRED_AFTER_NOTATION_NAME_IN_NOTATIONDECL() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION name>  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 16, 17, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_AFTER_NOTATION_NAME_IN_NOTATIONDECL));
    }

    @Test
    public void AttTypeRequiredInAttDef() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ATTLIST payment name BadType >  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 24, 31, (IXMLErrorCode)DTDErrorCode.AttTypeRequiredInAttDef));
    }

    @Test
    public void EntityDeclUnterminated() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ENTITY copyright \"Copyright W3Schools.\"  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 42, 43, (IXMLErrorCode)DTDErrorCode.EntityDeclUnterminated));
    }

    @Test
    public void EntityNotDeclaredAddToSubset() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n\t<!ENTITY nbsp \"entity-value\">")));
    }

    @Test
    public void EntityNotDeclaredAddToSubsetOneChar() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&a;\r\n</article>";
        Diagnostic d = XMLAssert.d(5, 1, 5, 4, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"a\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n\t<!ENTITY a \"entity-value\">")));
    }

    @Test
    public void EntityNotDeclaredNoPrologNoDoctype() throws Exception {
        String xml = "<article>\r\n\t&nbsp;\r\n</article>";
        Diagnostic d = XMLAssert.d(1, 1, 1, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 0, 0, 0, "<!DOCTYPE article [\r\n\t<!ENTITY nbsp \"entity-value\">\r\n]>\r\n")));
    }

    @Test
    public void EntityNotDeclaredWithPrologNoDoctype() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        Diagnostic d = XMLAssert.d(2, 1, 2, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 38, 0, 38, "\r\n<!DOCTYPE article [\r\n\t<!ENTITY nbsp \"entity-value\">\r\n]>")));
    }

    @Test
    public void EntityNotDeclaredWithPrologWithRootSameLine() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><text1>\n<text2>\n\t&c;\n</text2>\n</text1>";
        Diagnostic d = XMLAssert.d(2, 1, 2, 4, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"c\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 38, 0, 38, "\n<!DOCTYPE text1 [\n\t<!ENTITY c \"entity-value\">\n]>\n")));
    }

    @Test
    public void EntityNotDeclaredDoctypeNoSubset() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article >\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(3, 1, 3, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 18, 1, 18, "[\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void EntityNotDeclaredDoctypeNoSubsetNoSpace() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(3, 1, 3, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 17, 1, 17, " [\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void EntityNotDeclaredDoctypeNoSubsetEndBracketNewLine() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article\n>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(4, 1, 4, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 0, 2, 0, "[\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void Issue862() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article\n>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(4, 1, 4, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article\n>\n<article>\n\t&|nbsp;\n</article>";
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 0, 2, 0, "[\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void EntityNotDeclaredDoctypeEmptySubset() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article []>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(3, 1, 3, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 19, 1, 19, "\n\t<!ENTITY nbsp \"entity-value\">\n")));
    }

    @Test
    public void EntityNotDeclaredDoctypeEmptySubsetWithNewline() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article [\n]>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(4, 1, 4, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 0, 2, 0, "\t<!ENTITY nbsp \"entity-value\">\n")));
    }

    @Test
    public void EntityNotDeclaredSingleQuotes() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setInsertSpaces(false);
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, settings, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n\t<!ENTITY nbsp 'entity-value'>")));
    }

    @Test
    public void NotationDeclUnterminated() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\"  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 44, 45, (IXMLErrorCode)DTDErrorCode.NotationDeclUnterminated));
    }

    @Test
    public void EntityNotDeclared() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(5, 1, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared));
    }

    @Test
    public void EntityNotDeclaredRespectsIndentSettings1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(6);
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, settings, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n      <!ENTITY nbsp 'entity-value'>")));
    }

    @Test
    public void EntityNotDeclaredRespectsIndentSettings2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(3);
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, settings, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n   <!ENTITY nbsp 'entity-value'>")));
    }

    @Test
    public void ElementDeclUnterminated() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ELEMENT element-name (element-content) \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 41, 42, (IXMLErrorCode)DTDErrorCode.ElementDeclUnterminated));
    }

    @Test
    public void PEReferenceWithinMarkup() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ENTITY % Folks \"(%bar;)*\"> \r\n]>\r\n<Folks></Folks>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 18, 28, (IXMLErrorCode)DTDErrorCode.PEReferenceWithinMarkup));
    }

    @Test
    public void MSG_ELEMENT_ALREADY_DECLARED() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Email [\r\n\t<!ELEMENT Email (#PCDATA)> \r\n\t<!ELEMENT Email (#PCDATA)> \r\n]>\r\n<Email></Email>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 3, 10, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_ALREADY_DECLARED));
    }

    @Test
    public void testDoctypeDiagnosticsRefresh() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE student [\n  <!ELEMENT student (surname,id)>\n  <!ELEMENT surname (#PCDATA)>\n]>\n<student>\n  <surname>Smith</surname>\n  <id>567896</id>\n</student>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(7, 3, 5, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED));
        xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE student [\n  <!ELEMENT student (surname,id)>\n  <!ELEMENT surname (#PCDATA)>\n  <!ELEMENT id (#PCDATA)>\n]>\n<student>\n  <surname>Smith</surname>\n  <id>567896</id>\n</student>";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void testDTDNotFoundWithSYSTEM() throws Exception {
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\r\n<!DOCTYPE inEQUAL_PMT SYSTEM \"inEQUAL_PMT.dtd\">\r\n<inEQUAL_PMT>\r\n  \r\n    <!-- The Proceeds and Term -->\r\n   <Proceeds>10000.00</Proceed>\r\n   <Term>36</Term>\r\n   \r\n</inEQUAL_PMT>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 29, 1, 46, (IXMLErrorCode)DTDErrorCode.dtd_not_found), XMLAssert.d(2, 1, 12, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(5, 4, 12, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(5, 4, 12, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired));
    }

    @Test
    public void testDTDNotFoundWithPUBLIC() throws Exception {
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\r\n<!DOCTYPE inEQUAL_PMT PUBLIC 'X' \"inEQUAL_PMT.dtd\">\r\n<inEQUAL_PMT>\r\n  \r\n    <!-- The Proceeds and Term -->\r\n   <Proceeds>10000.00</Proceed>\r\n   <Term>36</Term>\r\n   \r\n</inEQUAL_PMT>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 33, 1, 50, (IXMLErrorCode)DTDErrorCode.dtd_not_found), XMLAssert.d(2, 1, 12, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(5, 4, 12, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(5, 4, 12, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired));
    }

    @Test
    public void MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ELEMENTDECL() throws Exception {
        String xml = "<!DOCTYPE asdf [\n  <!ELEMENTasdf (#PCDATA)>\n]>";
        DTDDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(1, 4, 11, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ELEMENTDECL));
        xml = "<!ELEMENTasdf (#PCDATA)>";
        DTDDiagnosticsTest.testDiagnosticsFor(xml, "test.dtd", XMLAssert.d(0, 2, 9, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ELEMENTDECL));
        xml = "<!ELEMENTasdf";
        DTDDiagnosticsTest.testDiagnosticsFor(xml, "test.dtd", XMLAssert.d(0, 2, 9, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ELEMENTDECL));
        xml = "<!DOCTYPE asdf [\n  <!ELEMENTasdf\n]>";
        Diagnostic diagnostic = XMLAssert.d(1, 4, 11, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ELEMENTDECL);
        DTDDiagnosticsTest.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(1, 11, 1, 11, " ")));
    }

    @Test
    public void MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ATTLISTDECL() throws Exception {
        String xml = "<!DOCTYPE asdf [\n  <!ATTLISTasdf\n]>";
        Diagnostic diagnostic = XMLAssert.d(1, 4, 11, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_BEFORE_ELEMENT_TYPE_IN_ATTLISTDECL);
        DTDDiagnosticsTest.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(1, 11, 1, 11, " ")));
    }

    @Test
    public void MSG_SPACE_REQUIRED_BEFORE_ENTITY_NAME_IN_ENTITYDECL() throws Exception {
        String xml = "<!DOCTYPE asdf [\n  <!ENTITYasdf\n]>";
        Diagnostic diagnostic = XMLAssert.d(1, 4, 10, (IXMLErrorCode)DTDErrorCode.MSG_SPACE_REQUIRED_BEFORE_ENTITY_NAME_IN_ENTITYDECL);
        DTDDiagnosticsTest.testDiagnosticsFor(xml, diagnostic);
        XMLAssert.testCodeActionsFor(xml, diagnostic, XMLAssert.ca(diagnostic, XMLAssert.te(1, 10, 1, 10, " ")));
    }

    @Test
    public void diagnosticRelatedInformationWithDOCTYPE() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setCapabilities(new PublishDiagnosticsCapabilities(Boolean.valueOf(true)));
        settings.setValidation(validationSettings);
        String xml = "<!DOCTYPE foo SYSTEM \"dtd/foo-invalid.dtd\">\r\n<foo>\r\n   <bar></bar\r\n</foo>";
        Diagnostic diagnostic = new Diagnostic(XMLAssert.r(0, 21, 0, 42), "There is '1' error in 'foo-invalid.dtd'.", DiagnosticSeverity.Error, "xml");
        diagnostic.setRelatedInformation(new ArrayList());
        String dtdFileURI = DTDDiagnosticsTest.getGrammarFileURI("foo-invalid.dtd");
        diagnostic.getRelatedInformation().add(new DiagnosticRelatedInformation(XMLAssert.l(dtdFileURI, XMLAssert.r(0, 14, 0, 18)), ""));
        Diagnostic diagnosticBasedOnDTD = new Diagnostic(XMLAssert.r(2, 10, 2, 13), "The end-tag for element type \"bar\" must end with a '>' delimiter.", DiagnosticSeverity.Error, "xml", XMLSyntaxErrorCode.ETagUnterminated.getCode());
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnDTD);
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnDTD);
    }

    @Test
    public void diagnosticRelatedInformationWithXMLModel() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setCapabilities(new PublishDiagnosticsCapabilities(Boolean.valueOf(true)));
        settings.setValidation(validationSettings);
        String xml = "<?xml-model href=\"dtd/foo-invalid.dtd\" type=\"application/xml-dtd\"?>\r\n<foo>\r\n   <bar></bar\r\n</foo>";
        Diagnostic diagnostic = new Diagnostic(XMLAssert.r(0, 17, 0, 38), "There is '1' error in 'foo-invalid.dtd'.", DiagnosticSeverity.Error, "xml");
        diagnostic.setRelatedInformation(new ArrayList());
        String dtdFileURI = DTDDiagnosticsTest.getGrammarFileURI("foo-invalid.dtd");
        diagnostic.getRelatedInformation().add(new DiagnosticRelatedInformation(XMLAssert.l(dtdFileURI, XMLAssert.r(0, 14, 0, 18)), ""));
        Diagnostic diagnosticBasedOnDTD = new Diagnostic(XMLAssert.r(2, 10, 2, 13), "The end-tag for element type \"bar\" must end with a '>' delimiter.", DiagnosticSeverity.Error, "xml", XMLSyntaxErrorCode.ETagUnterminated.getCode());
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnDTD);
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, null, null, "src/test/resources/test.xml", false, settings, diagnostic, diagnosticBasedOnDTD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultEntityExpansionLimit() {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setResolveExternalEntities(true);
        settings.setValidation(validationSettings);
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ENGLISH);
            String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE lolz [\r\n    <!ENTITY lol \"lol\">\r\n    <!ELEMENT lolz (#PCDATA)>\r\n    <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\r\n    <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\r\n    <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\r\n    <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\r\n    <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\r\n    <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\r\n    <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\r\n    <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\r\n    <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\r\n]>\r\n<lolz>&lol9;</lolz>";
            Diagnostic diagnostic = XMLAssert.d(14, 6, 14, 12, (IXMLErrorCode)DTDErrorCode.EntityExpansionLimitExceeded, "The parser has encountered more than \"64,000\" entity expansions in this document; this is the limit imposed by the application.", "xml", DiagnosticSeverity.Error);
            XMLAssert.testDiagnosticsFor(new XMLLanguageService(), xml, null, null, null, false, settings, diagnostic);
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customEntityExpansionLimit() {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationSettings validationSettings = new XMLValidationSettings();
        validationSettings.setResolveExternalEntities(true);
        settings.setValidation(validationSettings);
        try {
            System.setProperty("jdk.xml.entityExpansionLimit", "10");
            String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE lolz [\r\n    <!ENTITY lol \"lol\">\r\n    <!ELEMENT lolz (#PCDATA)>\r\n    <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\r\n    <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\r\n    <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\r\n    <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\r\n    <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\r\n    <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\r\n    <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\r\n    <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\r\n    <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\r\n]>\r\n<lolz>&lol9;</lolz>";
            Diagnostic diagnostic = XMLAssert.d(14, 6, 14, 12, (IXMLErrorCode)DTDErrorCode.EntityExpansionLimitExceeded, "The parser has encountered more than \"10\" entity expansions in this document; this is the limit imposed by the application.", "xml", DiagnosticSeverity.Error);
            XMLAssert.testDiagnosticsFor(new XMLLanguageService(), xml, null, null, null, false, settings, diagnostic);
        }
        finally {
            System.setProperty("jdk.xml.entityExpansionLimit", "");
        }
    }

    private static void testDiagnosticsFor(String xml, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/catalog.xml", expected);
    }

    private static void testPublicDiagnosticsFor(String xml, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/catalog-public.xml", expected);
    }

    private static void testDiagnosticsFor(String xml, String fileURI, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/catalogs/catalog.xml", null, fileURI, expected);
    }

    private static String getGrammarFileURI(String grammarURI) throws URI.MalformedURIException {
        int index = grammarURI.lastIndexOf(46);
        String path = grammarURI.substring(index + 1, grammarURI.length());
        return XMLEntityManager.expandSystemId((String)grammarURI, (String)("src/test/resources/" + path + "/test.xml"), (boolean)true);
    }
}

