/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.platform.Platform;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FilesUtilsTest {
    @Test
    public void testFilesCachePathPreference() throws Exception {
        System.clearProperty("lemminx.workdir");
        String newBasePathString = System.getProperty("user.home");
        String newSubPathString = Paths.get("New", "Sub", "Path").toString();
        Path newSubPath = Paths.get(newSubPathString, new String[0]);
        FilesUtils.setCachePathSetting((String)newBasePathString);
        Path finalPath = FilesUtils.getDeployedPath((Path)newSubPath);
        Assertions.assertEquals((Object)Paths.get(newBasePathString, newSubPathString).toString(), (Object)finalPath.toString());
    }

    @Test
    public void normalizePathTest() {
        Assertions.assertEquals((Object)Paths.get(System.getProperty("user.home"), "Test", "Folder").toString(), (Object)FilesUtils.normalizePath((String)"~/Test/Folder"));
        Assertions.assertEquals((Object)Paths.get(File.separator + "Test", "~", "Folder").toString(), (Object)FilesUtils.normalizePath((String)"/Test/~/Folder"));
        Assertions.assertEquals((Object)Paths.get("~", "Test", "Folder").toString(), (Object)FilesUtils.normalizePath((String)"./~/Test/Folder"));
        Assertions.assertEquals((Object)Paths.get(File.separator + "Folder", new String[0]).toString(), (Object)FilesUtils.normalizePath((String)"/Test/../Folder"));
        Assertions.assertEquals((Object)Paths.get(File.separator + "Users", "Nikolas").toString(), (Object)FilesUtils.normalizePath((String)"\\Users\\Nikolas\\"));
    }

    @Test
    public void getFilePathSlashTest() {
        Assertions.assertEquals((Object)"/", (Object)FilesUtils.getFilePathSlash((String)"src/a/b/c"));
        Assertions.assertEquals((Object)"\\", (Object)FilesUtils.getFilePathSlash((String)"src\\a\\b\\c"));
        Assertions.assertEquals((Object)"/", (Object)FilesUtils.getFilePathSlash((String)"src"));
        Assertions.assertEquals((Object)"/", (Object)FilesUtils.getFilePathSlash((String)""));
    }

    @Test
    public void cleanPathForWindows() {
        Assertions.assertEquals((Object)"C:\\Users\\Home\\Documents", (Object)FilesUtils.convertToWindowsPath((String)"\\C:\\Users\\Home\\Documents"));
        Assertions.assertEquals((Object)"C:\\Users\\Home\\Documents\\", (Object)FilesUtils.convertToWindowsPath((String)"\\C:\\Users\\Home\\Documents\\"));
        Assertions.assertEquals((Object)"C:\\Users\\Home\\Documents\\", (Object)FilesUtils.convertToWindowsPath((String)"/C:/Users/Home/Documents/"));
        Assertions.assertEquals((Object)"C:\\Users\\Home\\Documents\\", (Object)FilesUtils.convertToWindowsPath((String)"C:/Users/Home/Documents/"));
    }

    @Test
    public void saveFileAndRemoveExecutableFlag(@TempDir Path temporaryDirectory) throws IOException {
        Path tempFilePath = temporaryDirectory.resolve("file.xml");
        FilesUtils.saveToFile((String)"<content />", (Path)tempFilePath);
        File tempFile = tempFilePath.toFile();
        Assertions.assertTrue((boolean)tempFile.exists());
        Assertions.assertTrue((boolean)tempFile.isFile());
        Assertions.assertTrue((!tempFile.canExecute() || Platform.isWindows ? 1 : 0) != 0);
    }
}

