/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.contentmodel.model.GrammarCacheInfo;
import org.eclipse.lemminx.extensions.contentmodel.model.ReferencedGrammarInfo;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.XMLCacheResolverExtension;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.XMLCatalogResolverExtension;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.XMLFileAssociationResolverExtension;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.ResolvedURIInfo;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.URIUtils;

public class ContentModelManager {
    private final Map<String, CMDocument> cmDocumentCache;
    private final URIResolverExtensionManager resolverManager;
    private final List<ContentModelProvider> modelProviders;
    private final XMLCacheResolverExtension cacheResolverExtension;
    private final XMLCatalogResolverExtension catalogResolverExtension;
    private final XMLFileAssociationResolverExtension fileAssociationResolver;
    private final XMLGrammarPool grammarPool;

    public ContentModelManager(URIResolverExtensionManager resolverManager) {
        this.resolverManager = resolverManager;
        this.modelProviders = new ArrayList<ContentModelProvider>();
        this.cmDocumentCache = Collections.synchronizedMap(new HashMap());
        this.fileAssociationResolver = new XMLFileAssociationResolverExtension();
        resolverManager.registerResolver(this.fileAssociationResolver);
        this.catalogResolverExtension = new XMLCatalogResolverExtension();
        resolverManager.registerResolver(this.catalogResolverExtension);
        this.cacheResolverExtension = new XMLCacheResolverExtension();
        resolverManager.registerResolver(this.cacheResolverExtension);
        this.grammarPool = new LSPXMLGrammarPool();
        this.setUseCache(true);
    }

    public Collection<CMDocument> findCMDocument(DOMElement element) {
        return this.findCMDocument(element.getOwnerDocument(), element.getNamespaceURI());
    }

    public Collection<CMDocument> findCMDocument(DOMElement element, String namespaceURI) {
        return this.findCMDocument(element.getOwnerDocument(), namespaceURI);
    }

    public Collection<CMDocument> findCMDocument(DOMDocument xmlDocument, String namespaceURI) {
        return this.findCMDocument(xmlDocument, namespaceURI, true);
    }

    public Collection<CMDocument> findCMDocument(DOMDocument xmlDocument, String namespaceURI, boolean withInternal) {
        CMDocument cmDocument;
        if (namespaceURI == null) {
            namespaceURI = xmlDocument.getNamespaceURI();
        }
        ArrayList<CMDocument> documents = new ArrayList<CMDocument>();
        for (ContentModelProvider modelProvider : this.modelProviders) {
            CMDocument internalCMDocument;
            if (withInternal && (internalCMDocument = modelProvider.createInternalCMDocument(xmlDocument)) != null) {
                documents.add(internalCMDocument);
            }
            if (!modelProvider.adaptFor(xmlDocument, false)) continue;
            Collection<ContentModelProvider.Identifier> identifiers = modelProvider.getIdentifiers(xmlDocument, namespaceURI);
            for (ContentModelProvider.Identifier identifier : identifiers) {
                String publicId;
                String systemId = identifier.getSystemId();
                String string = publicId = identifier.getPublicId() != null ? identifier.getPublicId() : namespaceURI;
                CMDocument cmDocument2 = this.findCMDocument(xmlDocument.getDocumentURI(), publicId, systemId, modelProvider);
                if (cmDocument2 == null) continue;
                documents.add(cmDocument2);
            }
        }
        if (documents.isEmpty() && (cmDocument = this.findCMDocument(xmlDocument.getDocumentURI(), namespaceURI, null, null)) != null) {
            documents.add(cmDocument);
        }
        return documents;
    }

    public boolean dependsOnGrammar(DOMDocument document, String grammarURI) {
        if (StringUtils.isEmpty(grammarURI)) {
            return false;
        }
        for (ContentModelProvider modelProvider : this.modelProviders) {
            if (!modelProvider.adaptFor(document, false)) continue;
            Collection<ContentModelProvider.Identifier> identifiers = modelProvider.getIdentifiers(document, document.getNamespaceURI());
            for (ContentModelProvider.Identifier identifier : identifiers) {
                String publicId = identifier.getPublicId();
                String systemId = identifier.getSystemId();
                String key = this.resolverManager.resolve(document.getDocumentURI(), publicId, systemId);
                if (!grammarURI.equals(key)) continue;
                return true;
            }
        }
        String key = this.resolverManager.resolve(document.getDocumentURI(), null, null);
        return grammarURI.equals(key);
    }

    public Set<ReferencedGrammarInfo> getReferencedGrammarInfos(DOMDocument document) {
        LinkedHashSet<ReferencedGrammarInfo> referencedGrammarInfos = new LinkedHashSet<ReferencedGrammarInfo>();
        for (ContentModelProvider modelProvider : this.modelProviders) {
            if (!modelProvider.adaptFor(document, false)) continue;
            Collection<ContentModelProvider.Identifier> identifiers = modelProvider.getIdentifiers(document, null);
            for (ContentModelProvider.Identifier identifier : identifiers) {
                String publicId = identifier.getPublicId();
                String systemId = identifier.getSystemId();
                this.fillReferencedGrammarInfo(document, publicId, systemId, identifier, referencedGrammarInfos);
            }
        }
        this.fillReferencedGrammarInfo(document, document.getNamespaceURI(), null, null, referencedGrammarInfos);
        return referencedGrammarInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillReferencedGrammarInfo(DOMDocument document, String publicId, String systemId, ContentModelProvider.Identifier identifier, Set<ReferencedGrammarInfo> referencedGrammarInfos) {
        ResolvedURIInfo resolvedURIInfo = this.resolverManager.resolveInfo(document.getDocumentURI(), publicId, systemId);
        if (resolvedURIInfo != null) {
            GrammarCacheInfo grammarCacheInfo = null;
            String cachedResolvedUri = null;
            boolean downloading = false;
            Exception cacheError = null;
            String resolvedUri = resolvedURIInfo.getResolvedURI();
            if (this.cacheResolverExtension.canUseCache(resolvedUri)) {
                try {
                    Path file = this.cacheResolverExtension.getCachedResource(resolvedUri);
                    if (file != null) {
                        cachedResolvedUri = file.toUri().toString();
                    }
                }
                catch (CacheResourceDownloadingException e) {
                    downloading = true;
                }
                catch (Exception e) {
                    cacheError = e;
                }
                finally {
                    if (cachedResolvedUri == null) {
                        try {
                            cachedResolvedUri = CacheResourcesManager.getResourceCachePath(resolvedUri).toUri().toString();
                        }
                        catch (IOException e) {}
                    }
                }
                grammarCacheInfo = new GrammarCacheInfo(cachedResolvedUri, downloading, cacheError);
            }
            if (identifier == null) {
                identifier = new ContentModelProvider.Identifier(publicId, systemId, null, null);
            }
            referencedGrammarInfos.add(new ReferencedGrammarInfo(resolvedURIInfo, grammarCacheInfo, identifier));
        }
    }

    /*
     * Unable to fully structure code
     */
    private CMDocument findCMDocument(String uri, String publicId, String systemId, ContentModelProvider modelProvider) {
        resolvedUri = this.resolverManager.resolve(uri, publicId, systemId);
        if (resolvedUri == null) {
            return null;
        }
        if (modelProvider == null) {
            modelProvider = this.getModelProviderByURI(resolvedUri);
        }
        if (modelProvider == null) {
            return null;
        }
        cmDocument = this.getCMDocumentFromCache(resolvedUri);
        if (cmDocument != null) {
            return cmDocument;
        }
        if (this.cacheResolverExtension.canUseCache(resolvedUri)) {
            try {
                file = this.cacheResolverExtension.getCachedResource(resolvedUri);
                if (file == null) ** GOTO lbl23
                cmDocument = modelProvider.createCMDocument(file.toUri().toString());
            }
            catch (CacheResourceDownloadingException e) {
                return null;
            }
            catch (Exception e) {
                cmDocument = modelProvider.createCMDocument(resolvedUri);
            }
        } else {
            cmDocument = modelProvider.createCMDocument(resolvedUri);
        }
lbl23:
        // 4 sources

        if (cmDocument != null) {
            this.cache(resolvedUri, cmDocument);
        }
        return cmDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMDocument getCMDocumentFromCache(String key) {
        CMDocument document = null;
        Map<String, CMDocument> map = this.cmDocumentCache;
        synchronized (map) {
            document = this.cmDocumentCache.get(key);
            if (document != null && document.isDirty()) {
                this.cmDocumentCache.remove(key);
                return null;
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(String key, CMDocument cmDocument) {
        Map<String, CMDocument> map = this.cmDocumentCache;
        synchronized (map) {
            this.cmDocumentCache.put(key, cmDocument);
        }
    }

    public ContentModelProvider getModelProviderByURI(String uri) {
        for (ContentModelProvider modelProvider : this.modelProviders) {
            if (!modelProvider.adaptFor(uri)) continue;
            return modelProvider;
        }
        return null;
    }

    public boolean setCatalogs(String[] catalogs) {
        return this.catalogResolverExtension.setCatalogs(catalogs);
    }

    public void refreshCatalogs() {
        this.catalogResolverExtension.refreshCatalogs();
    }

    public boolean setFileAssociations(XMLFileAssociation[] fileAssociations) {
        return this.fileAssociationResolver.setFileAssociations(fileAssociations);
    }

    public void setRootURI(String rootUri) {
        rootUri = URIUtils.sanitizingUri(rootUri);
        this.fileAssociationResolver.setRootUri(rootUri);
        this.catalogResolverExtension.setRootUri(rootUri);
    }

    public void setUseCache(boolean useCache) {
        this.cacheResolverExtension.setUseCache(useCache);
        if (!useCache) {
            this.grammarPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictCacheFor(DOMDocument document) throws IOException {
        Set<ReferencedGrammarInfo> referencedGrammarInfos = this.getReferencedGrammarInfos(document);
        if (referencedGrammarInfos.isEmpty()) {
            return;
        }
        int nbDeletedFiles = 0;
        try {
            for (ReferencedGrammarInfo referencedGrammarInfo : referencedGrammarInfos) {
                if (!referencedGrammarInfo.isInCache()) continue;
                String resolvedURI = referencedGrammarInfo.getGrammarCacheInfo().getCachedResolvedUri();
                Files.deleteIfExists(FilesUtils.getPath(resolvedURI));
                this.cmDocumentCache.remove(resolvedURI);
                ++nbDeletedFiles;
            }
        }
        finally {
            if (nbDeletedFiles > 0) {
                this.grammarPool.clear();
            }
        }
    }

    public void evictCache() throws IOException {
        try {
            this.cacheResolverExtension.evictCache();
        }
        finally {
            this.grammarPool.clear();
            this.cmDocumentCache.clear();
        }
    }

    public void registerModelProvider(ContentModelProvider modelProvider) {
        this.modelProviders.add(modelProvider);
    }

    public void unregisterModelProvider(ContentModelProvider modelProvider) {
        this.modelProviders.remove(modelProvider);
    }

    public XMLGrammarPool getGrammarPool() {
        return this.cacheResolverExtension.isUseCache() ? this.grammarPool : null;
    }
}

