/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocationHint;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;

public class ContentModelDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private final URIResolverExtensionManager resolverManager;

    public ContentModelDocumentLinkParticipant(URIResolverExtensionManager resolverManager) {
        this.resolverManager = resolverManager;
    }

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        String location;
        String location2;
        DOMDocumentType docType;
        NoNamespaceSchemaLocation noNamespaceSchemaLocation = document.getNoNamespaceSchemaLocation();
        if (noNamespaceSchemaLocation != null) {
            try {
                DOMNode attrValue;
                String location3 = this.resolverManager.resolve(document.getDocumentURI(), null, noNamespaceSchemaLocation.getLocation());
                if (location3 != null && (attrValue = noNamespaceSchemaLocation.getAttr().getNodeAttrValue()) != null) {
                    links.add(XMLPositionUtility.createDocumentLink(attrValue, location3, true));
                }
            }
            catch (BadLocationException location3) {
                // empty catch block
            }
        }
        if ((docType = document.getDoctype()) != null && (location2 = this.resolverManager.resolve(document.getDocumentURI(), docType.getPublicIdWithoutQuotes(), docType.getSystemIdWithoutQuotes())) != null) {
            try {
                DTDDeclParameter systemIdRange = docType.getSystemIdNode();
                if (systemIdRange != null) {
                    links.add(XMLPositionUtility.createDocumentLink(systemIdRange, location2, true));
                }
            }
            catch (BadLocationException systemIdRange) {
                // empty catch block
            }
        }
        List<XMLModel> xmlModels = document.getXMLModels();
        for (XMLModel xmlModel : xmlModels) {
            location = this.resolverManager.resolve(document.getDocumentURI(), null, xmlModel.getHref());
            if (location == null) continue;
            try {
                DOMRange hrefRange = xmlModel.getHrefNode();
                if (hrefRange == null) continue;
                links.add(XMLPositionUtility.createDocumentLink(hrefRange, location, true));
            }
            catch (BadLocationException badLocationException) {}
        }
        SchemaLocation schemaLocation = document.getSchemaLocation();
        if (schemaLocation != null) {
            try {
                Collection<SchemaLocationHint> schemaLocationHints = schemaLocation.getSchemaLocationHints();
                for (SchemaLocationHint schemaLocationHint : schemaLocationHints) {
                    location = this.resolverManager.resolve(document.getDocumentURI(), null, schemaLocationHint.getHint());
                    if (location == null) continue;
                    links.add(XMLPositionUtility.createDocumentLink(schemaLocationHint, location, false));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

