/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lsp4j.FormattingOptions;

public class XMLFormattingOptions
extends FormattingOptions {
    public static final String DEFAULT_QUOTATION = "\"";
    public static final int DEFAULT_PRESERVER_NEW_LINES = 2;
    public static final int DEFAULT_TAB_SIZE = 2;
    public static final EnforceQuoteStyle DEFAULT_ENFORCE_QUOTE_STYLE = EnforceQuoteStyle.ignore;
    public static final boolean DEFAULT_PRESERVE_ATTR_LINE_BREAKS = false;
    public static final boolean DEFAULT_TRIM_TRAILING_SPACES = false;
    public static final int DEFAULT_SPLIT_ATTRIBUTES_INDENT_SIZE = 2;
    public static final boolean DEFAULT_CLOSING_BRACKET_NEW_LINE = false;
    private static final String SPLIT_ATTRIBUTES = "splitAttributes";
    private static final String JOIN_CDATA_LINES = "joinCDATALines";
    private static final String FORMAT_COMMENTS = "formatComments";
    private static final String JOIN_COMMENT_LINES = "joinCommentLines";
    private static final String ENABLED = "enabled";
    private static final String SPACE_BEFORE_EMPTY_CLOSE_TAG = "spaceBeforeEmptyCloseTag";
    private static final String JOIN_CONTENT_LINES = "joinContentLines";
    private static final String PRESERVED_NEWLINES = "preservedNewlines";
    private static final String TRIM_FINAL_NEWLINES = "trimFinalNewlines";
    private static final String TRIM_TRAILING_WHITESPACE = "trimTrailingWhitespace";
    private static final String ENFORCE_QUOTE_STYLE = "enforceQuoteStyle";
    private static final String PRESERVE_ATTR_LINE_BREAKS = "preserveAttributeLineBreaks";
    private static final String PRESERVE_EMPTY_CONTENT = "preserveEmptyContent";
    private static final String SPLIT_ATTRIBUTES_INDENT_SIZE = "splitAttributesIndentSize";
    private static final String CLOSING_BRACKET_NEW_LINE = "closingBracketNewLine";
    private static final String EMPTY_ELEMENTS = "emptyElements";

    public XMLFormattingOptions() {
        this(false);
    }

    public XMLFormattingOptions(boolean initializeDefaults) {
        if (initializeDefaults) {
            this.initializeDefaultSettings();
        }
    }

    private void initializeDefaultSettings() {
        super.setTabSize(2);
        super.setInsertSpaces(true);
        this.setSplitAttributes(false);
        this.setJoinCDATALines(false);
        this.setFormatComments(true);
        this.setJoinCommentLines(false);
        this.setJoinContentLines(false);
        this.setEnabled(true);
        this.setSpaceBeforeEmptyCloseTag(true);
        this.setPreserveEmptyContent(false);
        this.setPreservedNewlines(2);
        this.setEmptyElement(EmptyElements.ignore);
        this.setSplitAttributesIndentSize(2);
        this.setClosingBracketNewLine(false);
    }

    public XMLFormattingOptions(int tabSize, boolean insertSpaces, boolean initializeDefaultSettings) {
        if (initializeDefaultSettings) {
            this.initializeDefaultSettings();
        }
        super.setTabSize(tabSize);
        super.setInsertSpaces(insertSpaces);
    }

    public XMLFormattingOptions(int tabSize, boolean insertSpaces) {
        this(tabSize, insertSpaces, true);
    }

    public XMLFormattingOptions(FormattingOptions options, boolean initializeDefaultSettings) {
        if (initializeDefaultSettings) {
            this.initializeDefaultSettings();
        }
        this.merge(options);
    }

    public XMLFormattingOptions(FormattingOptions options) {
        this(options, true);
    }

    public boolean isSplitAttributes() {
        Boolean value = this.getBoolean(SPLIT_ATTRIBUTES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setSplitAttributes(boolean splitAttributes) {
        this.putBoolean(SPLIT_ATTRIBUTES, splitAttributes);
    }

    public boolean isJoinCDATALines() {
        Boolean value = this.getBoolean(JOIN_CDATA_LINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setJoinCDATALines(boolean joinCDATALines) {
        this.putBoolean(JOIN_CDATA_LINES, joinCDATALines);
    }

    public boolean isFormatComments() {
        Boolean value = this.getBoolean(FORMAT_COMMENTS);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setFormatComments(boolean formatComments) {
        this.putBoolean(FORMAT_COMMENTS, formatComments);
    }

    public boolean isJoinCommentLines() {
        Boolean value = this.getBoolean(JOIN_COMMENT_LINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setJoinCommentLines(boolean joinCommentLines) {
        this.putBoolean(JOIN_COMMENT_LINES, joinCommentLines);
    }

    public boolean isJoinContentLines() {
        Boolean value = this.getBoolean(JOIN_CONTENT_LINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setJoinContentLines(boolean joinContentLines) {
        this.putBoolean(JOIN_CONTENT_LINES, joinContentLines);
    }

    public boolean isEnabled() {
        Boolean value = this.getBoolean(ENABLED);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.putBoolean(ENABLED, enabled);
    }

    public void setSpaceBeforeEmptyCloseTag(boolean spaceBeforeEmptyCloseTag) {
        this.putBoolean(SPACE_BEFORE_EMPTY_CLOSE_TAG, spaceBeforeEmptyCloseTag);
    }

    public boolean isSpaceBeforeEmptyCloseTag() {
        Boolean value = this.getBoolean(SPACE_BEFORE_EMPTY_CLOSE_TAG);
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setPreserveEmptyContent(boolean preserveEmptyContent) {
        this.putBoolean(PRESERVE_EMPTY_CONTENT, preserveEmptyContent);
    }

    public boolean isPreserveEmptyContent() {
        Boolean value = this.getBoolean(PRESERVE_EMPTY_CONTENT);
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setPreservedNewlines(int preservedNewlines) {
        this.putNumber(PRESERVED_NEWLINES, preservedNewlines);
    }

    public int getPreservedNewlines() {
        Number value = this.getNumber(PRESERVED_NEWLINES);
        if (value != null) {
            return value.intValue();
        }
        return 2;
    }

    public void setEmptyElement(EmptyElements emptyElement) {
        this.putString(EMPTY_ELEMENTS, emptyElement.name());
    }

    public EmptyElements getEmptyElements() {
        String value = this.getString(EMPTY_ELEMENTS);
        if (value != null) {
            try {
                return EmptyElements.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return EmptyElements.ignore;
    }

    public boolean isTrimFinalNewlines() {
        Boolean value = this.getBoolean(TRIM_FINAL_NEWLINES);
        return value == null ? true : value;
    }

    public void setTrimTrailingWhitespace(boolean newValue) {
        this.putBoolean(TRIM_TRAILING_WHITESPACE, newValue);
    }

    public boolean isTrimTrailingWhitespace() {
        Boolean value = this.getBoolean(TRIM_TRAILING_WHITESPACE);
        return value == null ? false : value;
    }

    public void setEnforceQuoteStyle(EnforceQuoteStyle enforce) {
        this.putString(ENFORCE_QUOTE_STYLE, enforce.name());
    }

    public EnforceQuoteStyle getEnforceQuoteStyle() {
        String value = this.getString(ENFORCE_QUOTE_STYLE);
        EnforceQuoteStyle enforceStyle = null;
        try {
            enforceStyle = value == null ? null : EnforceQuoteStyle.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_ENFORCE_QUOTE_STYLE;
        }
        return enforceStyle == null ? DEFAULT_ENFORCE_QUOTE_STYLE : enforceStyle;
    }

    public void setPreserveAttrLineBreaks(boolean preserveAttrLineBreaks) {
        this.putBoolean(PRESERVE_ATTR_LINE_BREAKS, preserveAttrLineBreaks);
    }

    public boolean isPreserveAttrLineBreaks() {
        if (this.isSplitAttributes()) {
            return false;
        }
        Boolean value = this.getBoolean(PRESERVE_ATTR_LINE_BREAKS);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setSplitAttributesIndentSize(int splitAttributesIndentSize) {
        this.putNumber(SPLIT_ATTRIBUTES_INDENT_SIZE, splitAttributesIndentSize);
    }

    public int getSplitAttributesIndentSize() {
        int splitAttributesIndentSize = this.getNumber(SPLIT_ATTRIBUTES_INDENT_SIZE).intValue();
        return splitAttributesIndentSize < 0 ? 0 : splitAttributesIndentSize;
    }

    public XMLFormattingOptions merge(FormattingOptions formattingOptions) {
        formattingOptions.entrySet().stream().forEach(entry -> this.put(entry.getKey(), entry.getValue()));
        return this;
    }

    public static XMLFormattingOptions create(FormattingOptions options, FormattingOptions sharedFormattingOptions) {
        return new XMLFormattingOptions(options).merge(sharedFormattingOptions);
    }

    public boolean getClosingBracketNewLine() {
        Boolean value = this.getBoolean(CLOSING_BRACKET_NEW_LINE);
        return value == null ? false : value;
    }

    public void setClosingBracketNewLine(boolean closingBracketNewLine) {
        this.putBoolean(CLOSING_BRACKET_NEW_LINE, closingBracketNewLine);
    }

    public static enum EmptyElements {
        expand,
        collapse,
        ignore;

    }
}

