/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import java.nio.file.Path;
import java.text.MessageFormat;
import org.eclipse.lemminx.uriresolver.CacheResourceException;

public class CacheResourceDownloadedException
extends CacheResourceException {
    private static final long serialVersionUID = 1L;
    private CacheResourceDownloadedError errorCode;

    public CacheResourceDownloadedException(String resourceURI, Path resourceCachePath, Throwable e) {
        this(resourceURI, resourceCachePath, CacheResourceDownloadedError.ERROR_WHILE_DOWNLOADING, e);
    }

    public CacheResourceDownloadedException(String resourceURI, Path resourceCachePath, CacheResourceDownloadedError errorCode, Throwable e) {
        super(resourceURI, errorCode.getMessage(resourceURI, resourceCachePath), e);
        this.errorCode = errorCode;
    }

    public CacheResourceDownloadedError getErrorCode() {
        return this.errorCode;
    }

    public static enum CacheResourceDownloadedError {
        ERROR_WHILE_DOWNLOADING("Error while downloading ''{0}'' to ''{1}''.");

        private final String rawMessage;

        private CacheResourceDownloadedError(String rawMessage) {
            this.rawMessage = rawMessage;
        }

        public String getMessage(Object ... arguments) {
            return MessageFormat.format(this.rawMessage, arguments);
        }
    }
}

