/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterInsertFinalNewLineTest {
    @Test
    public void testTrimFinalNewlinesDefault() throws BadLocationException {
        String content = "<a  ></a>\r\n";
        String expected = "<a></a>";
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, expected, XMLAssert.te(0, 2, 0, 4, ""), XMLAssert.te(0, 9, 1, 0, ""));
        XMLFormatterInsertFinalNewLineTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testDontInsertFinalNewLine1() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "";
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, content, settings, new TextEdit[0]);
    }

    @Test
    public void testDontInsertFinalNewLine2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<a  ></a>\r\n";
        String expected = "<a></a>\r\n";
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, ""));
        XMLFormatterInsertFinalNewLineTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontInsertFinalNewLine3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<a  ></a>\r\n   ";
        String expected = "<a></a>\r\n   ";
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testInsertFinalNewLine1() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<a></a>";
        String expected = "<a></a>" + System.lineSeparator();
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, expected, settings, XMLAssert.te(0, 7, 0, 7, System.lineSeparator()));
    }

    @Test
    public void testInsertFinalNewLine2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(true);
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<a></a>\r\n\r\n";
        String expected = "<a></a>\r\n";
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, expected, settings, XMLAssert.te(1, 0, 2, 0, ""));
    }

    @Test
    public void testInsertFinalNewLine3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(true);
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<a></a>\n\n";
        String expected = "<a></a>\n";
        XMLFormatterInsertFinalNewLineTest.assertFormat(content, expected, settings, XMLAssert.te(1, 0, 2, 0, ""));
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterInsertFinalNewLineTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterInsertFinalNewLineTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterInsertFinalNewLineTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

