/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterWhitespaceSettingTest {
    @Disabled
    @Test
    public void testTrimTrailingWhitespaceText() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \ntext     \n    text text text    \n    text\n</a>   ";
        String expected = "<a>\ntext\n    text text text\n    text\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testTrimTrailingWhitespaceNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n   \n</a>   ";
        String expected = "<a></a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testTrimTrailingWhitespaceTextAndNewlines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimTrailingWhitespace(true);
        String content = "<a>   \n    \ntext     \n    text text text    \n   \n    text\n        \n</a>   ";
        String expected = "<a>\n\ntext\n    text text text\n\n    text\n\n</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontInsertFinalNewLineWithRange() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"|/>\r\n </div>";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n </div>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testInsertFinalNewLineWithRange2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"/>\r\n </div>|";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n</div>\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testInsertFinalNewLineWithRange3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertFinalNewline(true);
        String content = "<div  class = \"foo\">\r\n  |<img  src = \"foo\"/>\r\n\r\n|\r\n<h1></h1>\r\n </div>";
        String expected = "<div  class = \"foo\">\r\n  <img src=\"foo\" />\r\n\r\n<h1></h1>\r\n </div>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontTrimFinalNewLines() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n\r\n\r\n";
        String expected = "<a></a>\r\n\r\n\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 4, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontTrimFinalNewLines2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n   \r\n\r\n";
        String expected = "<a></a>\r\n   \r\n\r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDontTrimFinalNewLines3() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(false);
        String content = "<a  ></a>\r\n  text \r\n  more text   \r\n   \r\n";
        String expected = "<a></a>\r\n  text \r\n  more text   \r\n   \r\n";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testFormatRemoveFinalNewlinesWithoutTrimTrailing() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTrimFinalNewlines(true);
        settings.getFormattingSettings().setTrimTrailingWhitespace(false);
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        String content = "<aaa/>    \r\n\r\n\r\n";
        String expected = "<aaa/>    ";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, XMLAssert.te(0, 10, 3, 0, ""));
        XMLFormatterWhitespaceSettingTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testClosingBracketNewLine() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b='' c=''/>";
        String expected = "<a" + System.lineSeparator() + "b=''" + System.lineSeparator() + "c=''" + System.lineSeparator() + "/>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testClosingBracketNewLineWithDefaultIndentSize() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        String content = "<a b='b' c='c'/>";
        String expected = "<a" + System.lineSeparator() + "    b='b'" + System.lineSeparator() + "    c='c'" + System.lineSeparator() + "    />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testClosingBracketNewLineWithoutSplitAttributes() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(false);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b='' c=''/>";
        String expected = "<a b='' c='' />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testClosingBracketNewLineWithSingleAttribute() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a b=''/>";
        String expected = "<a b='' />";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testClosingBracketNewLineWithPreserveEmptyContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        settings.getFormattingSettings().setClosingBracketNewLine(true);
        String content = "<a>" + System.lineSeparator() + "<b c='' d=''></b>" + System.lineSeparator() + "</a>";
        String expected = "<a>" + System.lineSeparator() + "  <b" + System.lineSeparator() + "  c=''" + System.lineSeparator() + "  d=''" + System.lineSeparator() + "  ></b>" + System.lineSeparator() + "</a>";
        XMLFormatterWhitespaceSettingTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWhitespaceSettingTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWhitespaceSettingTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWhitespaceSettingTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

