/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class DTDDoctypeDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void MSG_ELEMENT_TYPE_REQUIRED_IN_ELEMENTDECL() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE student [\r\n  <!ELEMENT \r\n]>\r\n<student />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 4, 11, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_TYPE_REQUIRED_IN_ELEMENTDECL));
    }

    @Test
    public void ElementDeclUnterminated() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE student [\r\n  <!ELEMENT student (surname,id)>\r\n  <!ELEMENT surname (#PCDATA)\r\n]>\r\n<student />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 29, 30, (IXMLErrorCode)DTDErrorCode.ElementDeclUnterminated));
    }

    @Test
    public void MSG_OPEN_PAREN_OR_ELEMENT_TYPE_REQUIRED_IN_CHILDREN() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE student [\r\n  <!ELEMENT surname\r\n]>\r\n<student />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 19, 20, (IXMLErrorCode)DTDErrorCode.MSG_OPEN_PAREN_OR_ELEMENT_TYPE_REQUIRED_IN_CHILDREN));
    }

    @Test
    public void disableDTDValidationWhenNoElementDecl() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n  <!ENTITY nbsp \"entity-value\">\r\n]>           \r\n<article>\r\n\t&nbsp;\r\n</article>";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n  <!ENTITY nbsp \"entity-value\">\r\n  <!ELEMENT element-name (#PCDATA)>\r\n]>           \r\n<article>\r\n\t&nbsp;\r\n</article>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(5, 1, 8, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n  <!ENTITY nbsp \"entity-value\">\r\n  <!ELEMENT article (#PCDATA)>\r\n]>           \r\n<article>\r\n\t&nbsp;\r\n</article>";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void doctypeNotAllowed() throws Exception {
        String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE student [\r\n  <!ELEMENT \r\n]>\r\n<student />";
        DTDDoctypeDiagnosticsTest.testDiagnosticsDisallowDocTypeDecl(xml, XMLAssert.d(1, 0, 3, 2, (IXMLErrorCode)XMLSyntaxErrorCode.DoctypeNotAllowed));
    }

    private static void testDiagnosticsDisallowDocTypeDecl(String xml, Diagnostic diagnostic) {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        XMLValidationRootSettings validationSettings = new XMLValidationRootSettings();
        validationSettings.setDisallowDocTypeDecl(true);
        settings.setValidation(validationSettings);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, diagnostic);
    }
}

