/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.junit.jupiter.api.Test;

public class DTDCompletionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void completionInRoot() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n  <!DOCTYPE catalog\r\n    PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"\r\n           \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">\r\n\r\n  <catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"\r\n           prefer=\"public\">\r\n\r\n    <|";
        this.testCompletionFor(xml, XMLAssert.c("delegatePublic", XMLAssert.te(8, 4, 8, 5, "<delegatePublic publicIdStartString=\"$1\" catalog=\"$2\" />$0"), "<delegatePublic"), XMLAssert.c("public", XMLAssert.te(8, 4, 8, 5, "<public publicId=\"$1\" uri=\"$2\" />$0"), "<public"));
    }

    @Test
    public void completionWithChoiceAttribute() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n  <!DOCTYPE catalog\r\n    PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"\r\n           \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">\r\n\r\n  <catalog |";
        this.testCompletionFor(xml, XMLAssert.c("prefer", XMLAssert.te(5, 11, 5, 11, "prefer=\"${1|system,public|}\"$0"), "prefer"));
    }

    @Test
    public void testCompletionDocumentationWithSource() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n  <!DOCTYPE catalog\r\n    PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"\r\n           \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">\r\n\r\n  <|";
        this.testCompletionFor(xml, XMLAssert.c("catalog", XMLAssert.te(5, 2, 5, 3, "<catalog>$1</catalog>$0"), "<catalog", " $Id: catalog.dtd,v 1.10 2002/10/18 23:54:58 ndw Exp $ " + System.lineSeparator() + System.lineSeparator() + "Source: catalog.dtd", "plaintext"));
    }

    @Test
    public void externalDTDCompletionElement() throws BadLocationException {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEMENT Person (Name,Email?)>\r\n\t<!ATTLIST Person Pin ID #REQUIRED>\r\n\t<!ATTLIST Person Friend IDREF #IMPLIED>\r\n\t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n\t<!ELEMENT Name (#PCDATA)>\r\n\t<!ELEMENT Email (#PCDATA)>\r\n\t]>\r\n<Folks>\r\n\t|</Folks>";
        XMLAssert.testCompletionFor(xml, XMLAssert.c("Person", XMLAssert.te(11, 1, 11, 1, "<Person Pin=\"\"></Person>"), "Person"));
    }

    @Test
    public void externalDTDCompletionAttribute() throws BadLocationException {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEMENT Person (Name,Email?)>\r\n\t<!ATTLIST Person Pin ID #REQUIRED>\r\n\t<!ATTLIST Person Friend IDREF #IMPLIED>\r\n\t<!ATTLIST Person Likes IDREFS #IMPLIED>\r\n\t<!ELEMENT Name (#PCDATA)>\r\n\t<!ELEMENT Email (#PCDATA)>\r\n\t]>\r\n<Folks>\r\n\t<Person |</Folks>";
        XMLAssert.testCompletionFor(xml, XMLAssert.c("Pin", XMLAssert.te(11, 9, 11, 9, "Pin=\"\""), "Pin"), XMLAssert.c("Friend", XMLAssert.te(11, 9, 11, 9, "Friend=\"\""), "Friend"), XMLAssert.c("Likes", XMLAssert.te(11, 9, 11, 9, "Likes=\"\""), "Likes"));
    }

    @Test
    public void externalDTDCompletionElementDecl() throws BadLocationException {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEMENT|\r\n]>\r\n<Folks>\r\n\t</Folks>";
        this.testCompletionFor(xml, XMLAssert.c("Insert DTD Element Declaration", XMLAssert.te(3, 1, 3, 10, "<!ELEMENT ${1:element-name} (${2:#PCDATA})>"), "<!ELEMENT"));
    }

    @Test
    public void externalDTDCompletionElementDecl2() throws BadLocationException {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t<!ELEM|\r\n]>\r\n<Folks>\r\n\t</Folks>";
        this.testCompletionFor(xml, XMLAssert.c("Insert DTD Element Declaration", XMLAssert.te(3, 1, 3, 7, "<!ELEMENT ${1:element-name} (${2:#PCDATA})>"), "<!ELEMENT"));
    }

    @Test
    public void externalDTDCompletionAllDecls() throws BadLocationException {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t|\r\n]>\r\n<Folks>\r\n\t</Folks>";
        this.testCompletionFor(xml, true, (Integer)5, XMLAssert.c("Insert DTD Element Declaration", XMLAssert.te(3, 1, 3, 1, "<!ELEMENT ${1:element-name} (${2:#PCDATA})>"), "<!ELEMENT"), XMLAssert.c("Insert Internal DTD Entity Declaration", XMLAssert.te(3, 1, 3, 1, "<!ENTITY ${1:entity-name} \"${2:entity-value}\">"), "<!ENTITY"), XMLAssert.c("Insert DTD Attributes List Declaration", XMLAssert.te(3, 1, 3, 1, "<!ATTLIST ${1:element-name} ${2:attribute-name} ${3:ID} ${4:#REQUIRED}>"), "<!ATTLIST"), XMLAssert.c("Insert External DTD Entity Declaration", XMLAssert.te(3, 1, 3, 1, "<!ENTITY ${1:entity-name} SYSTEM \"${2:entity-value}\">"), "<!ENTITY"));
    }

    @Test
    public void externalDTDCompletionAllDeclsSnippetsNotSupported() throws BadLocationException {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Folks [\r\n\t<!ELEMENT Folks (Person*)>\r\n\t|\r\n]>\r\n<Folks>\r\n\t</Folks>";
        this.testCompletionFor(xml, false, (Integer)5, XMLAssert.c("Insert DTD Element Declaration", XMLAssert.te(3, 1, 3, 1, "<!ELEMENT element-name (#PCDATA)>"), "<!ELEMENT"), XMLAssert.c("Insert Internal DTD Entity Declaration", XMLAssert.te(3, 1, 3, 1, "<!ENTITY entity-name \"entity-value\">"), "<!ENTITY"), XMLAssert.c("Insert DTD Attributes List Declaration", XMLAssert.te(3, 1, 3, 1, "<!ATTLIST element-name attribute-name ID #REQUIRED>"), "<!ATTLIST"), XMLAssert.c("Insert External DTD Entity Declaration", XMLAssert.te(3, 1, 3, 1, "<!ENTITY entity-name SYSTEM \"entity-value\">"), "<!ENTITY"));
    }

    @Test
    public void testNoDuplicateCompletionItems() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg.dtd\">\n<svg xmlns=\"http://www.w3.org/2000/svg\">\n    <animate attributeName=\"foo\">\n        <|\n    </animate>\n</svg>";
        this.testCompletionFor(xml, false, (Integer)5, XMLAssert.c("desc", XMLAssert.te(4, 8, 4, 9, "<desc></desc>"), "<desc"), XMLAssert.c("metadata", XMLAssert.te(4, 8, 4, 9, "<metadata></metadata>"), "<metadata"), XMLAssert.c("title", XMLAssert.te(4, 8, 4, 9, "<title></title>"), "<title"));
    }

    @Test
    public void elementCompletionWithDoctypeSubsetWithNoElements() throws BadLocationException {
        String xml = "<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\" [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\nm|\r\n<web-app>\r\n  <display-name>Servlet 2.3 aWeb Application</display-name>\r\n</web-app>";
        this.testCompletionFor(xml, false, (Integer)82, XMLAssert.c("web-app", XMLAssert.te(3, 0, 3, 1, "<web-app></web-app>"), "web-app"), XMLAssert.c("auth-constraint", XMLAssert.te(3, 0, 3, 1, "<auth-constraint></auth-constraint>"), "auth-constraint"));
    }

    @Test
    public void attributeCompletionWithDoctypeSubsetWithNoElements() throws BadLocationException {
        String xml = "<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\" [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<web-app a|>\r\n  <display-name>Servlet 2.3 aWeb Application</display-name>\r\n</web-app>";
        this.testCompletionFor(xml, false, (Integer)3, XMLAssert.c("id", XMLAssert.te(3, 9, 3, 10, "id=\"\""), "id"), XMLAssert.c("xmlns", XMLAssert.te(3, 9, 3, 10, "xmlns=\"\""), "xmlns"), XMLAssert.c("xmlns:xsi", XMLAssert.te(3, 9, 3, 10, "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""), "xmlns:xsi"));
    }

    @Test
    public void completionWithCatalogAndPublic() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?> \r\n<!DOCTYPE web-app\r\n   PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\r\n   \"ABCD.dtd\">\r\n\r\n<web-app>|</web-app>";
        this.testCompletionFor(xml, true, null, "catalog-public.xml", XMLAssert.c("icon", XMLAssert.te(5, 9, 5, 9, "<icon>$1</icon>$0"), "icon"), XMLAssert.c("display-name", XMLAssert.te(5, 9, 5, 9, "<display-name>$1</display-name>$0"), "display-name"));
    }

    private void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        this.testCompletionFor(xml, true, null, expectedItems);
    }

    private void testCompletionFor(String xml, boolean isSnippetsSupported, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        this.testCompletionFor(xml, isSnippetsSupported, expectedCount, "catalog.xml", expectedItems);
    }

    private void testCompletionFor(String xml, boolean isSnippetsSupported, Integer expectedCount, String catalog, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        CompletionItemCapabilities completionItem = new CompletionItemCapabilities(Boolean.valueOf(isSnippetsSupported));
        completionCapabilities.setCompletionItem(completionItem);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, "src/test/resources/catalogs/" + catalog, null, null, expectedCount, sharedSettings, expectedItems);
    }
}

