/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.hover.HoverParticipantAdapter;
import org.eclipse.lemminx.services.extensions.hover.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.hover.IHoverRequest;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.junit.jupiter.api.Test;

public class AggregetedHoverValuesTest
extends AbstractCacheBasedTest {
    private static final String TEST_FOR_TAG_HOVER = "test for tag hover";
    private static final String TEST_FOR_ATTRIBUTENAME_HOVER = "test for attribute name hover";

    @Test
    public void testTagHover() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = AggregetedHoverValuesTest.getXMLSchemaFileURI("spring-beans-3.0.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bea|n>";
        AggregetedHoverValuesTest.assertHover(xml, TEST_FOR_TAG_HOVER + System.lineSeparator() + System.lineSeparator() + "___" + System.lineSeparator() + System.lineSeparator() + "Defines a single (usually named) bean. A bean definition may contain nested tags for constructor arguments, property values, lookup methods, and replaced methods. Mixing constructor injection and setter injection on the same bean is explicitly supported." + System.lineSeparator() + System.lineSeparator() + "Source: [spring-beans-3.0.xsd](" + schemaURI + ")", XMLAssert.r(2, 2, 2, 6));
    }

    @Test
    public void testAttributeNameHover() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = AggregetedHoverValuesTest.getXMLSchemaFileURI("spring-beans-3.0.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean clas|s=>";
        AggregetedHoverValuesTest.assertHover(xml, TEST_FOR_ATTRIBUTENAME_HOVER + System.lineSeparator() + System.lineSeparator() + "___" + System.lineSeparator() + System.lineSeparator() + "The fully qualified name of the bean's class, except if it serves only as a parent definition for child bean definitions." + System.lineSeparator() + System.lineSeparator() + "Source: [spring-beans-3.0.xsd](" + schemaURI + ")", null);
    }

    private static void assertHover(String value, String expectedHoverLabel, Range expectedHoverOffset) throws BadLocationException {
        XMLAssert.assertHover(new AggregatedHoverLanguageService(), value, "src/test/resources/catalogs/catalog.xml", null, expectedHoverLabel, expectedHoverOffset);
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }

    private static class AggregatedHoverLanguageService
    extends XMLLanguageService {
        public AggregatedHoverLanguageService() {
            super.registerHoverParticipant((IHoverParticipant)new AggregatedHoverParticipant());
        }

        class AggregatedHoverParticipant
        extends HoverParticipantAdapter {
            AggregatedHoverParticipant() {
            }

            public Hover onTag(IHoverRequest request, CancelChecker cancelChecker) throws Exception {
                if ("bean".equals(request.getCurrentTag())) {
                    return this.createHover(AggregetedHoverValuesTest.TEST_FOR_TAG_HOVER);
                }
                return null;
            }

            public Hover onAttributeName(IHoverRequest request, CancelChecker cancelChecker) throws Exception {
                if ("class".equals(request.getCurrentAttributeName())) {
                    return this.createHover(AggregetedHoverValuesTest.TEST_FOR_ATTRIBUTENAME_HOVER);
                }
                return null;
            }

            private Hover createHover(String value) {
                return new Hover(new MarkupContent("plaintext", value));
            }
        }
    }
}

