/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerContainerNotFoundException;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.launch.ContainerCommandProcess;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRun;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunImageCommandHandler
extends AbstractHandler {
    private static final String ERROR_CREATING_CONTAINER = "ContainerCreateError.msg";
    private static final String ERROR_REMOVING_CONTAINER = "ContainerRemoveError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerImage selectedImage = CommandUtils.getSelectedImage(activePart);
        if (selectedImage == null) {
            Activator.log(new DockerException(DVMessages.getString("RunImageUnableToRetrieveError.msg")));
        } else {
            try {
                ImageRun wizard = new ImageRun(selectedImage);
                boolean runImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
                if (runImage) {
                    DockerContainerConfig containerConfig = wizard.getDockerContainerConfig();
                    ArrayList<String> unusedPorts = new ArrayList<String>();
                    IDockerHostConfig hostConfig = wizard.getDockerHostConfig(unusedPorts);
                    RunImageCommandHandler.runImage(selectedImage, (IDockerContainerConfig)containerConfig, null, hostConfig, unusedPorts, wizard.getDockerContainerName(), wizard.removeWhenExits());
                }
            }
            catch (CoreException | DockerException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    public static void runImage(final IDockerImage image, final IDockerContainerConfig containerConfig, final ILaunch launch, final IDockerHostConfig hostConfig, final List<String> unusedPorts, final String containerName, final boolean removeWhenExits) {
        final IDockerConnection connection = image.getConnection();
        if (containerConfig.tty()) {
            Display.getDefault().asyncExec(() -> {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            });
        }
        Job runImageJob = new Job(DVMessages.getString("RunImageCreateContainer.job")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                block11: {
                    Job waitContainerJob;
                    String tmpContainerId;
                    IDockerContainer container;
                    RunConsole console;
                    String containerId;
                    block9: {
                        IStatus iStatus;
                        block10: {
                            monitor.beginTask(DVMessages.getString("RunImageRunningTask.msg"), 2);
                            containerId = null;
                            console = null;
                            SubMonitor createContainerMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                            createContainerMonitor.beginTask(DVMessages.getString("RunImageCreatingContainerTask.msg"), 1);
                            containerId = ((DockerConnection)connection).createContainer(containerConfig, hostConfig, containerName);
                            container = ((DockerConnection)connection).getContainer(containerId);
                            createContainerMonitor.done();
                            if (!monitor.isCanceled()) break block9;
                            iStatus = Status.CANCEL_STATUS;
                            String tmpContainerId2 = containerId;
                            if (!removeWhenExits) break block10;
                            Job waitContainerJob2 = new Job(this, CommandMessages.getString("RunImageCommandHandler.waitContainer.label"), tmpContainerId2){
                                final /* synthetic */ String val$tmpContainerId;
                                final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = this$0;
                                    this.val$tmpContainerId = string;
                                    super(arg0);
                                }

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        if (this.val$tmpContainerId != null) {
                                            ((DockerConnection)this.this$0.connection).waitForContainer(this.val$tmpContainerId);
                                            ((DockerConnection)this.this$0.connection).stopLoggingThread(this.val$tmpContainerId);
                                            while (((DockerConnection)this.this$0.connection).loggingStatus(this.val$tmpContainerId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                                                Thread.sleep(1000L);
                                            }
                                        }
                                    }
                                    catch (DockerContainerNotFoundException e) {
                                        return Status.OK_STATUS;
                                    }
                                    catch (InterruptedException | DockerException e) {
                                        // empty catch block
                                    }
                                    try {
                                        if (this.val$tmpContainerId != null) {
                                            ((DockerConnection)this.this$0.connection).removeContainer(this.val$tmpContainerId);
                                        }
                                    }
                                    catch (InterruptedException | DockerException e) {
                                        String id = this.val$tmpContainerId;
                                        Display.getDefault().syncExec(() -> 1.lambda$run$0(id, (Exception)e));
                                    }
                                    return Status.OK_STATUS;
                                }

                                private static /* synthetic */ void lambda$run$0(String id, Exception e) {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_REMOVING_CONTAINER, id), (String)e.getMessage());
                                }
                            };
                            waitContainerJob2.setSystem(true);
                            waitContainerJob2.schedule();
                        }
                        monitor.done();
                        return iStatus;
                    }
                    try {
                        SubMonitor startContainerMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        startContainerMonitor.beginTask(DVMessages.getString("RunImageStartingContainerTask.msg"), 1);
                        console = CommandUtils.getRunConsole(connection, container);
                        OutputStream outputStream = null;
                        if (console != null) {
                            console.showConsole();
                            outputStream = console.getOutputStream();
                        }
                        ContainerCommandProcess commandProcess = new ContainerCommandProcess(connection, container.image(), containerId, outputStream, null, true);
                        if (launch != null) {
                            new RuntimeProcess(launch, (Process)commandProcess, container.name(), null);
                        }
                        startContainerMonitor.done();
                        LaunchConfigurationUtils.createRunImageLaunchConfiguration(image, containerConfig, hostConfig, unusedPorts, containerName, removeWhenExits);
                        tmpContainerId = containerId;
                        if (!removeWhenExits) break block11;
                    }
                    catch (InterruptedException | DockerException e) {
                        block12: {
                            String tmpContainerId3;
                            try {
                                if (console != null) {
                                    RunConsole.removeConsole(console);
                                }
                                Display.getDefault().syncExec(() -> 1.lambda$run$0(containerConfig, (Exception)e));
                                tmpContainerId3 = containerId;
                                if (!removeWhenExits) break block12;
                            }
                            catch (Throwable throwable) {
                                String tmpContainerId4 = containerId;
                                if (removeWhenExits) {
                                    Job waitContainerJob3 = new /* invalid duplicate definition of identical inner class */;
                                    waitContainerJob3.setSystem(true);
                                    waitContainerJob3.schedule();
                                }
                                monitor.done();
                                throw throwable;
                            }
                            waitContainerJob = new /* invalid duplicate definition of identical inner class */;
                            waitContainerJob.setSystem(true);
                            waitContainerJob.schedule();
                        }
                        monitor.done();
                    }
                    waitContainerJob = new /* invalid duplicate definition of identical inner class */;
                    waitContainerJob.setSystem(true);
                    waitContainerJob.schedule();
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private static /* synthetic */ void lambda$run$0(IDockerContainerConfig containerConfig2, Exception e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(RunImageCommandHandler.ERROR_CREATING_CONTAINER, containerConfig2.image()), (String)e.getMessage());
            }
        };
        runImageJob.schedule();
    }
}

