/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.views.BasePropertySection;
import org.eclipse.linuxtools.internal.docker.ui.views.ConnectionInfoContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConnectionInfoPropertySection
extends BasePropertySection {
    private static final String LoadingConnectionInfo = "PropertiesLoadingConnectionInfo.msg";

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage propertySheetPage) {
        super.createControls(parent, propertySheetPage);
        this.getTreeViewer().setContentProvider((IContentProvider)new ConnectionInfoContentProvider());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof ITreeSelection));
        Object input = ((ITreeSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof IDockerConnection));
        this.updateConnectionInfo((IDockerConnection)input);
    }

    private void updateConnectionInfo(final IDockerConnection connection) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setInput(null);
            this.getTreeViewer().expandAll();
        }
        Job loadConnectionInfoJob = new Job(DVMessages.getString(LoadingConnectionInfo)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(ConnectionInfoPropertySection.LoadingConnectionInfo), 1);
                if (connection.getState() != EnumDockerConnectionState.ESTABLISHED) {
                    return Status.OK_STATUS;
                }
                try {
                    IDockerConnectionInfo info = connection.getInfo();
                    Display.getDefault().asyncExec(() -> {
                        if (info != null && ConnectionInfoPropertySection.this.getTreeViewer() != null) {
                            ConnectionInfoPropertySection.this.getTreeViewer().setInput((Object)info);
                            ConnectionInfoPropertySection.this.getTreeViewer().expandAll();
                        }
                    });
                }
                catch (DockerException e) {
                    Activator.log(e);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        loadConnectionInfoJob.schedule();
    }
}

