/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.jobs.CopyFromDockerJob;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;

public class ContainerCommandProcess
extends Process {
    private String containerId;
    private IDockerConnection connection;
    private String imageName;
    private PipedInputStream stdout;
    private PipedInputStream stderr;
    private OutputStream stdin;
    private PipedInputStream pipedStdinIn;
    private final Set<Closeable> toClose = new HashSet<Closeable>();
    private Map<String, String> remoteVolumes;
    private boolean keepContainer;
    private Thread thread;
    private Closeable token;
    private boolean containerRemoved;
    private int exitValue;
    private boolean done;
    private boolean threadDone;
    private boolean threadStarted;

    public ContainerCommandProcess(IDockerConnection connection, String imageName, String containerId, OutputStream outputStream, Map<String, String> remoteVolumes, boolean keepContainer) {
        this.connection = connection;
        this.imageName = imageName;
        this.containerId = containerId;
        this.remoteVolumes = remoteVolumes;
        this.stdout = new PipedInputStream();
        this.stderr = new PipedInputStream();
        this.keepContainer = keepContainer;
        IDockerContainerInfo info = connection.getContainerInfo(containerId);
        if (info.config().openStdin()) {
            try {
                final PipedOutputStream pipedStdinOut = new PipedOutputStream();
                this.toClose.add(pipedStdinOut);
                this.pipedStdinIn = new PipedInputStream(pipedStdinOut);
                this.toClose.add(this.pipedStdinIn);
                this.stdin = new OutputStream(this){

                    @Override
                    public void write(int b) throws IOException {
                        pipedStdinOut.write(b);
                    }
                };
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            this.stdin = new ByteArrayOutputStream();
        }
        Runnable logContainer = () -> {
            PipedOutputStream pipedOut = null;
            PipedOutputStream pipedErr = null;
            try (PipedOutputStream pipedStdout = new PipedOutputStream(this.stdout);
                 PipedOutputStream pipedStderr = new PipedOutputStream(this.stderr);
                 Closeable inputToken = ((DockerConnection)connection).getOperationToken();
                 Closeable token = ((DockerConnection)connection).getOperationToken();){
                this.token = token;
                pipedOut = pipedStdout;
                pipedErr = pipedStderr;
                connection.startContainer(containerId, outputStream);
                this.threadStarted = true;
                if (info.config().openStdin()) {
                    IDockerContainerState state = connection.getContainerInfo(containerId).state();
                    do {
                        if (state.running().booleanValue() || state.finishDate() != null && !state.finishDate().before(state.startDate())) continue;
                        Thread.sleep(50L);
                    } while (!(state = info.state()).running().booleanValue() && (state.finishDate() == null || state.finishDate().before(state.startDate())));
                    Thread.sleep(50L);
                    state = connection.getContainerInfo(containerId).state();
                    if (state.running().booleanValue()) {
                        ((DockerConnection)connection).attachCommand(inputToken, containerId, (InputStream)this.pipedStdinIn, null, false);
                        ((DockerConnection)connection).attachContainerOutput(token, containerId, (OutputStream)pipedStdout, (OutputStream)pipedStderr);
                    }
                } else {
                    ((DockerConnection)connection).attachLog(token, containerId, (OutputStream)pipedStdout, (OutputStream)pipedStderr);
                }
                pipedStdout.flush();
                pipedStderr.flush();
            }
            catch (IOException | InterruptedException | DockerException e) {
                if (pipedOut != null) {
                    try {
                        pipedOut.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (pipedErr != null) {
                    try {
                        pipedErr.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.threadDone = true;
            }
        };
        this.thread = new Thread(logContainer);
        this.thread.start();
        while (!this.threadStarted && !this.threadDone) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void destroy() {
        try {
            try {
                this.connection.killContainer(this.containerId);
                Thread.sleep(1000L);
            }
            catch (InterruptedException | DockerException throwable) {
                // empty catch block
            }
            int count = 0;
            while (this.thread.isAlive() && count++ < 10) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.stdout.close();
            this.stderr.close();
            this.stdin.close();
            this.token.close();
            for (Closeable close : this.toClose) {
                close.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int exitValue() {
        IDockerContainerState state;
        if (this.containerRemoved) {
            return this.exitValue;
        }
        IDockerContainerInfo info = this.connection.getContainerInfo(this.containerId);
        if (info != null && (state = info.state()) != null) {
            if (state.paused().booleanValue() || state.restarting().booleanValue() || state.running().booleanValue()) {
                throw new IllegalThreadStateException(LaunchMessages.getFormattedString("ContainerNotFinished.msg", this.containerId));
            }
            return state.exitCode();
        }
        if (this.containerRemoved) {
            return this.exitValue;
        }
        return -1;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        if (this.done) {
            return 0;
        }
        try {
            if (!this.threadDone) {
                while (!this.threadStarted) {
                    Thread.sleep(200L);
                }
            }
            IDockerContainerExit exit = this.connection.waitForContainer(this.containerId);
            this.done = true;
            int i = 0;
            while (!this.threadDone && i++ < 10) {
                Thread.sleep(500L);
            }
            if (!this.threadDone) {
                try {
                    this.stdout.close();
                    this.stderr.close();
                    this.stdin.close();
                    this.token.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.containerRemoved) {
                this.connection.stopLoggingThread(this.containerId);
            }
            if (!((DockerConnection)this.connection).isLocal() && this.remoteVolumes != null && !this.remoteVolumes.isEmpty()) {
                Map<Path, Path> volumes = this.remoteVolumes.entrySet().stream().collect(Collectors.toMap(x -> new Path((String)x.getKey()), x -> new Path((String)x.getValue())));
                CopyFromDockerJob job = new CopyFromDockerJob(this.connection, CopyFromDockerJob.CopyType.Container, this.containerId, volumes);
                job.schedule();
                job.join();
                this.remoteVolumes.clear();
            }
            if (!this.containerRemoved && !this.keepContainer) {
                this.exitValue = this.exitValue();
                this.containerRemoved = true;
                this.connection.removeContainer(this.containerId);
            }
            return exit.statusCode();
        }
        catch (DockerException e) {
            return -1;
        }
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    public String getImage() {
        return this.imageName;
    }
}

