/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.extensions.core.MappingsType;
import org.eclipse.swtchart.extensions.widgets.ExtendedComboViewer;

public class CreateSeriesMappingDialog
extends TitleAreaDialog {
    private String description = "";
    private MappingsType mappingsType = MappingsType.NONE;
    private String regularExpression = "";

    public CreateSeriesMappingDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Series Mapping");
        this.setMessage("Create a new series mapping.");
    }

    public String getDescription() {
        return this.description;
    }

    public MappingsType getMappingsType() {
        return this.mappingsType;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createSectionDescription(composite);
        this.createSectionType(composite);
        this.createSectionRegex(composite);
        this.initialize();
        return container;
    }

    private void initialize() {
        this.validate();
    }

    private void createSectionDescription(Composite parent) {
        this.createLabel(parent, "Description");
        this.createTextDescription(parent);
    }

    private void createSectionType(Composite parent) {
        this.createLabel(parent, "Mappings Type");
        this.createComboViewerMappingsType(parent);
    }

    private void createSectionRegex(Composite parent) {
        this.createLabel(parent, "Regular Expression");
        this.createTextRegularExpression(parent);
    }

    private Text createTextDescription(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSeriesMappingDialog.this.description = text.getText().trim();
                CreateSeriesMappingDialog.this.validate();
            }
        });
        return text;
    }

    private ComboViewer createComboViewerMappingsType(Composite parent) {
        final ExtendedComboViewer comboViewer = new ExtendedComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput(MappingsType.values());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEnumLabel) {
                    return ((IEnumLabel)element).label();
                }
                return null;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setToolTipText("Select the mappings type.");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof MappingsType) {
                    CreateSeriesMappingDialog.this.mappingsType = (MappingsType)((Object)object);
                }
                CreateSeriesMappingDialog.this.validate();
            }
        });
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mappingsType));
        return comboViewer;
    }

    private Text createTextRegularExpression(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSeriesMappingDialog.this.regularExpression = text.getText().trim();
                CreateSeriesMappingDialog.this.validate();
            }
        });
        return text;
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void validate() {
        String message = null;
        if (MappingsType.NONE.equals((Object)this.mappingsType)) {
            message = "Please select a valid mappings type.";
        }
        if (this.regularExpression == null || this.regularExpression.isEmpty()) {
            message = "Please type in a regular expression.";
        } else {
            try {
                Pattern.compile(this.regularExpression);
            }
            catch (Exception e) {
                message = "The regular expression is not valid.";
            }
        }
        this.setErrorMessage(message);
    }
}

