/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.wizards;

import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.vagrant.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.PackageVMPageModel;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PackageVMPage
extends WizardPage {
    private final PackageVMPageModel model;
    private final DataBindingContext dbc;

    public PackageVMPage() {
        super("PackageVMPage", WizardMessages.getString("PackageVMPage.label"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("PackageVMPage.desc"));
        this.model = new PackageVMPageModel();
        this.dbc = new DataBindingContext();
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public String getBoxName() {
        return this.model.getBoxName();
    }

    public String getBoxFolder() {
        return this.model.getBoxFolder();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
        Label boxNameLabel = new Label(container, 0);
        boxNameLabel.setText(WizardMessages.getString("ImagePull.name.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxNameLabel);
        Text boxNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)boxNameText);
        boxNameText.setToolTipText(WizardMessages.getString("ImagePull.name.tooltip"));
        IObservableValue boxNameObservable = BeanProperties.value(PackageVMPageModel.class, (String)"boxName", String.class).observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)boxNameText), boxNameObservable, new UpdateValueStrategy(), null);
        Label boxFolderLabel = new Label(container, 0);
        boxFolderLabel.setText(WizardMessages.getString("PackageVMPage.folder.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxFolderLabel);
        Text boxFolderText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)boxFolderText);
        boxFolderText.setToolTipText(WizardMessages.getString("PackageVMPage.folder.desc"));
        IObservableValue boxFolderObservable = BeanProperties.value(PackageVMPageModel.class, (String)"boxFolder", String.class).observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)boxFolderText), boxFolderObservable, new UpdateValueStrategy(), null);
        Button searchButton = new Button(container, 0);
        searchButton.setText(WizardMessages.getString("ImagePull.search.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)searchButton);
        searchButton.addSelectionListener(this.onSearchFolder());
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new PackageVMValidationStatusProvider(this, (IObservableValue<String>)boxNameObservable, (IObservableValue<String>)boxFolderObservable));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)container);
    }

    private SelectionListener onSearchFolder() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog fd = new DirectoryDialog(this.getShell());
            String location = fd.open();
            if (location != null && !location.isEmpty()) {
                this.model.setBoxFolder(location);
            }
        });
    }

    private class PackageVMValidationStatusProvider
    extends MultiValidator {
        private IObservableValue<String> boxNameOb;
        private IObservableValue<String> boxFolderOb;

        public PackageVMValidationStatusProvider(PackageVMPage packageVMPage, IObservableValue<String> boxNameOb, IObservableValue<String> boxFolderOb) {
            this.boxNameOb = boxNameOb;
            this.boxFolderOb = boxFolderOb;
        }

        public IObservableList<IObservable> getTargets() {
            return new WritableList();
        }

        protected IStatus validate() {
            String boxName = (String)this.boxNameOb.getValue();
            String boxFolder = (String)this.boxFolderOb.getValue();
            if (boxName == null || boxName.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("AddBoxPage.emptyBoxName"));
            }
            if (boxFolder == null || boxFolder.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("PackageVMPage.folder.empty"));
            }
            if (!Paths.get(boxFolder, new String[0]).toFile().exists()) {
                return ValidationStatus.error((String)WizardMessages.getString("PackageVMPage.folder.not.exist"));
            }
            if (!Files.isWritable(Paths.get(boxFolder, new String[0]))) {
                return ValidationStatus.error((String)WizardMessages.getString("PackageVMPage.folder.not.writeable"));
            }
            return ValidationStatus.ok();
        }
    }
}

