/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.SecretBind;
import org.mandas.docker.client.messages.swarm.SecretFile;

final class ImmutableSecretBind
implements SecretBind {
    private final SecretFile file;
    private final String secretId;
    private final String secretName;

    private ImmutableSecretBind(SecretFile file, String secretId, String secretName) {
        this.file = file;
        this.secretId = secretId;
        this.secretName = secretName;
    }

    @Override
    @JsonProperty(value="File")
    public SecretFile file() {
        return this.file;
    }

    @Override
    @JsonProperty(value="SecretID")
    public String secretId() {
        return this.secretId;
    }

    @Override
    @JsonProperty(value="SecretName")
    public String secretName() {
        return this.secretName;
    }

    public final ImmutableSecretBind withFile(SecretFile value) {
        if (this.file == value) {
            return this;
        }
        SecretFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableSecretBind(newValue, this.secretId, this.secretName);
    }

    public final ImmutableSecretBind withSecretId(String value) {
        String newValue = Objects.requireNonNull(value, "secretId");
        if (this.secretId.equals(newValue)) {
            return this;
        }
        return new ImmutableSecretBind(this.file, newValue, this.secretName);
    }

    public final ImmutableSecretBind withSecretName(String value) {
        String newValue = Objects.requireNonNull(value, "secretName");
        if (this.secretName.equals(newValue)) {
            return this;
        }
        return new ImmutableSecretBind(this.file, this.secretId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretBind && this.equalTo(0, (ImmutableSecretBind)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecretBind another) {
        return this.file.equals(another.file) && this.secretId.equals(another.secretId) && this.secretName.equals(another.secretName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.secretId.hashCode();
        h += (h << 5) + this.secretName.hashCode();
        return h;
    }

    public String toString() {
        return "SecretBind{file=" + String.valueOf(this.file) + ", secretId=" + this.secretId + ", secretName=" + this.secretName + "}";
    }

    public static ImmutableSecretBind copyOf(SecretBind instance) {
        if (instance instanceof ImmutableSecretBind) {
            return (ImmutableSecretBind)instance;
        }
        return ImmutableSecretBind.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements SecretBind.Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_SECRET_ID = 2L;
        private static final long INIT_BIT_SECRET_NAME = 4L;
        private long initBits = 7L;
        private SecretFile file;
        private String secretId;
        private String secretName;

        private Builder() {
        }

        public final Builder from(SecretBind instance) {
            Objects.requireNonNull(instance, "instance");
            this.file(instance.file());
            this.secretId(instance.secretId());
            this.secretName(instance.secretName());
            return this;
        }

        @Override
        @JsonProperty(value="File")
        public final Builder file(SecretFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="SecretID")
        public final Builder secretId(String secretId) {
            this.secretId = Objects.requireNonNull(secretId, "secretId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="SecretName")
        public final Builder secretName(String secretName) {
            this.secretName = Objects.requireNonNull(secretName, "secretName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableSecretBind build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecretBind(this.file, this.secretId, this.secretName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secretId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("secretName");
            }
            return "Cannot build SecretBind, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

