/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ConfigureLabels;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConfigureLabelsCommandHandler
extends AbstractHandler {
    private static final String CONTAINER_FILTER_LABELS = "containerFilterLabels";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ConfigureLabels wizard = new ConfigureLabels();
        boolean configureLabels = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (configureLabels) {
            Map<String, String> labels = wizard.getConfigureLabels();
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                buffer.append(entry.getKey());
                buffer.append('=');
                buffer.append(entry.getValue());
                buffer.append('\u00a0');
            }
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
            preferences.put(CONTAINER_FILTER_LABELS, buffer.toString());
            IDockerConnection connection = CommandUtils.getCurrentConnection(null);
            connection.getContainers(true);
        }
        return null;
    }
}

