/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.sax;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class HTMLTagBalancerFilter
extends XMLFilterImpl
implements LexicalHandler {
    protected LexicalHandler lexicalHandler;
    protected final Stack<String> elementStack = new Stack();
    protected boolean documentInitialized = false;
    protected static final Set<String> BODY_ELEMENTS = new HashSet<String>();
    protected static final Set<String> HEAD_ELEMENTS;
    protected static final Set<String> VOID_ELEMENTS;

    public HTMLTagBalancerFilter() {
        this(null);
    }

    public HTMLTagBalancerFilter(XMLReader parent) {
        super(parent);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.getContentHandler() != null) {
            this.getContentHandler().setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.elementStack.clear();
        this.documentInitialized = false;
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        while (!this.elementStack.isEmpty()) {
            String element = this.elementStack.pop();
            if (this.getContentHandler() == null) continue;
            this.getContentHandler().endElement("", element, element);
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        String tagName = qName.toUpperCase();
        if ("HTML".equals(tagName)) {
            this.documentInitialized = true;
        } else {
            this.ensureDocumentInitialized();
        }
        if (BODY_ELEMENTS.contains(tagName)) {
            this.closeElement("HEAD");
            this.closeElement("TITLE");
        }
        handler.startElement(uri, localName, qName, atts);
        if (!VOID_ELEMENTS.contains(tagName)) {
            this.elementStack.push(tagName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        String tagName = qName.toUpperCase();
        if (!this.elementStack.isEmpty()) {
            int index = this.elementStack.lastIndexOf(tagName);
            if (index >= 0) {
                while (this.elementStack.size() > index + 1) {
                    String elem = this.elementStack.pop();
                    handler.endElement("", elem, elem);
                }
                this.elementStack.pop();
                handler.endElement(uri, localName, qName);
            } else {
                handler.endElement(uri, localName, qName);
            }
        } else {
            handler.endElement(uri, localName, qName);
        }
    }

    protected void closeElement(String tagName) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        if (handler == null || this.elementStack.isEmpty()) {
            return;
        }
        int index = this.elementStack.lastIndexOf(tagName);
        if (index >= 0) {
            while (this.elementStack.size() > index) {
                String elem = this.elementStack.pop();
                handler.endElement("", elem, elem);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.ensureDocumentInitialized();
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.ensureDocumentInitialized();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    protected void ensureDocumentInitialized() throws SAXException {
        if (!this.documentInitialized) {
            this.documentInitialized = true;
            ContentHandler handler = this.getContentHandler();
            if (handler != null) {
                handler.startElement("", "HTML", "HTML", new AttributesImpl());
                this.elementStack.push("HTML");
            }
        }
    }

    static {
        BODY_ELEMENTS.add("BODY");
        BODY_ELEMENTS.add("FRAMESET");
        HEAD_ELEMENTS = new HashSet<String>();
        HEAD_ELEMENTS.add("TITLE");
        HEAD_ELEMENTS.add("META");
        HEAD_ELEMENTS.add("LINK");
        HEAD_ELEMENTS.add("STYLE");
        HEAD_ELEMENTS.add("SCRIPT");
        HEAD_ELEMENTS.add("BASE");
        VOID_ELEMENTS = new HashSet<String>();
        VOID_ELEMENTS.add("AREA");
        VOID_ELEMENTS.add("BASE");
        VOID_ELEMENTS.add("BR");
        VOID_ELEMENTS.add("COL");
        VOID_ELEMENTS.add("EMBED");
        VOID_ELEMENTS.add("HR");
        VOID_ELEMENTS.add("IMG");
        VOID_ELEMENTS.add("INPUT");
        VOID_ELEMENTS.add("LINK");
        VOID_ELEMENTS.add("META");
        VOID_ELEMENTS.add("PARAM");
        VOID_ELEMENTS.add("SOURCE");
        VOID_ELEMENTS.add("TRACK");
        VOID_ELEMENTS.add("WBR");
    }
}

