/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleHTMLScanner
implements XMLReader {
    protected ContentHandler fContentHandler;
    protected DTDHandler fDTDHandler;
    protected EntityResolver fEntityResolver;
    protected ErrorHandler fErrorHandler;
    protected LexicalHandler fLexicalHandler;
    protected boolean fNormalizeElements = true;
    protected boolean fNormalizeAttributes = true;
    protected String fElementCase = "upper";
    protected String fAttributeCase = "lower";
    private static final Pattern START_TAG = Pattern.compile("<([a-zA-Z][a-zA-Z0-9-]*)([^>]*)>");
    private static final Pattern END_TAG = Pattern.compile("</([a-zA-Z][a-zA-Z0-9-]*)>");
    private static final Pattern COMMENT = Pattern.compile("<!--(.*?)-->", 32);
    private static final Pattern DOCTYPE = Pattern.compile("<!DOCTYPE\\s+([^>]+)>", 2);
    private static final Pattern ATTRIBUTE = Pattern.compile("([a-zA-Z][a-zA-Z0-9:._-]*)(?:=(\"([^\"]*)\"|'([^']*)'|([^\\s>]+)))?");
    private static final Set<String> VOID_ELEMENTS = new HashSet<String>();

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.fContentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.fDTDHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.fLexicalHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.fLexicalHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        String line;
        if (this.fContentHandler == null) {
            return;
        }
        Reader reader = input.getCharacterStream();
        if (reader == null) {
            InputStream stream = input.getByteStream();
            if (stream == null && input.getSystemId() != null) {
                throw new SAXException("SystemId not yet supported");
            }
            if (stream != null) {
                String encoding = input.getEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                reader = new InputStreamReader(stream, encoding);
            }
        }
        if (reader == null) {
            throw new SAXException("No input source available");
        }
        StringBuilder content = new StringBuilder();
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            content.append(line).append('\n');
        }
        this.parseHTML(content.toString());
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    protected void parseHTML(String html) throws SAXException {
        this.fContentHandler.startDocument();
        int pos = 0;
        int length = html.length();
        while (pos < length) {
            char ch = html.charAt(pos);
            if (ch == '<') {
                Matcher m;
                if (html.startsWith("<!--", pos) && (m = COMMENT.matcher(html.substring(pos))).find() && m.start() == 0) {
                    if (this.fLexicalHandler != null) {
                        String commentText = m.group(1);
                        this.fLexicalHandler.comment(commentText.toCharArray(), 0, commentText.length());
                    }
                    pos += m.end();
                    continue;
                }
                if ((html.startsWith("<!DOCTYPE", pos) || html.startsWith("<!doctype", pos)) && (m = DOCTYPE.matcher(html.substring(pos))).find() && m.start() == 0) {
                    if (this.fLexicalHandler != null) {
                        this.fLexicalHandler.startDTD("html", null, null);
                        this.fLexicalHandler.endDTD();
                    }
                    pos += m.end();
                    continue;
                }
                Matcher endMatcher = END_TAG.matcher(html.substring(pos));
                if (endMatcher.find() && endMatcher.start() == 0) {
                    String tagName = this.normalizeElementName(endMatcher.group(1));
                    this.fContentHandler.endElement("", tagName, tagName);
                    pos += endMatcher.end();
                    continue;
                }
                Matcher startMatcher = START_TAG.matcher(html.substring(pos));
                if (startMatcher.find() && startMatcher.start() == 0) {
                    String tagName = this.normalizeElementName(startMatcher.group(1));
                    String attrString = startMatcher.group(2);
                    AttributesImpl attrs = this.parseAttributes(attrString);
                    this.fContentHandler.startElement("", tagName, tagName, attrs);
                    if (VOID_ELEMENTS.contains(tagName.toUpperCase())) {
                        this.fContentHandler.endElement("", tagName, tagName);
                    }
                    pos += startMatcher.end();
                    continue;
                }
                ++pos;
                continue;
            }
            int nextTag = html.indexOf(60, pos);
            int endPos = nextTag >= 0 ? nextTag : length;
            String text = html.substring(pos, endPos);
            if (text.length() > 0) {
                this.fContentHandler.characters(text.toCharArray(), 0, text.length());
            }
            pos = endPos;
        }
        this.fContentHandler.endDocument();
    }

    protected AttributesImpl parseAttributes(String attrString) {
        AttributesImpl attrs = new AttributesImpl();
        if (attrString == null || attrString.trim().isEmpty()) {
            return attrs;
        }
        Matcher m = ATTRIBUTE.matcher(attrString);
        while (m.find()) {
            String name = this.normalizeAttributeName(m.group(1));
            String value = m.group(3);
            if (value == null) {
                value = m.group(4);
            }
            if (value == null) {
                value = m.group(5);
            }
            if (value == null) {
                value = "";
            }
            attrs.addAttribute("", name, name, "CDATA", value);
        }
        return attrs;
    }

    protected String normalizeElementName(String name) {
        if (!this.fNormalizeElements) {
            return name;
        }
        return "upper".equals(this.fElementCase) ? name.toUpperCase() : ("lower".equals(this.fElementCase) ? name.toLowerCase() : name);
    }

    protected String normalizeAttributeName(String name) {
        if (!this.fNormalizeAttributes) {
            return name;
        }
        return "upper".equals(this.fAttributeCase) ? name.toUpperCase() : ("lower".equals(this.fAttributeCase) ? name.toLowerCase() : name);
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Feature not recognized: " + name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.fLexicalHandler;
        }
        throw new SAXNotRecognizedException("Property not recognized: " + name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
            return;
        }
    }

    static {
        VOID_ELEMENTS.add("AREA");
        VOID_ELEMENTS.add("BASE");
        VOID_ELEMENTS.add("BR");
        VOID_ELEMENTS.add("COL");
        VOID_ELEMENTS.add("EMBED");
        VOID_ELEMENTS.add("HR");
        VOID_ELEMENTS.add("IMG");
        VOID_ELEMENTS.add("INPUT");
        VOID_ELEMENTS.add("LINK");
        VOID_ELEMENTS.add("META");
        VOID_ELEMENTS.add("PARAM");
        VOID_ELEMENTS.add("SOURCE");
        VOID_ELEMENTS.add("TRACK");
        VOID_ELEMENTS.add("WBR");
    }
}

