/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractSTTreeViewer
extends AbstractSTViewer {
    public AbstractSTTreeViewer(Composite parent) {
        super(parent, 68354);
    }

    public AbstractSTTreeViewer(Composite parent, int style) {
        super(parent, style, true);
    }

    protected TreeViewer createViewer(Composite parent, int style) {
        Tree t = this.createTree(parent, style);
        return new TreeViewer(t);
    }

    private Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        return tree;
    }

    @Override
    protected void createColumns() {
        Tree tree = this.getViewer().getTree();
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        for (int i = 0; i < this.getAllFields().length; ++i) {
            ISTDataViewersField field = this.getAllFields()[i];
            TreeColumn tc = new TreeColumn(tree, field.getAlignment(), i);
            tc.setText(field.getColumnHeaderText());
            tc.setToolTipText(field.getColumnHeaderTooltip());
            tc.setImage(field.getColumnHeaderImage());
            tc.setWidth(field.getPreferredWidth());
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.addSelectionListener(this.createHeaderListener());
            tc.setData((Object)field);
            TreeViewerColumn viewerColumn = new TreeViewerColumn(this.getViewer(), tc);
            viewerColumn.setLabelProvider(this.createColumnLabelProvider((Item)tc));
        }
        tree.addMouseMoveListener(e -> {
            Tree tree1 = (Tree)e.widget;
            TreeItem item = tree1.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            tree1.setCursor(e.display.getSystemCursor(0));
        });
    }

    public TreeColumn[] getColumns() {
        return this.getViewer().getTree().getColumns();
    }

    @Override
    public void updateDirectionIndicator(Item column) {
        this.getViewer().getTree().setSortColumn((TreeColumn)column);
        if (this.getTableSorter().getTopPriorityDirection() == 1) {
            this.getViewer().getTree().setSortDirection(128);
        } else {
            this.getViewer().getTree().setSortDirection(1024);
        }
    }

    @Override
    public int[] getColumnOrder() {
        return this.getViewer().getTree().getColumnOrder();
    }

    @Override
    protected void setColumnOrder(int[] order) {
        this.getViewer().getTree().setColumnOrder(order);
    }

    @Override
    public int getColumnIndex(Item column) {
        return this.getViewer().getTree().indexOf((TreeColumn)column);
    }

    @Override
    public int getColumnWidth(Item column) {
        return ((TreeColumn)column).getWidth();
    }

    @Override
    public void setColumnResizable(Item column, boolean resizable) {
        ((TreeColumn)column).setResizable(resizable);
    }

    @Override
    public void setColumnWidth(Item column, int width) {
        ((TreeColumn)column).setWidth(width);
    }

    public TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }
}

