/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.launch.ListTreeContentProvider;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.linuxtools.internal.callgraph.launch.RuledTreeSelectionDialog;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapOptionsTab;
import org.eclipse.linuxtools.internal.callgraph.launch.TranslationUnitVisitor;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class SystemTapLaunchShortcut
extends ProfileLaunchShortcut {
    private static final String USER_SELECTED_ALL = "ALL";
    private static final String MAIN_FUNC_NAME = "main";
    protected String name;
    protected String binaryPath;
    protected String scriptPath;
    protected String arguments;
    protected String outputPath;
    protected String binName;
    protected String generatedScript;
    protected String parserID;
    protected String viewID;
    protected boolean needToGenerate;
    protected boolean overwrite;
    protected boolean useColours;
    protected String resourceToSearchFor;
    protected boolean searchForResource;
    protected IBinary bin;
    private boolean testMode = false;

    public void initialize() {
        this.name = "";
        this.binaryPath = "";
        this.arguments = "";
        this.outputPath = PluginConstants.getDefaultIOPath();
        this.overwrite = true;
        this.generatedScript = "";
        this.needToGenerate = false;
        this.useColours = false;
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.linuxtools.callgraph.launch.systemtapLaunch");
    }

    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
        SystemTapOptionsTab tab = new SystemTapOptionsTab();
        tab.setDefaults(wc);
    }

    protected void finishLaunch(String name, String mode, ILaunchConfigurationWorkingCopy wc) throws IOException {
        if (!this.finishLaunchHelper()) {
            return;
        }
        if (wc != null) {
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", this.scriptPath);
            if (!SystemTapLaunchShortcut.invalid(this.binaryPath)) {
                wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", this.binaryPath);
            }
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", this.outputPath);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", this.arguments);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", this.generatedScript);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", this.needToGenerate);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.OVERWRITE", this.overwrite);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", this.useColours);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", this.parserID);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", this.viewID);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.SECONDARY_VIEW_ID", "");
            if (!this.testMode) {
                DebugUITools.launch((ILaunchConfiguration)wc, (String)mode);
            }
        }
    }

    private static boolean invalid(String str) {
        return str == null || str.length() < 1;
    }

    private boolean finishLaunchHelper() throws IOException {
        if (SystemTapLaunchShortcut.invalid(this.scriptPath)) {
            this.scriptPath = this.setScriptPath();
        }
        if (SystemTapLaunchShortcut.invalid(this.scriptPath)) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.ErrorMessageName"), Messages.getString("SystemTapLaunchShortcut.ErrorMessageTitle"), Messages.getString("SystemTapLaunchShortcut.ErrorMessage") + this.name);
            mess.schedule();
            return false;
        }
        if (SystemTapLaunchShortcut.invalid(this.parserID)) {
            this.parserID = this.setParserID();
        }
        if (SystemTapLaunchShortcut.invalid(this.parserID)) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.InvalidParser1"), Messages.getString("SystemTapLaunchShortcut.InvalidParser2"), Messages.getString("SystemTapLaunchShortcut.InvalidParser3"));
            mess.schedule();
            return false;
        }
        if (SystemTapLaunchShortcut.invalid(this.viewID)) {
            this.viewID = this.setViewID();
        }
        if (SystemTapLaunchShortcut.invalid(this.viewID)) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.InvalidView1"), Messages.getString("SystemTapLaunchShortcut.InvalidView2"), Messages.getString("SystemTapLaunchShortcut.InvalidView3"));
            mess.schedule();
            return false;
        }
        if (this.needToGenerate) {
            if (SystemTapLaunchShortcut.invalid(this.generatedScript)) {
                this.generatedScript = this.generateScript();
            }
            if (SystemTapLaunchShortcut.invalid(this.generatedScript)) {
                SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.InvalidGeneration1"), Messages.getString("SystemTapLaunchShortcut.InvalidGeneration2"), Messages.getString("SystemTapLaunchShortcut.InvalidGeneration3"));
                mess.schedule();
                return false;
            }
        }
        return true;
    }

    public String getName(IBinary bin) {
        this.binName = bin != null ? bin.getPath().toString() : "";
        return this.binName;
    }

    protected ILaunchConfiguration createConfiguration(IBinary bin) {
        if (bin != null) {
            return super.createConfiguration(bin);
        }
        try {
            return this.getLaunchConfigType().newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(Messages.getString("SystemTapLaunchShortcut.Invalid")));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ILaunchConfigurationWorkingCopy createConfiguration(IBinary bin, String name) {
        ILaunchConfigurationWorkingCopy wc = null;
        if (bin != null) {
            try {
                String projectName = bin.getResource().getProjectRelativePath().toString();
                ILaunchConfigurationType configType = this.getLaunchConfigType();
                wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(name + " - " + bin.getElementName()));
                wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", projectName);
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
                wc.setMappedResources(new IResource[]{bin.getResource(), bin.getResource().getProject()});
                wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", (String)null);
                this.setDefaultProfileAttributes(wc);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            try {
                wc = this.getLaunchConfigType().newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(name));
                this.setDefaultProfileAttributes(wc);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return wc;
    }

    public ILaunchConfigurationType outsideGetLaunchConfigType() {
        return this.getLaunchConfigType();
    }

    public String getArguments() {
        return this.arguments;
    }

    protected String getFunctionsFromBinary(IBinary bin, String targetResource) {
        Object funcs = "";
        if (bin == null) {
            return funcs;
        }
        try {
            ArrayList<ICContainer> list = new ArrayList<ICContainer>();
            TranslationUnitVisitor v = new TranslationUnitVisitor();
            for (Object b : bin.getCProject().getChildrenOfType(12)) {
                ICContainer c = (ICContainer)b;
                for (ITranslationUnit iTranslationUnit : c.getTranslationUnits()) {
                    if (this.searchForResource && iTranslationUnit.getElementName().contains(targetResource)) {
                        iTranslationUnit.accept((ICElementVisitor)v);
                        funcs = (String)funcs + v.getFunctions();
                        return funcs;
                    }
                    if (list.contains(c)) continue;
                    list.add(c);
                }
                while (c.getChildrenOfType(12).size() > 0) {
                    ICContainer e = null;
                    for (ICElement d : c.getChildrenOfType(12)) {
                        e = (ICContainer)d;
                        for (ITranslationUnit tu2 : e.getTranslationUnits()) {
                            if (this.searchForResource && tu2.getElementName().contains(targetResource)) {
                                tu2.accept((ICElementVisitor)v);
                                funcs = (String)funcs + v.getFunctions();
                                return funcs;
                            }
                            if (list.contains(c)) continue;
                            list.add(c);
                        }
                    }
                    c = e;
                }
            }
            int numberOfFiles = this.numberOfValidFiles(list.toArray());
            if (numberOfFiles == 1) {
                for (ICContainer c : list) {
                    for (ITranslationUnit iTranslationUnit : c.getTranslationUnits()) {
                        if (!SystemTapLaunchShortcut.validElement((ICElement)iTranslationUnit)) continue;
                        iTranslationUnit.accept((ICElementVisitor)v);
                        funcs = (String)funcs + v.getFunctions();
                    }
                }
            } else {
                Object[] unitList = this.chooseUnit(list, numberOfFiles);
                if (unitList == null || unitList.length == 0) {
                    return null;
                }
                if (unitList.length == 1 && unitList[0].toString().equals(USER_SELECTED_ALL)) {
                    funcs = "*";
                    return funcs;
                }
                StringBuilder tmpFunc = new StringBuilder();
                for (String item : SystemTapLaunchShortcut.getAllFunctions(bin.getCProject(), unitList)) {
                    tmpFunc.append(item);
                    tmpFunc.append(" ");
                }
                funcs = tmpFunc.toString();
            }
            return funcs;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object[] chooseUnit(List<ICContainer> list, int numberOfValidFiles) {
        ICElement[] array;
        ArrayList<Object> output;
        ListTreeContentProvider prov = new ListTreeContentProvider();
        RuledTreeSelectionDialog dialog = new RuledTreeSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), prov);
        dialog.setTitle(Messages.getString("SystemTapLaunchShortcut.SelectFiles"));
        dialog.setMessage(Messages.getString("SystemTapLaunchShortcut.SelectFilesMsg"));
        dialog.setInput(list);
        dialog.setHelpAvailable(false);
        dialog.setStatusLineAboveButtons(false);
        dialog.setEmptyListMessage(Messages.getString("SystemTapLaunchShortcut.NoFiles"));
        dialog.setContainerMode(true);
        Object[] topLevel = prov.findElements(list);
        dialog.setInitialSelections(topLevel);
        dialog.setSize(this.cap(topLevel.length * 10, 30, 55), this.cap((int)((double)topLevel.length * 1.5), 3, 13));
        dialog.create();
        Button okButton = dialog.getOkButton();
        Object[] result = null;
        if (this.testMode) {
            okButton.setSelection(true);
            result = list.toArray();
            output = new ArrayList<Object>();
            try {
                for (Object obj : result) {
                    if (!(obj instanceof ICContainer)) continue;
                    for (ICElement c : array = ((ICContainer)obj).getChildren()) {
                        if (!SystemTapLaunchShortcut.validElement(c) || !c.getElementName().contains(MAIN_FUNC_NAME) || output.contains(c)) continue;
                        output.add(c);
                    }
                }
                if (output.size() >= numberOfValidFiles) {
                    output.clear();
                    output.add(USER_SELECTED_ALL);
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
            result = output.toArray();
        } else {
            if (dialog.open() == 1) {
                return null;
            }
            result = dialog.getResult();
        }
        if (result == null) {
            return null;
        }
        output = new ArrayList();
        try {
            for (Object obj : result) {
                if (obj instanceof ICContainer) {
                    for (ICElement c : array = ((ICContainer)obj).getChildren()) {
                        if (!SystemTapLaunchShortcut.validElement(c) || output.contains(c)) continue;
                        output.add(c);
                    }
                    continue;
                }
                if (!(obj instanceof ICElement) || !SystemTapLaunchShortcut.validElement((ICElement)obj) || output.contains(obj)) continue;
                output.add(obj);
            }
            if (output.size() >= numberOfValidFiles) {
                output.clear();
                output.add(USER_SELECTED_ALL);
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return output.toArray();
    }

    private int numberOfValidFiles(Object[] list) throws CModelException {
        int output = 0;
        for (Object parent : list) {
            if (parent instanceof ICContainer) {
                ICContainer cont = (ICContainer)parent;
                for (ICElement ele : cont.getChildren()) {
                    if (ele instanceof ICContainer) {
                        output += this.numberOfValidFiles(((ICContainer)ele).getChildren());
                    }
                    if (!SystemTapLaunchShortcut.validElement(ele)) continue;
                    ++output;
                }
                continue;
            }
            if (!(parent instanceof ICElement) || !SystemTapLaunchShortcut.validElement((ICElement)parent)) continue;
            ++output;
        }
        return output;
    }

    private static List<String> getAllFunctions(ICProject project, Object[] listOfFiles) {
        try {
            GetFunctionsJob j = new GetFunctionsJob(project.getHandleIdentifier(), project, listOfFiles);
            j.schedule();
            j.join();
            ArrayList<String> functionList = j.getFunctionList();
            return functionList;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean specialContains(Object[] list, String path) {
        for (Object val : list) {
            ICElement el;
            if (!(val instanceof ICElement) || !(el = (ICElement)val).getPath().toString().contains(path)) continue;
            return true;
        }
        return false;
    }

    private int cap(int number, int low, int high) {
        if (number > high) {
            return high;
        }
        if (number < low) {
            return low;
        }
        return number;
    }

    public String generateScript() throws IOException {
        return null;
    }

    public String setParserID() {
        return "org.eclipse.linuxtools.callgraph.core.systemtaptextparser";
    }

    public String getScript() {
        return this.generatedScript;
    }

    public void setTestMode(boolean val) {
        this.testMode = val;
    }

    public String setViewID() {
        return "org.eclipse.linuxtools.callgraph.core.staptextview";
    }

    public static boolean validElement(ICElement e) {
        return e.getElementName().endsWith(".c") || e.getElementName().endsWith(".cpp") || e.getElementName().endsWith(".h");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(IBinary bin, String mode) {
        this.initialize();
        this.bin = bin;
        this.binName = this.getName(bin);
        this.name = "DefaultSystemTapLaunch";
        try {
            ILaunchConfigurationWorkingCopy wc = this.createConfiguration(bin, this.name);
            this.arguments = this.binaryPath = bin.getResource().getLocation().toString();
            this.outputPath = PluginConstants.getDefaultIOPath();
            this.finishLaunch(this.name, mode, wc);
        }
        catch (IOException e) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages("LaunchShortcutScriptGen", Messages.getString("LaunchStapGraph.ScriptGenErr"), Messages.getString("LaunchStapGraph.ScriptGenErrMsg"));
            mess.schedule();
            e.printStackTrace();
        }
        finally {
            this.resourceToSearchFor = "";
            this.searchForResource = false;
        }
    }

    public abstract String setScriptPath();

    private static class GetFunctionsJob
    extends Job {
        private ArrayList<String> functionList = new ArrayList();
        private ICProject project;
        private Object[] listOfFiles;

        public GetFunctionsJob(String name, ICProject p, Object[] o) {
            super(name);
            this.listOfFiles = Arrays.copyOf(o, o.length);
            this.project = p;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IIndexManager manager = CCorePlugin.getIndexManager();
            IIndex index = null;
            IProgressMonitor m = monitor;
            if (m == null) {
                m = new NullProgressMonitor();
            }
            m.worked(1);
            try {
                IIndexFile[] blah;
                index = manager.getIndex(this.project);
                index.acquireReadLock();
                for (IIndexFile file : blah = index.getAllFiles()) {
                    IIndexName[] indexNamesArray;
                    String fullFilePath = file.getLocation().getFullPath();
                    if (fullFilePath == null || !SystemTapLaunchShortcut.specialContains(this.listOfFiles, fullFilePath)) continue;
                    for (IIndexName name : indexNamesArray = file.findNames(0, Integer.MAX_VALUE)) {
                        IIndexBinding binder;
                        if (!name.isDefinition() || !SystemTapLaunchShortcut.specialContains(this.listOfFiles, name.getFile().getLocation().getFullPath()) || !((binder = index.findBinding((IName)name)) instanceof IFunction) || this.functionList.contains(binder.getName())) continue;
                        this.functionList.add(binder.getName());
                    }
                    m.worked(1);
                }
                index.releaseReadLock();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        public ArrayList<String> getFunctionList() {
            return this.functionList;
        }
    }
}

