/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.ui.contentassist

import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension
import org.eclipse.lsat.motioncalculator.MotionException
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor
import setting.MotionProfileSettings

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class SettingProposalProvider extends AbstractSettingProposalProvider {

    override completeMotionProfileSettings_MotionProfile(EObject model, Assignment assignment,
        ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeMotionProfileSettings_MotionProfile(model, assignment, context, acceptor)
        try {
            val MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.selectedMotionCalculator
            motionCalculator.motionProfiles.forEach [
                acceptor.accept(createCompletionProposal(key, name, null, context))
            ]
        } catch (MotionException e) {
            // Ignore
        }
    }

    override completeMotionArgumentsMapEntry_Key(EObject model, Assignment assignment, ContentAssistContext context,
        ICompletionProposalAcceptor acceptor) {
        super.completeMotionArgumentsMapEntry_Key(model, assignment, context, acceptor)
        try {
            val motionProfileSettings = model as MotionProfileSettings
            val MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.selectedMotionCalculator
            val motionProfile = motionCalculator.getMotionProfile(motionProfileSettings.motionProfile)
            if (motionProfile !== null) {
                val alreadySpecified = motionProfileSettings.motionArguments.keySet
                motionProfile.parameters.filter[!alreadySpecified.contains(key)].forEach [
                    acceptor.accept(createCompletionProposal(key, name, null, context))
                ]
            }
        } catch (MotionException e) {
            // Ignore
        }
    }
}
