/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.lsat.activity.diagram.design;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import activity.ActivityFactory;
import activity.Event;

public class AddEventActionPage extends WizardPage {
    private enum EventType {
        Require("Require event"), Raise("Raise event");

        private final String description;

        private EventType(String description) {
            this.description = description;
        }

        @Override
        public String toString() {
            return description;
        }
    }

    private final String initialActionName;

    private Text textName;

    private Text textEventName;

    private ComboViewer comboEventType;

    public AddEventActionPage(String initialActionName) {
        super(AddEventActionPage.class.getSimpleName());
        setTitle("Event details");
        setDescription("Provide the details for the event to add");
        this.initialActionName = initialActionName;
        setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, SWT.NULL);
        setControl(container);
        container.setLayout(new GridLayout(2, false));

        Label lblName = new Label(container, SWT.NONE);
        lblName.setAlignment(SWT.RIGHT);
        lblName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
        lblName.setText("Action Name:");

        textName = new Text(container, SWT.BORDER);
        textName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
        textName.setText(initialActionName);

        Label evtName = new Label(container, SWT.NONE);
        evtName.setAlignment(SWT.RIGHT);
        evtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
        evtName.setText("Event Name:");

        textEventName = new Text(container, SWT.BORDER);
        textEventName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

        Label lblType = new Label(container, SWT.NONE);
        lblType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
        lblType.setText("Event type:");

        comboEventType = new ComboViewer(container, SWT.NONE);
        comboEventType.setContentProvider(ArrayContentProvider.getInstance());
        comboEventType.setLabelProvider(new LabelProvider());
        comboEventType.getCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
        comboEventType.getCombo().setEnabled(true);
        comboEventType.addSelectionChangedListener(new ISelectionChangedListener() {
            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                updatePageComplete();
            }
        });
        comboEventType.setInput(EventType.values());
    }

    public Event createEventAction() {
        String actionName = textName.getText();
        String eventName = textEventName.getText();
        EventType type = (EventType)((StructuredSelection)comboEventType.getSelection()).getFirstElement();
        Event event = (type == EventType.Raise) ? ActivityFactory.eINSTANCE.createRaiseEvent()
                : ActivityFactory.eINSTANCE.createRequireEvent();
        event.setName(actionName);
        event.setEventName(eventName);
        return event;
    }

    private void updatePageComplete() {
        boolean pageComplete = true;
        pageComplete &= !textName.getText().isEmpty();
        pageComplete &= !textEventName.getText().isEmpty();
        pageComplete &= !comboEventType.getSelection().isEmpty();
        setPageComplete(pageComplete);
    }
}
