/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class ActivityGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class ActivitySetElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ActivitySet");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cActivitySetAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cImportsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportsImportParserRuleCall_1_0 = (RuleCall)cImportsAssignment_1.eContents().get(0);
		private final Assignment cActivitiesAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cActivitiesActivityParserRuleCall_2_0 = (RuleCall)cActivitiesAssignment_2.eContents().get(0);
		
		//ActivitySet:
		//	{ActivitySet} imports+=Import*
		//	activities+=Activity*;
		@Override public ParserRule getRule() { return rule; }
		
		//{ActivitySet} imports+=Import* activities+=Activity*
		public Group getGroup() { return cGroup; }
		
		//{ActivitySet}
		public Action getActivitySetAction_0() { return cActivitySetAction_0; }
		
		//imports+=Import*
		public Assignment getImportsAssignment_1() { return cImportsAssignment_1; }
		
		//Import
		public RuleCall getImportsImportParserRuleCall_1_0() { return cImportsImportParserRuleCall_1_0; }
		
		//activities+=Activity*
		public Assignment getActivitiesAssignment_2() { return cActivitiesAssignment_2; }
		
		//Activity
		public RuleCall getActivitiesActivityParserRuleCall_2_0() { return cActivitiesActivityParserRuleCall_2_0; }
	}
	public class ImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Import");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cImportURIAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportURISTRINGTerminalRuleCall_1_0 = (RuleCall)cImportURIAssignment_1.eContents().get(0);
		
		//Import machine::Import:
		//	"import" importURI=STRING;
		@Override public ParserRule getRule() { return rule; }
		
		//"import" importURI=STRING
		public Group getGroup() { return cGroup; }
		
		//"import"
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//importURI=STRING
		public Assignment getImportURIAssignment_1() { return cImportURIAssignment_1; }
		
		//STRING
		public RuleCall getImportURISTRINGTerminalRuleCall_1_0() { return cImportURISTRINGTerminalRuleCall_1_0; }
	}
	public class ActivityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Activity");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cActivityKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cPrerequisitesKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final Assignment cPrerequisitesAssignment_3_2 = (Assignment)cGroup_3.eContents().get(2);
		private final RuleCall cPrerequisitesLocationPrerequisiteParserRuleCall_3_2_0 = (RuleCall)cPrerequisitesAssignment_3_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3_3 = (Keyword)cGroup_3.eContents().get(3);
		private final Keyword cActionsKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Keyword cLeftCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cNodesAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cNodesNodeParserRuleCall_6_0 = (RuleCall)cNodesAssignment_6.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Keyword cActionFlowKeyword_8 = (Keyword)cGroup.eContents().get(8);
		private final Keyword cLeftCurlyBracketKeyword_9 = (Keyword)cGroup.eContents().get(9);
		private final Assignment cEdgesAssignment_10 = (Assignment)cGroup.eContents().get(10);
		private final RuleCall cEdgesEdgesParserRuleCall_10_0 = (RuleCall)cEdgesAssignment_10.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_11 = (Keyword)cGroup.eContents().get(11);
		private final Keyword cRightCurlyBracketKeyword_12 = (Keyword)cGroup.eContents().get(12);
		
		//Activity:
		//	'activity' name=IID '{' ('prerequisites' '{' prerequisites+=LocationPrerequisite* '}')?
		//	'actions' '{' nodes+=Node* '}'
		//	'action flow' '{' edges+=Edges* '}'
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'activity' name=IID '{' ('prerequisites' '{' prerequisites+=LocationPrerequisite* '}')? 'actions' '{' nodes+=Node* '}'
		//'action flow' '{' edges+=Edges* '}' '}'
		public Group getGroup() { return cGroup; }
		
		//'activity'
		public Keyword getActivityKeyword_0() { return cActivityKeyword_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }
		
		//('prerequisites' '{' prerequisites+=LocationPrerequisite* '}')?
		public Group getGroup_3() { return cGroup_3; }
		
		//'prerequisites'
		public Keyword getPrerequisitesKeyword_3_0() { return cPrerequisitesKeyword_3_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_1() { return cLeftCurlyBracketKeyword_3_1; }
		
		//prerequisites+=LocationPrerequisite*
		public Assignment getPrerequisitesAssignment_3_2() { return cPrerequisitesAssignment_3_2; }
		
		//LocationPrerequisite
		public RuleCall getPrerequisitesLocationPrerequisiteParserRuleCall_3_2_0() { return cPrerequisitesLocationPrerequisiteParserRuleCall_3_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_3() { return cRightCurlyBracketKeyword_3_3; }
		
		//'actions'
		public Keyword getActionsKeyword_4() { return cActionsKeyword_4; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5() { return cLeftCurlyBracketKeyword_5; }
		
		//nodes+=Node*
		public Assignment getNodesAssignment_6() { return cNodesAssignment_6; }
		
		//Node
		public RuleCall getNodesNodeParserRuleCall_6_0() { return cNodesNodeParserRuleCall_6_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_7() { return cRightCurlyBracketKeyword_7; }
		
		//'action flow'
		public Keyword getActionFlowKeyword_8() { return cActionFlowKeyword_8; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_9() { return cLeftCurlyBracketKeyword_9; }
		
		//edges+=Edges*
		public Assignment getEdgesAssignment_10() { return cEdgesAssignment_10; }
		
		//Edges
		public RuleCall getEdgesEdgesParserRuleCall_10_0() { return cEdgesEdgesParserRuleCall_10_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_11() { return cRightCurlyBracketKeyword_11; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_12() { return cRightCurlyBracketKeyword_12; }
	}
	public class ResourceQualifiedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ResourceQualifiedName");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cIIDParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final RuleCall cIIDParserRuleCall_1_1 = (RuleCall)cGroup_1.eContents().get(1);
		
		//ResourceQualifiedName:
		//	IID ('.' IID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//IID ('.' IID)?
		public Group getGroup() { return cGroup; }
		
		//IID
		public RuleCall getIIDParserRuleCall_0() { return cIIDParserRuleCall_0; }
		
		//('.' IID)?
		public Group getGroup_1() { return cGroup_1; }
		
		//'.'
		public Keyword getFullStopKeyword_1_0() { return cFullStopKeyword_1_0; }
		
		//IID
		public RuleCall getIIDParserRuleCall_1_1() { return cIIDParserRuleCall_1_1; }
	}
	public class LocationPrerequisiteElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.LocationPrerequisite");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cResourceAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cResourceIResourceCrossReference_0_0 = (CrossReference)cResourceAssignment_0.eContents().get(0);
		private final RuleCall cResourceIResourceResourceQualifiedNameParserRuleCall_0_0_1 = (RuleCall)cResourceIResourceCrossReference_0_0.eContents().get(1);
		private final Keyword cFullStopKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cPeripheralAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cPeripheralPeripheralCrossReference_2_0 = (CrossReference)cPeripheralAssignment_2.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIIDParserRuleCall_2_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_2_0.eContents().get(1);
		private final Keyword cAtKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPositionAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cPositionSymbolicPositionCrossReference_4_0 = (CrossReference)cPositionAssignment_4.eContents().get(0);
		private final RuleCall cPositionSymbolicPositionIIDParserRuleCall_4_0_1 = (RuleCall)cPositionSymbolicPositionCrossReference_4_0.eContents().get(1);
		
		//LocationPrerequisite:
		//	resource=[machine::IResource|ResourceQualifiedName] '.' peripheral=[machine::Peripheral|IID] 'at'
		//	position=[machine::SymbolicPosition|IID];
		@Override public ParserRule getRule() { return rule; }
		
		//resource=[machine::IResource|ResourceQualifiedName] '.' peripheral=[machine::Peripheral|IID] 'at'
		//position=[machine::SymbolicPosition|IID]
		public Group getGroup() { return cGroup; }
		
		//resource=[machine::IResource|ResourceQualifiedName]
		public Assignment getResourceAssignment_0() { return cResourceAssignment_0; }
		
		//[machine::IResource|ResourceQualifiedName]
		public CrossReference getResourceIResourceCrossReference_0_0() { return cResourceIResourceCrossReference_0_0; }
		
		//ResourceQualifiedName
		public RuleCall getResourceIResourceResourceQualifiedNameParserRuleCall_0_0_1() { return cResourceIResourceResourceQualifiedNameParserRuleCall_0_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_1() { return cFullStopKeyword_1; }
		
		//peripheral=[machine::Peripheral|IID]
		public Assignment getPeripheralAssignment_2() { return cPeripheralAssignment_2; }
		
		//[machine::Peripheral|IID]
		public CrossReference getPeripheralPeripheralCrossReference_2_0() { return cPeripheralPeripheralCrossReference_2_0; }
		
		//IID
		public RuleCall getPeripheralPeripheralIIDParserRuleCall_2_0_1() { return cPeripheralPeripheralIIDParserRuleCall_2_0_1; }
		
		//'at'
		public Keyword getAtKeyword_3() { return cAtKeyword_3; }
		
		//position=[machine::SymbolicPosition|IID]
		public Assignment getPositionAssignment_4() { return cPositionAssignment_4; }
		
		//[machine::SymbolicPosition|IID]
		public CrossReference getPositionSymbolicPositionCrossReference_4_0() { return cPositionSymbolicPositionCrossReference_4_0; }
		
		//IID
		public RuleCall getPositionSymbolicPositionIIDParserRuleCall_4_0_1() { return cPositionSymbolicPositionIIDParserRuleCall_4_0_1; }
	}
	public class NodeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Node");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cClaimParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cReleaseParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cSimpleActionParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cMoveParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cRequireEventParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cRaiseEventParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//Node:
		//	Claim | Release | SimpleAction | Move | RequireEvent | RaiseEvent;
		@Override public ParserRule getRule() { return rule; }
		
		//Claim | Release | SimpleAction | Move | RequireEvent | RaiseEvent
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Claim
		public RuleCall getClaimParserRuleCall_0() { return cClaimParserRuleCall_0; }
		
		//Release
		public RuleCall getReleaseParserRuleCall_1() { return cReleaseParserRuleCall_1; }
		
		//SimpleAction
		public RuleCall getSimpleActionParserRuleCall_2() { return cSimpleActionParserRuleCall_2; }
		
		//Move
		public RuleCall getMoveParserRuleCall_3() { return cMoveParserRuleCall_3; }
		
		//RequireEvent
		public RuleCall getRequireEventParserRuleCall_4() { return cRequireEventParserRuleCall_4; }
		
		//RaiseEvent
		public RuleCall getRaiseEventParserRuleCall_5() { return cRaiseEventParserRuleCall_5; }
	}
	public class ClaimElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Claim");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cClaimAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Assignment cPassiveAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final Keyword cPassivePassiveKeyword_4_0 = (Keyword)cPassiveAssignment_4.eContents().get(0);
		private final Keyword cClaimKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cResourceAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final CrossReference cResourceIResourceCrossReference_6_0 = (CrossReference)cResourceAssignment_6.eContents().get(0);
		private final RuleCall cResourceIResourceResourceQualifiedNameParserRuleCall_6_0_1 = (RuleCall)cResourceIResourceCrossReference_6_0.eContents().get(1);
		private final Alternatives cAlternatives_7 = (Alternatives)cGroup.eContents().get(7);
		private final Assignment cExitAssignment_7_0 = (Assignment)cAlternatives_7.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_7_0_0 = (RuleCall)cExitAssignment_7_0.eContents().get(0);
		private final Group cGroup_7_1 = (Group)cAlternatives_7.eContents().get(1);
		private final Assignment cExitAssignment_7_1_0 = (Assignment)cGroup_7_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_7_1_0_0 = (RuleCall)cExitAssignment_7_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_7_1_1 = (Assignment)cGroup_7_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_7_1_1_0 = (RuleCall)cOuterExitAssignment_7_1_1.eContents().get(0);
		
		//Claim:
		//	{Claim} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		//	passive?='passive'? 'claim' resource=[machine::IResource|ResourceQualifiedName] (exit=TracePoint | exit=TracePoint
		//	outerExit=TracePoint)?;
		@Override public ParserRule getRule() { return rule; }
		
		//{Claim} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)? passive?='passive'? 'claim'
		//resource=[machine::IResource|ResourceQualifiedName] (exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Group getGroup() { return cGroup; }
		
		//{Claim}
		public Action getClaimAction_0() { return cClaimAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//(entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//outerEntry=TracePoint entry=TracePoint
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//passive?='passive'?
		public Assignment getPassiveAssignment_4() { return cPassiveAssignment_4; }
		
		//'passive'
		public Keyword getPassivePassiveKeyword_4_0() { return cPassivePassiveKeyword_4_0; }
		
		//'claim'
		public Keyword getClaimKeyword_5() { return cClaimKeyword_5; }
		
		//resource=[machine::IResource|ResourceQualifiedName]
		public Assignment getResourceAssignment_6() { return cResourceAssignment_6; }
		
		//[machine::IResource|ResourceQualifiedName]
		public CrossReference getResourceIResourceCrossReference_6_0() { return cResourceIResourceCrossReference_6_0; }
		
		//ResourceQualifiedName
		public RuleCall getResourceIResourceResourceQualifiedNameParserRuleCall_6_0_1() { return cResourceIResourceResourceQualifiedNameParserRuleCall_6_0_1; }
		
		//(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Alternatives getAlternatives_7() { return cAlternatives_7; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_7_0() { return cExitAssignment_7_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_7_0_0() { return cExitTracePointParserRuleCall_7_0_0; }
		
		//exit=TracePoint outerExit=TracePoint
		public Group getGroup_7_1() { return cGroup_7_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_7_1_0() { return cExitAssignment_7_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_7_1_0_0() { return cExitTracePointParserRuleCall_7_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_7_1_1() { return cOuterExitAssignment_7_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_7_1_1_0() { return cOuterExitTracePointParserRuleCall_7_1_1_0; }
	}
	public class ReleaseElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Release");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cReleaseAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Keyword cReleaseKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cResourceAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cResourceIResourceCrossReference_5_0 = (CrossReference)cResourceAssignment_5.eContents().get(0);
		private final RuleCall cResourceIResourceResourceQualifiedNameParserRuleCall_5_0_1 = (RuleCall)cResourceIResourceCrossReference_5_0.eContents().get(1);
		private final Alternatives cAlternatives_6 = (Alternatives)cGroup.eContents().get(6);
		private final Assignment cExitAssignment_6_0 = (Assignment)cAlternatives_6.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_6_0_0 = (RuleCall)cExitAssignment_6_0.eContents().get(0);
		private final Group cGroup_6_1 = (Group)cAlternatives_6.eContents().get(1);
		private final Assignment cExitAssignment_6_1_0 = (Assignment)cGroup_6_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_6_1_0_0 = (RuleCall)cExitAssignment_6_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_6_1_1 = (Assignment)cGroup_6_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_6_1_1_0 = (RuleCall)cOuterExitAssignment_6_1_1.eContents().get(0);
		
		//Release:
		//	{Release} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		//	'release' resource=[machine::IResource|ResourceQualifiedName] (exit=TracePoint | exit=TracePoint
		//	outerExit=TracePoint)?;
		@Override public ParserRule getRule() { return rule; }
		
		//{Release} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)? 'release'
		//resource=[machine::IResource|ResourceQualifiedName] (exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Group getGroup() { return cGroup; }
		
		//{Release}
		public Action getReleaseAction_0() { return cReleaseAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//(entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//outerEntry=TracePoint entry=TracePoint
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//'release'
		public Keyword getReleaseKeyword_4() { return cReleaseKeyword_4; }
		
		//resource=[machine::IResource|ResourceQualifiedName]
		public Assignment getResourceAssignment_5() { return cResourceAssignment_5; }
		
		//[machine::IResource|ResourceQualifiedName]
		public CrossReference getResourceIResourceCrossReference_5_0() { return cResourceIResourceCrossReference_5_0; }
		
		//ResourceQualifiedName
		public RuleCall getResourceIResourceResourceQualifiedNameParserRuleCall_5_0_1() { return cResourceIResourceResourceQualifiedNameParserRuleCall_5_0_1; }
		
		//(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Alternatives getAlternatives_6() { return cAlternatives_6; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_6_0() { return cExitAssignment_6_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_6_0_0() { return cExitTracePointParserRuleCall_6_0_0; }
		
		//exit=TracePoint outerExit=TracePoint
		public Group getGroup_6_1() { return cGroup_6_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_6_1_0() { return cExitAssignment_6_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_6_1_0_0() { return cExitTracePointParserRuleCall_6_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_6_1_1() { return cOuterExitAssignment_6_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_6_1_1_0() { return cOuterExitTracePointParserRuleCall_6_1_1_0; }
	}
	public class RaiseEventElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.RaiseEvent");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cRaiseEventAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cRaiseKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cEventNameAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cEventNameIIDParserRuleCall_4_0 = (RuleCall)cEventNameAssignment_4.eContents().get(0);
		
		//RaiseEvent:
		//	{RaiseEvent} name=IID ':'
		//	'raise' eventName=IID;
		@Override public ParserRule getRule() { return rule; }
		
		//{RaiseEvent} name=IID ':' 'raise' eventName=IID
		public Group getGroup() { return cGroup; }
		
		//{RaiseEvent}
		public Action getRaiseEventAction_0() { return cRaiseEventAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//'raise'
		public Keyword getRaiseKeyword_3() { return cRaiseKeyword_3; }
		
		//eventName=IID
		public Assignment getEventNameAssignment_4() { return cEventNameAssignment_4; }
		
		//IID
		public RuleCall getEventNameIIDParserRuleCall_4_0() { return cEventNameIIDParserRuleCall_4_0; }
	}
	public class RequireEventElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.RequireEvent");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cRequireEventAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cRequireKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cEventNameAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cEventNameIIDParserRuleCall_4_0 = (RuleCall)cEventNameAssignment_4.eContents().get(0);
		
		//RequireEvent:
		//	{RequireEvent} name=IID ':'
		//	'require' eventName=IID;
		@Override public ParserRule getRule() { return rule; }
		
		//{RequireEvent} name=IID ':' 'require' eventName=IID
		public Group getGroup() { return cGroup; }
		
		//{RequireEvent}
		public Action getRequireEventAction_0() { return cRequireEventAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//'require'
		public Keyword getRequireKeyword_3() { return cRequireKeyword_3; }
		
		//eventName=IID
		public Assignment getEventNameAssignment_4() { return cEventNameAssignment_4; }
		
		//IID
		public RuleCall getEventNameIIDParserRuleCall_4_0() { return cEventNameIIDParserRuleCall_4_0; }
	}
	public class MoveElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Move");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMoveAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Keyword cMoveKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cResourceAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cResourceIResourceCrossReference_5_0 = (CrossReference)cResourceAssignment_5.eContents().get(0);
		private final RuleCall cResourceIResourceResourceQualifiedNameParserRuleCall_5_0_1 = (RuleCall)cResourceIResourceCrossReference_5_0.eContents().get(1);
		private final Keyword cFullStopKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cPeripheralAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final CrossReference cPeripheralPeripheralCrossReference_7_0 = (CrossReference)cPeripheralAssignment_7.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIIDParserRuleCall_7_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_7_0.eContents().get(1);
		private final Alternatives cAlternatives_8 = (Alternatives)cGroup.eContents().get(8);
		private final Group cGroup_8_0 = (Group)cAlternatives_8.eContents().get(0);
		private final Alternatives cAlternatives_8_0_0 = (Alternatives)cGroup_8_0.eContents().get(0);
		private final Assignment cPassingAssignment_8_0_0_0 = (Assignment)cAlternatives_8_0_0.eContents().get(0);
		private final Keyword cPassingPassingKeyword_8_0_0_0_0 = (Keyword)cPassingAssignment_8_0_0_0.eContents().get(0);
		private final Keyword cToKeyword_8_0_0_1 = (Keyword)cAlternatives_8_0_0.eContents().get(1);
		private final Assignment cTargetPositionAssignment_8_0_1 = (Assignment)cGroup_8_0.eContents().get(1);
		private final CrossReference cTargetPositionSymbolicPositionCrossReference_8_0_1_0 = (CrossReference)cTargetPositionAssignment_8_0_1.eContents().get(0);
		private final RuleCall cTargetPositionSymbolicPositionIIDParserRuleCall_8_0_1_0_1 = (RuleCall)cTargetPositionSymbolicPositionCrossReference_8_0_1_0.eContents().get(1);
		private final Group cGroup_8_1 = (Group)cAlternatives_8.eContents().get(1);
		private final Alternatives cAlternatives_8_1_0 = (Alternatives)cGroup_8_1.eContents().get(0);
		private final Assignment cContinuingAssignment_8_1_0_0 = (Assignment)cAlternatives_8_1_0.eContents().get(0);
		private final Keyword cContinuingContinuingKeyword_8_1_0_0_0 = (Keyword)cContinuingAssignment_8_1_0_0.eContents().get(0);
		private final Keyword cForKeyword_8_1_0_1 = (Keyword)cAlternatives_8_1_0.eContents().get(1);
		private final Assignment cDistanceAssignment_8_1_1 = (Assignment)cGroup_8_1.eContents().get(1);
		private final CrossReference cDistanceDistanceCrossReference_8_1_1_0 = (CrossReference)cDistanceAssignment_8_1_1.eContents().get(0);
		private final RuleCall cDistanceDistanceIIDParserRuleCall_8_1_1_0_1 = (RuleCall)cDistanceDistanceCrossReference_8_1_1_0.eContents().get(1);
		private final Group cGroup_9 = (Group)cGroup.eContents().get(9);
		private final Keyword cWithSpeedProfileKeyword_9_0 = (Keyword)cGroup_9.eContents().get(0);
		private final Assignment cProfileAssignment_9_1 = (Assignment)cGroup_9.eContents().get(1);
		private final CrossReference cProfileProfileCrossReference_9_1_0 = (CrossReference)cProfileAssignment_9_1.eContents().get(0);
		private final RuleCall cProfileProfileIIDParserRuleCall_9_1_0_1 = (RuleCall)cProfileProfileCrossReference_9_1_0.eContents().get(1);
		private final Assignment cSchedulingTypeAssignment_10 = (Assignment)cGroup.eContents().get(10);
		private final RuleCall cSchedulingTypeSchedulingEnumRuleCall_10_0 = (RuleCall)cSchedulingTypeAssignment_10.eContents().get(0);
		private final Alternatives cAlternatives_11 = (Alternatives)cGroup.eContents().get(11);
		private final Assignment cExitAssignment_11_0 = (Assignment)cAlternatives_11.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_11_0_0 = (RuleCall)cExitAssignment_11_0.eContents().get(0);
		private final Group cGroup_11_1 = (Group)cAlternatives_11.eContents().get(1);
		private final Assignment cExitAssignment_11_1_0 = (Assignment)cGroup_11_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_11_1_0_0 = (RuleCall)cExitAssignment_11_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_11_1_1 = (Assignment)cGroup_11_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_11_1_1_0 = (RuleCall)cOuterExitAssignment_11_1_1.eContents().get(0);
		
		//Move:
		//	{Move} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		//	'move' resource=[machine::IResource|ResourceQualifiedName] '.' peripheral=[machine::Peripheral|IID]
		//	((passing?='passing' | 'to') targetPosition=[machine::SymbolicPosition|IID] | (continuing?='continuing' | 'for')
		//	distance=[machine::Distance|IID]) ('with speed profile' profile=[machine::Profile|IID]) schedulingType=Scheduling?
		//	(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?;
		@Override public ParserRule getRule() { return rule; }
		
		//{Move} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)? 'move'
		//resource=[machine::IResource|ResourceQualifiedName] '.' peripheral=[machine::Peripheral|IID] ((passing?='passing' |
		//'to') targetPosition=[machine::SymbolicPosition|IID] | (continuing?='continuing' | 'for')
		//distance=[machine::Distance|IID]) ('with speed profile' profile=[machine::Profile|IID]) schedulingType=Scheduling?
		//(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Group getGroup() { return cGroup; }
		
		//{Move}
		public Action getMoveAction_0() { return cMoveAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//(entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//outerEntry=TracePoint entry=TracePoint
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//'move'
		public Keyword getMoveKeyword_4() { return cMoveKeyword_4; }
		
		//resource=[machine::IResource|ResourceQualifiedName]
		public Assignment getResourceAssignment_5() { return cResourceAssignment_5; }
		
		//[machine::IResource|ResourceQualifiedName]
		public CrossReference getResourceIResourceCrossReference_5_0() { return cResourceIResourceCrossReference_5_0; }
		
		//ResourceQualifiedName
		public RuleCall getResourceIResourceResourceQualifiedNameParserRuleCall_5_0_1() { return cResourceIResourceResourceQualifiedNameParserRuleCall_5_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_6() { return cFullStopKeyword_6; }
		
		//peripheral=[machine::Peripheral|IID]
		public Assignment getPeripheralAssignment_7() { return cPeripheralAssignment_7; }
		
		//[machine::Peripheral|IID]
		public CrossReference getPeripheralPeripheralCrossReference_7_0() { return cPeripheralPeripheralCrossReference_7_0; }
		
		//IID
		public RuleCall getPeripheralPeripheralIIDParserRuleCall_7_0_1() { return cPeripheralPeripheralIIDParserRuleCall_7_0_1; }
		
		//((passing?='passing' | 'to') targetPosition=[machine::SymbolicPosition|IID] | (continuing?='continuing' | 'for')
		//distance=[machine::Distance|IID])
		public Alternatives getAlternatives_8() { return cAlternatives_8; }
		
		//(passing?='passing' | 'to') targetPosition=[machine::SymbolicPosition|IID]
		public Group getGroup_8_0() { return cGroup_8_0; }
		
		//(passing?='passing' | 'to')
		public Alternatives getAlternatives_8_0_0() { return cAlternatives_8_0_0; }
		
		//passing?='passing'
		public Assignment getPassingAssignment_8_0_0_0() { return cPassingAssignment_8_0_0_0; }
		
		//'passing'
		public Keyword getPassingPassingKeyword_8_0_0_0_0() { return cPassingPassingKeyword_8_0_0_0_0; }
		
		//'to'
		public Keyword getToKeyword_8_0_0_1() { return cToKeyword_8_0_0_1; }
		
		//targetPosition=[machine::SymbolicPosition|IID]
		public Assignment getTargetPositionAssignment_8_0_1() { return cTargetPositionAssignment_8_0_1; }
		
		//[machine::SymbolicPosition|IID]
		public CrossReference getTargetPositionSymbolicPositionCrossReference_8_0_1_0() { return cTargetPositionSymbolicPositionCrossReference_8_0_1_0; }
		
		//IID
		public RuleCall getTargetPositionSymbolicPositionIIDParserRuleCall_8_0_1_0_1() { return cTargetPositionSymbolicPositionIIDParserRuleCall_8_0_1_0_1; }
		
		//(continuing?='continuing' | 'for') distance=[machine::Distance|IID]
		public Group getGroup_8_1() { return cGroup_8_1; }
		
		//(continuing?='continuing' | 'for')
		public Alternatives getAlternatives_8_1_0() { return cAlternatives_8_1_0; }
		
		//continuing?='continuing'
		public Assignment getContinuingAssignment_8_1_0_0() { return cContinuingAssignment_8_1_0_0; }
		
		//'continuing'
		public Keyword getContinuingContinuingKeyword_8_1_0_0_0() { return cContinuingContinuingKeyword_8_1_0_0_0; }
		
		//'for'
		public Keyword getForKeyword_8_1_0_1() { return cForKeyword_8_1_0_1; }
		
		//distance=[machine::Distance|IID]
		public Assignment getDistanceAssignment_8_1_1() { return cDistanceAssignment_8_1_1; }
		
		//[machine::Distance|IID]
		public CrossReference getDistanceDistanceCrossReference_8_1_1_0() { return cDistanceDistanceCrossReference_8_1_1_0; }
		
		//IID
		public RuleCall getDistanceDistanceIIDParserRuleCall_8_1_1_0_1() { return cDistanceDistanceIIDParserRuleCall_8_1_1_0_1; }
		
		//('with speed profile' profile=[machine::Profile|IID])
		public Group getGroup_9() { return cGroup_9; }
		
		//'with speed profile'
		public Keyword getWithSpeedProfileKeyword_9_0() { return cWithSpeedProfileKeyword_9_0; }
		
		//profile=[machine::Profile|IID]
		public Assignment getProfileAssignment_9_1() { return cProfileAssignment_9_1; }
		
		//[machine::Profile|IID]
		public CrossReference getProfileProfileCrossReference_9_1_0() { return cProfileProfileCrossReference_9_1_0; }
		
		//IID
		public RuleCall getProfileProfileIIDParserRuleCall_9_1_0_1() { return cProfileProfileIIDParserRuleCall_9_1_0_1; }
		
		//schedulingType=Scheduling?
		public Assignment getSchedulingTypeAssignment_10() { return cSchedulingTypeAssignment_10; }
		
		//Scheduling
		public RuleCall getSchedulingTypeSchedulingEnumRuleCall_10_0() { return cSchedulingTypeSchedulingEnumRuleCall_10_0; }
		
		//(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Alternatives getAlternatives_11() { return cAlternatives_11; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_11_0() { return cExitAssignment_11_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_11_0_0() { return cExitTracePointParserRuleCall_11_0_0; }
		
		//exit=TracePoint outerExit=TracePoint
		public Group getGroup_11_1() { return cGroup_11_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_11_1_0() { return cExitAssignment_11_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_11_1_0_0() { return cExitTracePointParserRuleCall_11_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_11_1_1() { return cOuterExitAssignment_11_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_11_1_1_0() { return cOuterExitTracePointParserRuleCall_11_1_1_0; }
	}
	public class SimpleActionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.SimpleAction");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSimpleActionAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Assignment cResourceAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cResourceIResourceCrossReference_4_0 = (CrossReference)cResourceAssignment_4.eContents().get(0);
		private final RuleCall cResourceIResourceResourceQualifiedNameParserRuleCall_4_0_1 = (RuleCall)cResourceIResourceCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cFullStopKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cPeripheralAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final CrossReference cPeripheralPeripheralCrossReference_5_1_0 = (CrossReference)cPeripheralAssignment_5_1.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIIDParserRuleCall_5_1_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_5_1_0.eContents().get(1);
		private final Keyword cFullStopKeyword_5_2 = (Keyword)cGroup_5.eContents().get(2);
		private final Assignment cTypeAssignment_5_3 = (Assignment)cGroup_5.eContents().get(3);
		private final CrossReference cTypeActionTypeCrossReference_5_3_0 = (CrossReference)cTypeAssignment_5_3.eContents().get(0);
		private final RuleCall cTypeActionTypeIIDParserRuleCall_5_3_0_1 = (RuleCall)cTypeActionTypeCrossReference_5_3_0.eContents().get(1);
		private final Assignment cSchedulingTypeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cSchedulingTypeSchedulingEnumRuleCall_6_0 = (RuleCall)cSchedulingTypeAssignment_6.eContents().get(0);
		private final Alternatives cAlternatives_7 = (Alternatives)cGroup.eContents().get(7);
		private final Assignment cExitAssignment_7_0 = (Assignment)cAlternatives_7.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_7_0_0 = (RuleCall)cExitAssignment_7_0.eContents().get(0);
		private final Group cGroup_7_1 = (Group)cAlternatives_7.eContents().get(1);
		private final Assignment cExitAssignment_7_1_0 = (Assignment)cGroup_7_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_7_1_0_0 = (RuleCall)cExitAssignment_7_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_7_1_1 = (Assignment)cGroup_7_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_7_1_1_0 = (RuleCall)cOuterExitAssignment_7_1_1.eContents().get(0);
		
		///**
		// * The '=>' below helps the parser to first check peripheral and type before analysing Resource.
		// * see https://dslmeinte.wordpress.com/2011/12/05/using-syntactic-predicates-in-xtext-part-1/
		// * for more info.
		// */ SimpleAction:
		//	{SimpleAction} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		//	resource=[machine::IResource|ResourceQualifiedName] (=> '.' peripheral=[machine::Peripheral|IID] '.'
		//	type=[machine::ActionType|IID]) schedulingType=Scheduling? (exit=TracePoint | exit=TracePoint outerExit=TracePoint)?;
		@Override public ParserRule getRule() { return rule; }
		
		//{SimpleAction} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		//resource=[machine::IResource|ResourceQualifiedName] (=> '.' peripheral=[machine::Peripheral|IID] '.'
		//type=[machine::ActionType|IID]) schedulingType=Scheduling? (exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Group getGroup() { return cGroup; }
		
		//{SimpleAction}
		public Action getSimpleActionAction_0() { return cSimpleActionAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//(entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//outerEntry=TracePoint entry=TracePoint
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//resource=[machine::IResource|ResourceQualifiedName]
		public Assignment getResourceAssignment_4() { return cResourceAssignment_4; }
		
		//[machine::IResource|ResourceQualifiedName]
		public CrossReference getResourceIResourceCrossReference_4_0() { return cResourceIResourceCrossReference_4_0; }
		
		//ResourceQualifiedName
		public RuleCall getResourceIResourceResourceQualifiedNameParserRuleCall_4_0_1() { return cResourceIResourceResourceQualifiedNameParserRuleCall_4_0_1; }
		
		//(=> '.' peripheral=[machine::Peripheral|IID] '.' type=[machine::ActionType|IID])
		public Group getGroup_5() { return cGroup_5; }
		
		//=> '.'
		public Keyword getFullStopKeyword_5_0() { return cFullStopKeyword_5_0; }
		
		//peripheral=[machine::Peripheral|IID]
		public Assignment getPeripheralAssignment_5_1() { return cPeripheralAssignment_5_1; }
		
		//[machine::Peripheral|IID]
		public CrossReference getPeripheralPeripheralCrossReference_5_1_0() { return cPeripheralPeripheralCrossReference_5_1_0; }
		
		//IID
		public RuleCall getPeripheralPeripheralIIDParserRuleCall_5_1_0_1() { return cPeripheralPeripheralIIDParserRuleCall_5_1_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_5_2() { return cFullStopKeyword_5_2; }
		
		//type=[machine::ActionType|IID]
		public Assignment getTypeAssignment_5_3() { return cTypeAssignment_5_3; }
		
		//[machine::ActionType|IID]
		public CrossReference getTypeActionTypeCrossReference_5_3_0() { return cTypeActionTypeCrossReference_5_3_0; }
		
		//IID
		public RuleCall getTypeActionTypeIIDParserRuleCall_5_3_0_1() { return cTypeActionTypeIIDParserRuleCall_5_3_0_1; }
		
		//schedulingType=Scheduling?
		public Assignment getSchedulingTypeAssignment_6() { return cSchedulingTypeAssignment_6; }
		
		//Scheduling
		public RuleCall getSchedulingTypeSchedulingEnumRuleCall_6_0() { return cSchedulingTypeSchedulingEnumRuleCall_6_0; }
		
		//(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?
		public Alternatives getAlternatives_7() { return cAlternatives_7; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_7_0() { return cExitAssignment_7_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_7_0_0() { return cExitTracePointParserRuleCall_7_0_0; }
		
		//exit=TracePoint outerExit=TracePoint
		public Group getGroup_7_1() { return cGroup_7_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_7_1_0() { return cExitAssignment_7_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_7_1_0_0() { return cExitTracePointParserRuleCall_7_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_7_1_1() { return cOuterExitAssignment_7_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_7_1_1_0() { return cOuterExitTracePointParserRuleCall_7_1_1_0; }
	}
	public class TracePointElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TracePoint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cRegexAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final Keyword cRegexTildeKeyword_1_0 = (Keyword)cRegexAssignment_1.eContents().get(0);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueEStringParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//TracePoint:
		//	'[' regex?='~'? value=EString ']';
		@Override public ParserRule getRule() { return rule; }
		
		//'[' regex?='~'? value=EString ']'
		public Group getGroup() { return cGroup; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }
		
		//regex?='~'?
		public Assignment getRegexAssignment_1() { return cRegexAssignment_1; }
		
		//'~'
		public Keyword getRegexTildeKeyword_1_0() { return cRegexTildeKeyword_1_0; }
		
		//value=EString
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//EString
		public RuleCall getValueEStringParserRuleCall_2_0() { return cValueEStringParserRuleCall_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_3() { return cRightSquareBracketKeyword_3; }
	}
	public class EdgesElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Edges");
		private final RuleCall cEdgeParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Edges Edge:
		//	Edge;
		@Override public ParserRule getRule() { return rule; }
		
		//Edge
		public RuleCall getEdgeParserRuleCall() { return cEdgeParserRuleCall; }
	}
	public class EdgeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Edge");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cEdgeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSourceSourceReferenceParserRuleCall_1_0 = (RuleCall)cSourceAssignment_1.eContents().get(0);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cTargetAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cTargetDependencyTargetParserRuleCall_3_0 = (RuleCall)cTargetAssignment_3.eContents().get(0);
		
		//Edge:
		//	{Edge} source=SourceReference '->' target=DependencyTarget;
		@Override public ParserRule getRule() { return rule; }
		
		//{Edge} source=SourceReference '->' target=DependencyTarget
		public Group getGroup() { return cGroup; }
		
		//{Edge}
		public Action getEdgeAction_0() { return cEdgeAction_0; }
		
		//source=SourceReference
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//SourceReference
		public RuleCall getSourceSourceReferenceParserRuleCall_1_0() { return cSourceSourceReferenceParserRuleCall_1_0; }
		
		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusGreaterThanSignKeyword_2; }
		
		//target=DependencyTarget
		public Assignment getTargetAssignment_3() { return cTargetAssignment_3; }
		
		//DependencyTarget
		public RuleCall getTargetDependencyTargetParserRuleCall_3_0() { return cTargetDependencyTargetParserRuleCall_3_0; }
	}
	public class SourceReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.SourceReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSourceReferenceAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cNodeAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final CrossReference cNodeActionCrossReference_1_0_0 = (CrossReference)cNodeAssignment_1_0.eContents().get(0);
		private final RuleCall cNodeActionIIDParserRuleCall_1_0_0_1 = (RuleCall)cNodeActionCrossReference_1_0_0.eContents().get(1);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final Keyword cVerticalLineKeyword_1_1_0 = (Keyword)cGroup_1_1.eContents().get(0);
		private final Assignment cNodeAssignment_1_1_1 = (Assignment)cGroup_1_1.eContents().get(1);
		private final CrossReference cNodeSyncBarCrossReference_1_1_1_0 = (CrossReference)cNodeAssignment_1_1_1.eContents().get(0);
		private final RuleCall cNodeSyncBarIIDParserRuleCall_1_1_1_0_1 = (RuleCall)cNodeSyncBarCrossReference_1_1_1_0.eContents().get(1);
		
		//SourceReference:
		//	{SourceReference} (node=[Action|IID] | '|' node=[SyncBar|IID]);
		@Override public ParserRule getRule() { return rule; }
		
		//{SourceReference} (node=[Action|IID] | '|' node=[SyncBar|IID])
		public Group getGroup() { return cGroup; }
		
		//{SourceReference}
		public Action getSourceReferenceAction_0() { return cSourceReferenceAction_0; }
		
		//(node=[Action|IID] | '|' node=[SyncBar|IID])
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//node=[Action|IID]
		public Assignment getNodeAssignment_1_0() { return cNodeAssignment_1_0; }
		
		//[Action|IID]
		public CrossReference getNodeActionCrossReference_1_0_0() { return cNodeActionCrossReference_1_0_0; }
		
		//IID
		public RuleCall getNodeActionIIDParserRuleCall_1_0_0_1() { return cNodeActionIIDParserRuleCall_1_0_0_1; }
		
		//'|' node=[SyncBar|IID]
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//'|'
		public Keyword getVerticalLineKeyword_1_1_0() { return cVerticalLineKeyword_1_1_0; }
		
		//node=[SyncBar|IID]
		public Assignment getNodeAssignment_1_1_1() { return cNodeAssignment_1_1_1; }
		
		//[SyncBar|IID]
		public CrossReference getNodeSyncBarCrossReference_1_1_1_0() { return cNodeSyncBarCrossReference_1_1_1_0; }
		
		//IID
		public RuleCall getNodeSyncBarIIDParserRuleCall_1_1_1_0_1() { return cNodeSyncBarIIDParserRuleCall_1_1_1_0_1; }
	}
	public class DependencyTargetElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.DependencyTarget");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cTargetReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEdgeParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//DependencyTarget EdgeTarget:
		//	TargetReference | Edge;
		@Override public ParserRule getRule() { return rule; }
		
		//TargetReference | Edge
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//TargetReference
		public RuleCall getTargetReferenceParserRuleCall_0() { return cTargetReferenceParserRuleCall_0; }
		
		//Edge
		public RuleCall getEdgeParserRuleCall_1() { return cEdgeParserRuleCall_1; }
	}
	public class TargetReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TargetReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cTargetReferenceAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cNodeAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final CrossReference cNodeActionCrossReference_1_0_0 = (CrossReference)cNodeAssignment_1_0.eContents().get(0);
		private final RuleCall cNodeActionIIDParserRuleCall_1_0_0_1 = (RuleCall)cNodeActionCrossReference_1_0_0.eContents().get(1);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final Keyword cVerticalLineKeyword_1_1_0 = (Keyword)cGroup_1_1.eContents().get(0);
		private final Assignment cNodeAssignment_1_1_1 = (Assignment)cGroup_1_1.eContents().get(1);
		private final CrossReference cNodeSyncBarCrossReference_1_1_1_0 = (CrossReference)cNodeAssignment_1_1_1.eContents().get(0);
		private final RuleCall cNodeSyncBarIIDParserRuleCall_1_1_1_0_1 = (RuleCall)cNodeSyncBarCrossReference_1_1_1_0.eContents().get(1);
		
		//TargetReference:
		//	{TargetReference} (node=[Action|IID] | '|' node=[SyncBar|IID]);
		@Override public ParserRule getRule() { return rule; }
		
		//{TargetReference} (node=[Action|IID] | '|' node=[SyncBar|IID])
		public Group getGroup() { return cGroup; }
		
		//{TargetReference}
		public Action getTargetReferenceAction_0() { return cTargetReferenceAction_0; }
		
		//(node=[Action|IID] | '|' node=[SyncBar|IID])
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//node=[Action|IID]
		public Assignment getNodeAssignment_1_0() { return cNodeAssignment_1_0; }
		
		//[Action|IID]
		public CrossReference getNodeActionCrossReference_1_0_0() { return cNodeActionCrossReference_1_0_0; }
		
		//IID
		public RuleCall getNodeActionIIDParserRuleCall_1_0_0_1() { return cNodeActionIIDParserRuleCall_1_0_0_1; }
		
		//'|' node=[SyncBar|IID]
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//'|'
		public Keyword getVerticalLineKeyword_1_1_0() { return cVerticalLineKeyword_1_1_0; }
		
		//node=[SyncBar|IID]
		public Assignment getNodeAssignment_1_1_1() { return cNodeAssignment_1_1_1; }
		
		//[SyncBar|IID]
		public CrossReference getNodeSyncBarCrossReference_1_1_1_0() { return cNodeSyncBarCrossReference_1_1_1_0; }
		
		//IID
		public RuleCall getNodeSyncBarIIDParserRuleCall_1_1_1_0_1() { return cNodeSyncBarIIDParserRuleCall_1_1_1_0_1; }
	}
	public class IIDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.IID");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//IID:
		//	INT | ID;
		@Override public ParserRule getRule() { return rule; }
		
		//INT | ID
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_0() { return cINTTerminalRuleCall_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1() { return cIDTerminalRuleCall_1; }
	}
	public class NodeQualifiedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.NodeQualifiedName");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cIDTerminalRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1_1 = (RuleCall)cGroup_1.eContents().get(1);
		
		//NodeQualifiedName:
		//	ID ('.' ID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//ID ('.' ID)?
		public Group getGroup() { return cGroup; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_0() { return cIDTerminalRuleCall_0; }
		
		//('.' ID)?
		public Group getGroup_1() { return cGroup_1; }
		
		//'.'
		public Keyword getFullStopKeyword_1_0() { return cFullStopKeyword_1_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1_1() { return cIDTerminalRuleCall_1_1; }
	}
	public class EStringElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EString");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSTRINGTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//EString:
		//	STRING | ID;
		@Override public ParserRule getRule() { return rule; }
		
		//STRING | ID
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//STRING
		public RuleCall getSTRINGTerminalRuleCall_0() { return cSTRINGTerminalRuleCall_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1() { return cIDTerminalRuleCall_1; }
	}
	
	public class SchedulingElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Scheduling");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cASAPEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cASAPASAPKeyword_0_0 = (Keyword)cASAPEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cALAPEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cALAPALAPKeyword_1_0 = (Keyword)cALAPEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum Scheduling returns SchedulingType:
		//	ASAP | ALAP;
		public EnumRule getRule() { return rule; }
		
		//ASAP | ALAP
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ASAP
		public EnumLiteralDeclaration getASAPEnumLiteralDeclaration_0() { return cASAPEnumLiteralDeclaration_0; }
		
		//'ASAP'
		public Keyword getASAPASAPKeyword_0_0() { return cASAPASAPKeyword_0_0; }
		
		//ALAP
		public EnumLiteralDeclaration getALAPEnumLiteralDeclaration_1() { return cALAPEnumLiteralDeclaration_1; }
		
		//'ALAP'
		public Keyword getALAPALAPKeyword_1_0() { return cALAPALAPKeyword_1_0; }
	}
	
	private final ActivitySetElements pActivitySet;
	private final ImportElements pImport;
	private final ActivityElements pActivity;
	private final ResourceQualifiedNameElements pResourceQualifiedName;
	private final LocationPrerequisiteElements pLocationPrerequisite;
	private final NodeElements pNode;
	private final ClaimElements pClaim;
	private final ReleaseElements pRelease;
	private final RaiseEventElements pRaiseEvent;
	private final RequireEventElements pRequireEvent;
	private final MoveElements pMove;
	private final SchedulingElements eScheduling;
	private final SimpleActionElements pSimpleAction;
	private final TracePointElements pTracePoint;
	private final EdgesElements pEdges;
	private final EdgeElements pEdge;
	private final SourceReferenceElements pSourceReference;
	private final DependencyTargetElements pDependencyTarget;
	private final TargetReferenceElements pTargetReference;
	private final IIDElements pIID;
	private final NodeQualifiedNameElements pNodeQualifiedName;
	private final EStringElements pEString;
	
	private final Grammar grammar;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public ActivityGrammarAccess(GrammarProvider grammarProvider,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaTerminals = gaTerminals;
		this.pActivitySet = new ActivitySetElements();
		this.pImport = new ImportElements();
		this.pActivity = new ActivityElements();
		this.pResourceQualifiedName = new ResourceQualifiedNameElements();
		this.pLocationPrerequisite = new LocationPrerequisiteElements();
		this.pNode = new NodeElements();
		this.pClaim = new ClaimElements();
		this.pRelease = new ReleaseElements();
		this.pRaiseEvent = new RaiseEventElements();
		this.pRequireEvent = new RequireEventElements();
		this.pMove = new MoveElements();
		this.eScheduling = new SchedulingElements();
		this.pSimpleAction = new SimpleActionElements();
		this.pTracePoint = new TracePointElements();
		this.pEdges = new EdgesElements();
		this.pEdge = new EdgeElements();
		this.pSourceReference = new SourceReferenceElements();
		this.pDependencyTarget = new DependencyTargetElements();
		this.pTargetReference = new TargetReferenceElements();
		this.pIID = new IIDElements();
		this.pNodeQualifiedName = new NodeQualifiedNameElements();
		this.pEString = new EStringElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.lsat.activity.teditor.Activity".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//ActivitySet:
	//	{ActivitySet} imports+=Import*
	//	activities+=Activity*;
	public ActivitySetElements getActivitySetAccess() {
		return pActivitySet;
	}
	
	public ParserRule getActivitySetRule() {
		return getActivitySetAccess().getRule();
	}
	
	//Import machine::Import:
	//	"import" importURI=STRING;
	public ImportElements getImportAccess() {
		return pImport;
	}
	
	public ParserRule getImportRule() {
		return getImportAccess().getRule();
	}
	
	//Activity:
	//	'activity' name=IID '{' ('prerequisites' '{' prerequisites+=LocationPrerequisite* '}')?
	//	'actions' '{' nodes+=Node* '}'
	//	'action flow' '{' edges+=Edges* '}'
	//	'}';
	public ActivityElements getActivityAccess() {
		return pActivity;
	}
	
	public ParserRule getActivityRule() {
		return getActivityAccess().getRule();
	}
	
	//ResourceQualifiedName:
	//	IID ('.' IID)?;
	public ResourceQualifiedNameElements getResourceQualifiedNameAccess() {
		return pResourceQualifiedName;
	}
	
	public ParserRule getResourceQualifiedNameRule() {
		return getResourceQualifiedNameAccess().getRule();
	}
	
	//LocationPrerequisite:
	//	resource=[machine::IResource|ResourceQualifiedName] '.' peripheral=[machine::Peripheral|IID] 'at'
	//	position=[machine::SymbolicPosition|IID];
	public LocationPrerequisiteElements getLocationPrerequisiteAccess() {
		return pLocationPrerequisite;
	}
	
	public ParserRule getLocationPrerequisiteRule() {
		return getLocationPrerequisiteAccess().getRule();
	}
	
	//Node:
	//	Claim | Release | SimpleAction | Move | RequireEvent | RaiseEvent;
	public NodeElements getNodeAccess() {
		return pNode;
	}
	
	public ParserRule getNodeRule() {
		return getNodeAccess().getRule();
	}
	
	//Claim:
	//	{Claim} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
	//	passive?='passive'? 'claim' resource=[machine::IResource|ResourceQualifiedName] (exit=TracePoint | exit=TracePoint
	//	outerExit=TracePoint)?;
	public ClaimElements getClaimAccess() {
		return pClaim;
	}
	
	public ParserRule getClaimRule() {
		return getClaimAccess().getRule();
	}
	
	//Release:
	//	{Release} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
	//	'release' resource=[machine::IResource|ResourceQualifiedName] (exit=TracePoint | exit=TracePoint
	//	outerExit=TracePoint)?;
	public ReleaseElements getReleaseAccess() {
		return pRelease;
	}
	
	public ParserRule getReleaseRule() {
		return getReleaseAccess().getRule();
	}
	
	//RaiseEvent:
	//	{RaiseEvent} name=IID ':'
	//	'raise' eventName=IID;
	public RaiseEventElements getRaiseEventAccess() {
		return pRaiseEvent;
	}
	
	public ParserRule getRaiseEventRule() {
		return getRaiseEventAccess().getRule();
	}
	
	//RequireEvent:
	//	{RequireEvent} name=IID ':'
	//	'require' eventName=IID;
	public RequireEventElements getRequireEventAccess() {
		return pRequireEvent;
	}
	
	public ParserRule getRequireEventRule() {
		return getRequireEventAccess().getRule();
	}
	
	//Move:
	//	{Move} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
	//	'move' resource=[machine::IResource|ResourceQualifiedName] '.' peripheral=[machine::Peripheral|IID]
	//	((passing?='passing' | 'to') targetPosition=[machine::SymbolicPosition|IID] | (continuing?='continuing' | 'for')
	//	distance=[machine::Distance|IID]) ('with speed profile' profile=[machine::Profile|IID]) schedulingType=Scheduling?
	//	(exit=TracePoint | exit=TracePoint outerExit=TracePoint)?;
	public MoveElements getMoveAccess() {
		return pMove;
	}
	
	public ParserRule getMoveRule() {
		return getMoveAccess().getRule();
	}
	
	//enum Scheduling returns SchedulingType:
	//	ASAP | ALAP;
	public SchedulingElements getSchedulingAccess() {
		return eScheduling;
	}
	
	public EnumRule getSchedulingRule() {
		return getSchedulingAccess().getRule();
	}
	
	///**
	// * The '=>' below helps the parser to first check peripheral and type before analysing Resource.
	// * see https://dslmeinte.wordpress.com/2011/12/05/using-syntactic-predicates-in-xtext-part-1/
	// * for more info.
	// */ SimpleAction:
	//	{SimpleAction} name=IID ':' (entry=TracePoint | outerEntry=TracePoint entry=TracePoint)?
	//	resource=[machine::IResource|ResourceQualifiedName] (=> '.' peripheral=[machine::Peripheral|IID] '.'
	//	type=[machine::ActionType|IID]) schedulingType=Scheduling? (exit=TracePoint | exit=TracePoint outerExit=TracePoint)?;
	public SimpleActionElements getSimpleActionAccess() {
		return pSimpleAction;
	}
	
	public ParserRule getSimpleActionRule() {
		return getSimpleActionAccess().getRule();
	}
	
	//TracePoint:
	//	'[' regex?='~'? value=EString ']';
	public TracePointElements getTracePointAccess() {
		return pTracePoint;
	}
	
	public ParserRule getTracePointRule() {
		return getTracePointAccess().getRule();
	}
	
	//Edges Edge:
	//	Edge;
	public EdgesElements getEdgesAccess() {
		return pEdges;
	}
	
	public ParserRule getEdgesRule() {
		return getEdgesAccess().getRule();
	}
	
	//Edge:
	//	{Edge} source=SourceReference '->' target=DependencyTarget;
	public EdgeElements getEdgeAccess() {
		return pEdge;
	}
	
	public ParserRule getEdgeRule() {
		return getEdgeAccess().getRule();
	}
	
	//SourceReference:
	//	{SourceReference} (node=[Action|IID] | '|' node=[SyncBar|IID]);
	public SourceReferenceElements getSourceReferenceAccess() {
		return pSourceReference;
	}
	
	public ParserRule getSourceReferenceRule() {
		return getSourceReferenceAccess().getRule();
	}
	
	//DependencyTarget EdgeTarget:
	//	TargetReference | Edge;
	public DependencyTargetElements getDependencyTargetAccess() {
		return pDependencyTarget;
	}
	
	public ParserRule getDependencyTargetRule() {
		return getDependencyTargetAccess().getRule();
	}
	
	//TargetReference:
	//	{TargetReference} (node=[Action|IID] | '|' node=[SyncBar|IID]);
	public TargetReferenceElements getTargetReferenceAccess() {
		return pTargetReference;
	}
	
	public ParserRule getTargetReferenceRule() {
		return getTargetReferenceAccess().getRule();
	}
	
	//IID:
	//	INT | ID;
	public IIDElements getIIDAccess() {
		return pIID;
	}
	
	public ParserRule getIIDRule() {
		return getIIDAccess().getRule();
	}
	
	//NodeQualifiedName:
	//	ID ('.' ID)?;
	public NodeQualifiedNameElements getNodeQualifiedNameAccess() {
		return pNodeQualifiedName;
	}
	
	public ParserRule getNodeQualifiedNameRule() {
		return getNodeQualifiedNameAccess().getRule();
	}
	
	//EString:
	//	STRING | ID;
	public EStringElements getEStringAccess() {
		return pEString;
	}
	
	public ParserRule getEStringRule() {
		return getEStringAccess().getRule();
	}
	
	//terminal ID:
	//	'^'? ('a'..'z' | 'A'..'Z' | '_') ('a'..'z' | 'A'..'Z' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt:
	//	'0'..'9'+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//	'"' ('\\' . | !('\\' | '"'))* '"' |
	//	"'" ('\\' . | !('\\' | "'"))* "'";
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal ML_COMMENT:
	//	'/*'->'*/';
	public TerminalRule getML_COMMENTRule() {
		return gaTerminals.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT:
	//	'//' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaTerminals.getSL_COMMENTRule();
	}
	
	//terminal WS:
	//	' ' | '\t' | '\r' | '\n'+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
